/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.history.ISVNHistoryViewInfo;
import org.eclipse.team.svn.ui.history.LogMessagesComposite;
import org.eclipse.team.svn.ui.history.SVNHistoryPage;
import org.eclipse.team.svn.ui.history.data.SVNLocalFileRevision;
import org.eclipse.team.svn.ui.history.filter.AuthorNameLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.ChangeNameLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.CommentLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.CompositeLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.ILogEntryFilter;
import org.eclipse.team.svn.ui.history.model.ILogNode;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.view.HistoryFilterPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SelectRevisionPanel
extends AbstractDialogPanel
implements ISVNHistoryViewInfo {
    protected LogMessagesComposite history;
    protected SVNLogEntry[] logMessages;
    protected IRepositoryResource resource;
    protected long currentRevision;
    protected boolean multiSelect;
    protected boolean useCheckboxes;
    protected long limit;
    protected boolean pagingEnabled;
    protected SVNLogEntry[] selectedLogMessages;
    protected Text resourceLabel;
    protected ToolItem hideUnrelatedItem;
    protected ToolItem stopOnCopyItem;
    protected ToolItem pagingItem;
    protected ToolItem pagingAllItem;
    protected ToolItem filterItem;
    protected ToolItem clearFilterItem;
    protected ToolItem refreshItem;
    protected ToolItem groupByDateItem;
    protected CommentLogEntryFilter commentFilter;
    protected AuthorNameLogEntryFilter authorFilter;
    protected ChangeNameLogEntryFilter changeFilter;
    protected CompositeLogEntryFilter logEntriesFilter;
    protected ISelectionChangedListener tableViewerListener;
    protected IPropertyChangeListener configurationListener;
    protected boolean initialStopOnCopy;
    protected boolean pending;

    public SelectRevisionPanel(GetLogMessagesOperation msgOp, boolean multiSelect, boolean useCheckboxes, long currentRevision) {
        this.multiSelect = multiSelect;
        this.useCheckboxes = useCheckboxes;
        this.dialogTitle = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Title");
        this.dialogDescription = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Description");
        this.defaultMessage = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Message");
        this.resource = msgOp.getResource();
        this.currentRevision = currentRevision;
        this.logMessages = msgOp.getMessages();
        this.initialStopOnCopy = msgOp.getStopOnCopy();
        this.authorFilter = new AuthorNameLogEntryFilter();
        this.commentFilter = new CommentLogEntryFilter();
        this.changeFilter = new ChangeNameLogEntryFilter();
        this.logEntriesFilter = new CompositeLogEntryFilter(new ILogEntryFilter[]{this.authorFilter, this.commentFilter, this.changeFilter});
    }

    public static GetLogMessagesOperation getMsgsOp(IRepositoryResource resource, boolean stopOnCopy) {
        GetLogMessagesOperation msgsOp = new GetLogMessagesOperation(resource, stopOnCopy);
        msgsOp.setIncludeMerged(SVNTeamPreferences.getMergeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "includeMerged"));
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        if (SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
            msgsOp.setLimit((long)SVNTeamPreferences.getHistoryInt(store, "pageSize"));
        }
        return msgsOp;
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.revisionLinkDialogContext";
    }

    public long getSelectedRevision() {
        return this.selectedLogMessages[0].revision;
    }

    public SVNLogEntry[] getSelectedLogMessages() {
        return this.selectedLogMessages;
    }

    public SVNRevisionRange[] getSelectedRevisions() {
        ArrayList<SVNRevisionRange> revisions = new ArrayList<SVNRevisionRange>();
        List<SVNLogEntry> selected = Arrays.asList(this.selectedLogMessages);
        long startRev = -1L;
        long lastRev = -1L;
        SVNLogEntry[] sVNLogEntryArray = this.logMessages;
        int n = this.logMessages.length;
        int n2 = 0;
        while (n2 < n) {
            SVNLogEntry entry = sVNLogEntryArray[n2];
            if (selected.indexOf(entry) != -1) {
                lastRev = entry.revision;
                if (startRev == -1L) {
                    startRev = entry.revision;
                }
            } else if (startRev != -1L) {
                revisions.add(new SVNRevisionRange(startRev, lastRev));
                startRev = -1L;
            }
            ++n2;
        }
        return revisions.toArray(new SVNRevisionRange[revisions.size()]);
    }

    public String getImagePath() {
        return "icons/dialogs/select_revision.gif";
    }

    public void postInit() {
        this.manager.setButtonEnabled(0, false);
    }

    public Point getPrefferedSizeImpl() {
        return new Point(700, -1);
    }

    public boolean isGrouped() {
        return this.groupByDateItem.getSelection();
    }

    public long getCurrentRevision() {
        return this.currentRevision;
    }

    public IRepositoryResource getRepositoryResource() {
        return this.resource;
    }

    public SVNLogEntry[] getRemoteHistory() {
        return SVNHistoryPage.filterMessages(this.logMessages, this.logEntriesFilter);
    }

    public SVNLocalFileRevision[] getLocalHistory() {
        return null;
    }

    public IResource getResource() {
        return null;
    }

    public int getMode() {
        return 128;
    }

    public boolean isRelatedPathsOnly() {
        return this.hideUnrelatedItem.getSelection();
    }

    public boolean isPending() {
        return this.pending;
    }

    public void addFilter(ILogEntryFilter filter) {
        this.logEntriesFilter.addFilter(filter);
    }

    public void removeFilter(ILogEntryFilter filter) {
        this.logEntriesFilter.removeFilter(filter);
    }

    public void createControlsImpl(Composite parent) {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Composite labelAndToolbar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        labelAndToolbar.setLayout((Layout)layout);
        GridData data = new GridData(768);
        labelAndToolbar.setLayoutData((Object)data);
        Composite resourceLabelComposite = new Composite(labelAndToolbar, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        resourceLabelComposite.setLayout((Layout)layout);
        resourceLabelComposite.setLayoutData((Object)data);
        this.resourceLabel = new Text(resourceLabelComposite, 16384);
        this.resourceLabel.setEditable(false);
        data = new GridData(770);
        this.resourceLabel.setLayoutData((Object)data);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarMgr.createControl(labelAndToolbar);
        data = new GridData();
        data.horizontalAlignment = 3;
        toolBar.setLayoutData((Object)data);
        this.refreshItem = new ToolItem(toolBar, 0x800000);
        new ToolItem(toolBar, 2);
        this.groupByDateItem = new ToolItem(toolBar, 0x800020);
        new ToolItem(toolBar, 2);
        this.hideUnrelatedItem = new ToolItem(toolBar, 0x800020);
        this.stopOnCopyItem = new ToolItem(toolBar, 0x800020);
        new ToolItem(toolBar, 2);
        this.filterItem = new ToolItem(toolBar, 0x800000);
        this.clearFilterItem = new ToolItem(toolBar, 0x800000);
        new ToolItem(toolBar, 2);
        this.pagingItem = new ToolItem(toolBar, 0x800000);
        this.pagingAllItem = new ToolItem(toolBar, 0x800000);
        this.groupByDateItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/group_by_date.gif").createImage());
        this.hideUnrelatedItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/hide_unrelated.gif").createImage());
        this.stopOnCopyItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/stop_on_copy.gif").createImage());
        this.stopOnCopyItem.setSelection(this.initialStopOnCopy);
        this.filterItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/filter.gif").createImage());
        this.clearFilterItem.setDisabledImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear.gif").createImage());
        this.clearFilterItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/clear_filter.gif").createImage());
        this.pagingItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging.gif").createImage());
        this.pagingAllItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/views/history/paging_all.gif").createImage());
        this.refreshItem.setImage(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif").createImage());
        this.hideUnrelatedItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Unrelated"));
        this.stopOnCopyItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.StopOnCopy"));
        this.filterItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.QuickFilter"));
        this.clearFilterItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ClearFilter"));
        this.pagingAllItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowAll"));
        this.refreshItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.Refresh"));
        Composite group = new Composite(parent, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.history = new LogMessagesComposite(group, this.multiSelect, this.useCheckboxes, this);
        data = new GridData(1808);
        data.heightHint = 350;
        this.history.setLayoutData(data);
        this.history.setFocus();
        this.tableViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectRevisionPanel.this.manager != null) {
                    SVNLogEntry[] messages = SelectRevisionPanel.this.history.getSelectedLogMessages();
                    SelectRevisionPanel.this.manager.setButtonEnabled(0, messages != null && messages.length > 0);
                }
            }
        };
        this.history.getTreeViewer().addSelectionChangedListener(this.tableViewerListener);
        int type = SVNTeamPreferences.getHistoryInt(store, "groupingType");
        if (SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
            this.limit = SVNTeamPreferences.getHistoryInt(store, "pageSize");
            String msg = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowNextX", new String[]{String.valueOf(this.limit)});
            this.pagingItem.setToolTipText(msg);
            this.pagingEnabled = true;
        } else {
            this.limit = 0L;
            this.pagingItem.setToolTipText(SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.ShowNextPage"));
            this.pagingEnabled = false;
        }
        this.pagingEnabled = this.limit > 0L && (long)this.logMessages.length == this.limit;
        this.setPagingEnabled();
        this.clearFilterItem.setEnabled(false);
        this.groupByDateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.history.refresh(2);
            }
        });
        this.groupByDateItem.setSelection(type == 1);
        this.hideUnrelatedItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.history.refresh(1);
            }
        });
        this.stopOnCopyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.refresh();
            }
        });
        this.filterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.setFilter();
            }
        });
        this.clearFilterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.clearFilter();
            }
        });
        this.pagingItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.showNextPage(false);
            }
        });
        this.pagingAllItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.showNextPage(true);
            }
        });
        this.refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRevisionPanel.this.refresh();
            }
        });
        this.pending = false;
        this.history.refresh(3);
        CheckboxTreeViewer treeTable = this.history.getTreeViewer();
        TreeItem firstItem = treeTable.getTree().getItem(0);
        if (((ILogNode)firstItem.getData()).getType() == 1) {
            firstItem = firstItem.getItem(0);
        }
        treeTable.getTree().setSelection(firstItem);
        this.history.refresh(1);
        this.showResourceLabel();
    }

    protected void showResourceLabel() {
        String resourceName = SVNTeamUIPlugin.instance().getResource("SelectRevisionPanel.NotSelected");
        if (this.resource != null) {
            resourceName = this.resource.getUrl();
        }
        this.resourceLabel.setText(resourceName);
    }

    protected void saveChangesImpl() {
        this.selectedLogMessages = this.history.getSelectedLogMessages();
    }

    protected void cancelChangesImpl() {
    }

    protected void addPage(SVNLogEntry[] newMessages) {
        if (this.logMessages == null) {
            this.pending = false;
            this.logMessages = newMessages.length > 0 ? newMessages : null;
            this.pagingEnabled = this.limit > 0L && (long)newMessages.length == this.limit;
        } else if (newMessages.length > 1) {
            LinkedHashSet entries = new LinkedHashSet(Arrays.asList(this.logMessages));
            int oldSize = entries.size();
            entries.addAll(Arrays.asList(newMessages));
            this.logMessages = entries.toArray(new SVNLogEntry[entries.size()]);
            this.pagingEnabled = this.limit > 0L && ((long)newMessages.length == this.limit + 1L || entries.size() - oldSize < newMessages.length - 1);
        }
    }

    protected void setPagingEnabled() {
        this.pagingEnabled &= this.resource != null && this.limit > 0L;
        this.pagingItem.setEnabled(this.pagingEnabled);
        this.pagingAllItem.setEnabled(this.pagingEnabled);
        this.filterItem.setEnabled(this.resource != null && this.logMessages != null);
        this.clearFilterItem.setEnabled(this.isFilterEnabled() && this.logMessages != null);
    }

    protected void fetchHistory(final GetLogMessagesOperation msgsOp) {
        msgsOp.setIncludeMerged(SVNTeamPreferences.getMergeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "includeMerged"));
        final IStructuredSelection selected = (IStructuredSelection)this.history.getTreeViewer().getSelection();
        AbstractActionOperation showOp = new AbstractActionOperation("Operation.ShowMessages"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                SVNTeamUIPlugin.instance().getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (msgsOp.getExecutionState() != 0) {
                            (this).SelectRevisionPanel.this.pending = false;
                            (this).SelectRevisionPanel.this.history.refresh(3);
                            return;
                        }
                        SelectRevisionPanel.this.addPage(msgsOp.getMessages());
                        (this).SelectRevisionPanel.this.history.refresh(3);
                        SelectRevisionPanel.this.setPagingEnabled();
                        CheckboxTreeViewer treeTable = (this).SelectRevisionPanel.this.history.getTreeViewer();
                        if (!treeTable.getTree().isDisposed() && treeTable.getTree().getItems().length > 0) {
                            if (selected.size() != 0) {
                                treeTable.setSelection((ISelection)selected);
                            } else {
                                TreeItem firstItem = treeTable.getTree().getItem(0);
                                if (((ILogNode)firstItem.getData()).getType() == 1) {
                                    firstItem = firstItem.getItem(0);
                                }
                                treeTable.getTree().setSelection(firstItem);
                            }
                            (this).SelectRevisionPanel.this.history.refresh(1);
                            ISelectionChangedListener listener = (this).SelectRevisionPanel.this.tableViewerListener;
                            if (listener != null) {
                                (this).SelectRevisionPanel.this.tableViewerListener.selectionChanged(null);
                            }
                        }
                    }
                });
            }
        };
        CompositeOperation op = new CompositeOperation(showOp.getId());
        op.add((IActionOperation)msgsOp);
        op.add((IActionOperation)showOp);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
    }

    protected void showNextPage(boolean showAll) {
        if (this.resource != null) {
            GetLogMessagesOperation msgsOp = new GetLogMessagesOperation(this.resource, this.stopOnCopyItem.getSelection());
            msgsOp.setLimit(showAll ? 0L : (this.logMessages == null ? this.limit : this.limit + 1L));
            SVNRevision revision = this.resource.getSelectedRevision();
            if (this.logMessages != null && this.logMessages.length > 1) {
                SVNLogEntry lm = this.logMessages[this.logMessages.length - 1];
                revision = SVNRevision.fromNumber((long)lm.revision);
            }
            msgsOp.setStartRevision(revision);
            this.fetchHistory(msgsOp);
        }
    }

    protected void setFilter() {
        HistoryFilterPanel panel = new HistoryFilterPanel(this.authorFilter.getAuthorNameToAccept(), this.commentFilter.getCommentToAccept(), this.changeFilter.getGangedPathToAccept(), SVNHistoryPage.getSelectedAuthors(this.logMessages));
        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getDisplay().getActiveShell(), panel);
        if (dialog.open() == 0) {
            this.authorFilter.setAuthorNameToAccept(panel.getAuthor());
            this.commentFilter.setCommentToAccept(panel.getComment());
            this.clearFilterItem.setEnabled(this.isFilterEnabled());
            this.history.refresh(3);
        }
    }

    protected void clearFilter() {
        this.authorFilter.setAuthorNameToAccept(null);
        this.commentFilter.setCommentToAccept(null);
        this.changeFilter.setGangedPathToAccept(null);
        this.clearFilterItem.setEnabled(false);
        this.history.refresh(3);
    }

    protected boolean isFilterEnabled() {
        return this.authorFilter.getAuthorNameToAccept() != null || this.commentFilter.getCommentToAccept() != null || this.changeFilter.getGangedPathToAccept() != null;
    }

    protected void refresh() {
        long revision = this.history.getSelectedRevision();
        this.pagingEnabled = true;
        this.logMessages = null;
        this.pending = true;
        this.history.refresh(3);
        this.showNextPage(false);
        this.history.setSelectedRevision(revision);
    }
}

