/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.events.IRevisionPropertyChangeListener;
import org.eclipse.team.svn.core.svnstorage.events.RevisonPropertyChangeEvent;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.history.HistoryActionManager;
import org.eclipse.team.svn.ui.history.ISVNHistoryView;
import org.eclipse.team.svn.ui.history.LogMessagesComposite;
import org.eclipse.team.svn.ui.history.data.SVNLocalFileRevision;
import org.eclipse.team.svn.ui.history.filter.AuthorNameLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.ChangeNameLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.CommentLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.CompositeLogEntryFilter;
import org.eclipse.team.svn.ui.history.filter.ILogEntryFilter;
import org.eclipse.team.svn.ui.history.model.ILogNode;
import org.eclipse.team.svn.ui.operation.CorrectRevisionOperation;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.panel.view.HistoryFilterPanel;
import org.eclipse.team.svn.ui.panel.view.HistoryRangePanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocation;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class SVNHistoryPage
extends HistoryPage
implements ISVNHistoryView,
IResourceStatesListener,
IPropertyChangeListener,
IRevisionPropertyChangeListener {
    protected IResource wcResource;
    protected IRepositoryResource repositoryResource;
    protected SVNRevision endRevision;
    protected SVNRevision startRevision;
    protected LogMessagesComposite history;
    protected CommentLogEntryFilter commentFilter;
    protected AuthorNameLogEntryFilter authorFilter;
    protected ChangeNameLogEntryFilter changeFilter;
    protected CompositeLogEntryFilter logEntriesFilter;
    protected Action showCommentViewerAction;
    protected Action showAffectedPathsViewerAction;
    protected Action hideUnrelatedAction;
    protected Action hideUnrelatedDropDownAction;
    protected Action stopOnCopyAction;
    protected Action stopOnCopyDropDownAction;
    protected Action groupByDateDropDownAction;
    protected Action getNextPageAction;
    protected Action getAllPagesAction;
    protected Action clearFilterDropDownAction;
    protected Action filterDropDownAction;
    protected Action revisionsRangeDropDownAction;
    protected Action hierarchicalAction;
    protected Action flatAction;
    protected Action compareModeAction;
    protected Action compareModeDropDownAction;
    protected Action groupByDateAction;
    protected Action showLocalAction;
    protected Action showRemoteAction;
    protected Action showBothAction;
    protected Action collapseAllAction;
    protected Action showLocalActionDropDown;
    protected Action showRemoteActionDropDown;
    protected Action showBothActionDropDown;
    protected long limit = 25L;
    protected boolean pagingEnabled = false;
    protected boolean pending;
    protected int options = 0;
    protected IResource compareWith;
    protected IRepositoryLocation currentlyInvolvedLocation;
    protected long currentRevision = 0L;
    protected SVNLogEntry[] logMessages;
    protected SVNLocalFileRevision[] localHistory;
    protected HistoryActionManager actionManager;

    public SVNHistoryPage(Object input) {
        SVNRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
        SVNRemoteStorage.instance().addRevisionPropertyChangeListener((IRevisionPropertyChangeListener)this);
        this.actionManager = new HistoryActionManager(this);
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.authorFilter = new AuthorNameLogEntryFilter();
        this.commentFilter = new CommentLogEntryFilter();
        this.changeFilter = new ChangeNameLogEntryFilter();
        this.logEntriesFilter = new CompositeLogEntryFilter(new ILogEntryFilter[]{this.authorFilter, this.commentFilter, this.changeFilter});
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SVNTeamPreferences.fullHistoryName("pageSize")) || event.getProperty().equals(SVNTeamPreferences.fullHistoryName("pagingEnable"))) {
            this.refreshLimitOption();
        }
        if (event.getProperty().startsWith("preference.dateFormat.")) {
            this.refresh(0);
        }
        if (event.getProperty().equals(SVNTeamPreferences.fullMergeName("includeMerged"))) {
            this.refresh(2);
        }
    }

    public void revisionPropertyChanged(RevisonPropertyChangeEvent event) {
        if (this.currentlyInvolvedLocation == null || !this.currentlyInvolvedLocation.equals(event.getLocation())) {
            return;
        }
        if (event.getProperty().name.equals("svn:author") || event.getProperty().name.equals("svn:log") || event.getProperty().name.equals("svn:date")) {
            int i = 0;
            while (i < this.logMessages.length) {
                SVNLogEntry current = this.logMessages[i];
                if (SVNRevision.fromNumber((long)current.revision).equals((Object)event.getRevision())) {
                    if (event.getProperty().name.equals("svn:author")) {
                        this.logMessages[i] = new SVNLogEntry(current.revision, current.date, event.getProperty().value, current.message, current.changedPaths, current.hasChildren());
                        if (current.hasChildren()) {
                            this.logMessages[i].addAll(current.getChildren());
                        }
                    }
                    if (event.getProperty().name.equals("svn:log")) {
                        this.logMessages[i] = new SVNLogEntry(current.revision, current.date, current.author, event.getProperty().value, current.changedPaths, current.hasChildren());
                        if (current.hasChildren()) {
                            this.logMessages[i].addAll(current.getChildren());
                        }
                    }
                    if (event.getProperty().name.equals("svn:date")) {
                        try {
                            this.logMessages[i] = new SVNLogEntry(current.revision, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(event.getProperty().value).getTime(), current.author, current.message, current.changedPaths, current.hasChildren());
                        }
                        catch (ParseException parseException) {}
                        if (current.hasChildren()) {
                            this.logMessages[i].addAll(current.getChildren());
                        }
                    }
                }
                ++i;
            }
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    SVNHistoryPage.this.refresh(0);
                }
            });
        }
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        if (this.wcResource == null) {
            return;
        }
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.wcResource);
        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
            if (IStateFilter.SF_ONREPOSITORY.accept(local) && this.logMessages == null) {
                this.refreshChanges(3);
            } else if (this.wcResource instanceof IFile) {
                this.refreshChanges(1);
            }
            if (!(!event.contains(this.wcResource) && !event.contains((IResource)this.wcResource.getProject()) || this.wcResource.exists() && FileUtility.isConnected((IResource)this.wcResource))) {
                this.disconnectView();
            }
        } else {
            this.disconnectView();
        }
    }

    public void addFilter(ILogEntryFilter filter) {
        this.logEntriesFilter.addFilter(filter);
    }

    public void removeFilter(ILogEntryFilter filter) {
        this.logEntriesFilter.removeFilter(filter);
    }

    public void showHistory(IResource resource) {
        if (!resource.equals((Object)this.wcResource)) {
            this.clear();
            this.wcResource = resource;
            this.currentlyInvolvedLocation = SVNRemoteStorage.instance().asRepositoryResource(this.wcResource).getRepositoryLocation();
            this.refresh(3);
        }
    }

    public void showHistory(IRepositoryResource remoteResource) {
        if (!remoteResource.equals(this.repositoryResource)) {
            this.clear();
            this.repositoryResource = remoteResource;
            this.currentlyInvolvedLocation = this.repositoryResource.getRepositoryLocation();
            this.refresh(3);
        }
    }

    public synchronized void clear() {
        this.currentRevision = -1L;
        this.repositoryResource = null;
        this.wcResource = null;
        this.logMessages = null;
        this.localHistory = null;
        this.authorFilter.setAuthorNameToAccept(null);
        this.commentFilter.setCommentToAccept(null);
        this.pending = false;
        this.setButtonsEnablement();
        this.history.refresh(3);
    }

    public void selectRevision(long revision) {
        this.history.setSelectedRevision(revision);
    }

    public void setCompareWith(IResource compareWith) {
        this.compareWith = compareWith;
    }

    public void setOptions(int mask, int values) {
        this.options = this.options & ~mask | mask & values;
        this.refreshOptionButtons();
    }

    public IResource getResource() {
        return this.wcResource;
    }

    public IRepositoryResource getRepositoryResource() {
        return this.repositoryResource;
    }

    public IResource getCompareWith() {
        return this.compareWith == null ? this.wcResource : this.compareWith;
    }

    public HistoryPage getHistoryPage() {
        return this;
    }

    public SVNLogEntry[] getRemoteHistory() {
        return SVNHistoryPage.filterMessages(this.logMessages, this.logEntriesFilter);
    }

    public SVNLogEntry[] getFullRemoteHistory() {
        return this.logMessages;
    }

    public SVNLocalFileRevision[] getLocalHistory() {
        return this.localHistory;
    }

    public boolean isAllRemoteHistoryFetched() {
        return !this.getNextPageAction.isEnabled();
    }

    public boolean isFilterEnabled() {
        return this.authorFilter.getAuthorNameToAccept() != null || this.commentFilter.getCommentToAccept() != null || this.changeFilter.getGangedPathToAccept() != null;
    }

    public int getOptions() {
        return this.options;
    }

    public void clearFilter() {
        this.authorFilter.setAuthorNameToAccept(null);
        this.commentFilter.setCommentToAccept(null);
        this.changeFilter.setGangedPathToAccept(null);
        this.clearFilterDropDownAction.setEnabled(false);
        this.history.refresh(3);
    }

    public void setFilter() {
        HistoryFilterPanel panel = new HistoryFilterPanel(this.authorFilter.getAuthorNameToAccept(), this.commentFilter.getCommentToAccept(), this.changeFilter.getGangedPathToAccept(), SVNHistoryPage.getSelectedAuthors(this.logMessages));
        DefaultDialog dialog = new DefaultDialog(this.getPartSite().getShell(), panel);
        if (dialog.open() == 0) {
            this.authorFilter.setAuthorNameToAccept(panel.getAuthor());
            this.commentFilter.setCommentToAccept(panel.getComment());
            this.changeFilter.setGangedPathToAccept(panel.getChangedPath());
            this.clearFilterDropDownAction.setEnabled(this.isFilterEnabled());
            this.history.refresh(3);
        }
    }

    public void refresh(int refreshType) {
        if (this.wcResource != null) {
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.wcResource);
            if (IStateFilter.SF_ONREPOSITORY.accept(local)) {
                this.currentRevision = local.getRevision();
                this.repositoryResource = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)this.wcResource) : SVNRemoteStorage.instance().asRepositoryResource(this.wcResource);
            } else {
                this.repositoryResource = null;
            }
            if (this.wcResource instanceof IFile && refreshType != 2 && refreshType != 0) {
                try {
                    this.fetchLocalHistory(local, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ex) {
                    UILoggedOperation.reportError(SVNTeamUIPlugin.instance().getResource("HistoryView.Name"), ex);
                }
            }
        }
        if (this.repositoryResource != null && (refreshType == 3 || refreshType == 2)) {
            this.logMessages = null;
            this.pending = true;
            this.setButtonsEnablement();
            this.history.refresh(3);
            GetLogMessagesOperation msgOp = this.createRemoteHistoryFetcher();
            if (this.startRevision != null) {
                msgOp.setStartRevision(this.startRevision);
            }
            msgOp.setLimit(this.limit);
            this.fetchRemoteHistory(msgOp);
        } else {
            this.setButtonsEnablement();
            this.history.refresh(3);
        }
    }

    public long getCurrentRevision() {
        return this.currentRevision;
    }

    public boolean isGrouped() {
        return this.groupByDateAction.isChecked();
    }

    public boolean isPending() {
        return this.pending;
    }

    public int getMode() {
        return this.options & 0xE0;
    }

    public boolean isRelatedPathsOnly() {
        return this.hideUnrelatedAction.isChecked();
    }

    public void dispose() {
        SVNRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, (IResourceStatesListener)this);
        SVNRemoteStorage.instance().removeRevisionPropertyChangeListener((IRevisionPropertyChangeListener)this);
        SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public boolean inputSet() {
        if (this.getInput() instanceof IResource) {
            this.showHistory((IResource)this.getInput());
            return true;
        }
        if (this.getInput() instanceof IRepositoryResource) {
            this.showHistory((IRepositoryResource)this.getInput());
            return true;
        }
        if (this.getInput() instanceof RepositoryResource) {
            this.showHistory(((RepositoryResource)this.getInput()).getRepositoryResource());
            return true;
        }
        if (this.getInput() instanceof RepositoryLocation) {
            this.showHistory(((RepositoryLocation)this.getInput()).getRepositoryResource());
            return true;
        }
        return false;
    }

    public Control getControl() {
        return this.history;
    }

    public void setFocus() {
    }

    public String getDescription() {
        return this.getName();
    }

    public String getName() {
        if (this.getResource() != null) {
            return this.getResource().getFullPath().toString().substring(1);
        }
        if (this.getRepositoryResource() != null) {
            return this.getRepositoryResource().getUrl();
        }
        return SVNTeamUIPlugin.instance().getResource("SVNView.ResourceNotSelected");
    }

    public boolean isValidInput(Object object) {
        return SVNHistoryPage.isValidData(object);
    }

    public void refresh() {
        this.refresh(3);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void createControl(Composite parent) {
        IActionBars actionBars = this.getHistoryPageSite().getWorkbenchPageSite().getActionBars();
        this.groupByDateAction = new HistoryActionManager.HistoryAction("HistoryView.GroupByDate", "icons/views/history/group_by_date.gif", 2){

            public void run() {
                SVNHistoryPage.this.options ^= 0x10;
                SVNHistoryPage.this.groupByDateDropDownAction.setChecked((SVNHistoryPage.this.options & 0x10) != 0);
                SVNHistoryPage.saveInt("groupingType", (SVNHistoryPage.this.options & 0x10) == 0 ? 0 : 1);
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.showBothAction = new HistoryActionManager.HistoryAction("HistoryView.ShowBoth", "icons/views/history/both_history_mode.gif", 8){

            public void run() {
                SVNHistoryPage.this.options = SVNHistoryPage.this.options & 0xFFFFFF3F | 0x20;
                SVNHistoryPage.this.showBothActionDropDown.setChecked(true);
                SVNHistoryPage.this.showLocalActionDropDown.setChecked(false);
                SVNHistoryPage.this.showRemoteActionDropDown.setChecked(false);
                SVNHistoryPage.this.saveShowMode();
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.showLocalAction = new HistoryActionManager.HistoryAction("HistoryView.ShowLocal", "icons/views/history/local_history_mode.gif", 8){

            public void run() {
                SVNHistoryPage.this.options = SVNHistoryPage.this.options & 0xFFFFFF5F | 0x40;
                SVNHistoryPage.this.showLocalActionDropDown.setChecked(true);
                SVNHistoryPage.this.showRemoteActionDropDown.setChecked(false);
                SVNHistoryPage.this.showBothActionDropDown.setChecked(false);
                SVNHistoryPage.this.saveShowMode();
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.showRemoteAction = new HistoryActionManager.HistoryAction("HistoryView.ShowRemote", "icons/views/history/remote_history_mode.gif", 8){

            public void run() {
                SVNHistoryPage.this.options = SVNHistoryPage.this.options & 0xFFFFFF9F | 0x80;
                SVNHistoryPage.this.showRemoteActionDropDown.setChecked(true);
                SVNHistoryPage.this.showLocalActionDropDown.setChecked(false);
                SVNHistoryPage.this.showBothActionDropDown.setChecked(false);
                SVNHistoryPage.this.saveShowMode();
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.hideUnrelatedAction = new HistoryActionManager.HistoryAction("HistoryView.HideUnrelatedPaths", "icons/views/history/hide_unrelated.gif", 2){

            public void run() {
                SVNHistoryPage.this.options ^= 4;
                SVNHistoryPage.this.hideUnrelatedDropDownAction.setChecked((SVNHistoryPage.this.options & 4) != 0);
                SVNHistoryPage.this.history.refresh(1);
            }
        };
        this.stopOnCopyAction = new HistoryActionManager.HistoryAction("HistoryView.StopOnCopy", "icons/views/history/stop_on_copy.gif", 2){

            public void run() {
                SVNHistoryPage.this.options ^= 8;
                SVNHistoryPage.this.stopOnCopyDropDownAction.setChecked((SVNHistoryPage.this.options & 8) != 0);
                SVNHistoryPage.this.refresh(2);
            }
        };
        this.getNextPageAction = new HistoryActionManager.HistoryAction("HistoryView.GetNextPage", "icons/views/history/paging.gif"){

            public void run() {
                GetLogMessagesOperation msgOp = SVNHistoryPage.this.createRemoteHistoryFetcher();
                msgOp.setLimit(SVNHistoryPage.this.limit + 1L);
                if (SVNHistoryPage.this.logMessages != null) {
                    SVNLogEntry lm = SVNHistoryPage.this.logMessages[SVNHistoryPage.this.logMessages.length - 1];
                    msgOp.setStartRevision((SVNRevision)SVNRevision.fromNumber((long)lm.revision));
                }
                SVNHistoryPage.this.fetchRemoteHistory(msgOp);
            }
        };
        String msg = this.limit > 0L ? SVNTeamUIPlugin.instance().getResource("HistoryView.ShowNextX", new String[]{String.valueOf(this.limit)}) : SVNTeamUIPlugin.instance().getResource("HistoryView.ShowNextPage");
        this.getNextPageAction.setToolTipText(msg);
        this.getAllPagesAction = new HistoryActionManager.HistoryAction("HistoryView.ShowAll", "icons/views/history/paging_all.gif"){

            public void run() {
                GetLogMessagesOperation msgOp = SVNHistoryPage.this.createRemoteHistoryFetcher();
                msgOp.setLimit(0L);
                if (SVNHistoryPage.this.logMessages != null) {
                    SVNLogEntry lm = SVNHistoryPage.this.logMessages[SVNHistoryPage.this.logMessages.length - 1];
                    msgOp.setStartRevision((SVNRevision)SVNRevision.fromNumber((long)lm.revision));
                }
                SVNHistoryPage.this.fetchRemoteHistory(msgOp);
            }
        };
        this.collapseAllAction = new HistoryActionManager.HistoryAction("RepositoriesView.CollapseAll.Label", "icons/common/collapseall.gif"){

            public void run() {
                SVNHistoryPage.this.history.collapseAll();
            }
        };
        this.compareModeAction = new HistoryActionManager.HistoryAction("HistoryView.CompareMode", "icons/views/history/compare_mode.gif", 2){

            public void run() {
                SVNHistoryPage.this.options ^= 2;
                SVNHistoryPage.this.compareModeDropDownAction.setChecked((SVNHistoryPage.this.options & 2) != 0);
                SVNHistoryPage.saveBoolean("compareMode", (SVNHistoryPage.this.options & 2) != 0);
            }
        };
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.groupByDateAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.showBothAction);
        tbm.add((IAction)this.showLocalAction);
        tbm.add((IAction)this.showRemoteAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.hideUnrelatedAction);
        tbm.add((IAction)this.stopOnCopyAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.getNextPageAction);
        tbm.add((IAction)this.getAllPagesAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.collapseAllAction);
        tbm.add((IAction)this.compareModeAction);
        this.showCommentViewerAction = new HistoryActionManager.HistoryAction("HistoryView.ShowCommentViewer"){

            public void run() {
                SVNHistoryPage.this.history.setCommentViewerVisible(SVNHistoryPage.this.showCommentViewerAction.isChecked());
                SVNHistoryPage.saveBoolean("multilineComment", this.isChecked());
            }
        };
        this.showAffectedPathsViewerAction = new HistoryActionManager.HistoryAction("HistoryView.ShowAffectedPathsViewer"){

            public void run() {
                boolean showAffected = this.isChecked();
                SVNHistoryPage.this.history.setAffectedPathsViewerVisible(showAffected);
                SVNHistoryPage.this.flatAction.setEnabled(showAffected);
                SVNHistoryPage.this.hierarchicalAction.setEnabled(showAffected);
                SVNHistoryPage.saveBoolean("affectedPaths", showAffected);
            }
        };
        this.hideUnrelatedDropDownAction = new HistoryActionManager.HistoryAction("HistoryView.HideUnrelatedPaths", "icons/views/history/hide_unrelated.gif"){

            public void run() {
                SVNHistoryPage.this.options ^= 4;
                SVNHistoryPage.this.hideUnrelatedAction.setChecked((SVNHistoryPage.this.options & 4) != 0);
                SVNHistoryPage.this.history.refresh(1);
            }
        };
        this.stopOnCopyDropDownAction = new HistoryActionManager.HistoryAction("HistoryView.StopOnCopy", "icons/views/history/stop_on_copy.gif"){

            public void run() {
                SVNHistoryPage.this.options ^= 8;
                SVNHistoryPage.this.stopOnCopyAction.setChecked((SVNHistoryPage.this.options & 8) != 0);
                SVNHistoryPage.this.refresh(2);
            }
        };
        this.groupByDateDropDownAction = new HistoryActionManager.HistoryAction("HistoryView.GroupByDate", "icons/views/history/group_by_date.gif"){

            public void run() {
                SVNHistoryPage.this.options ^= 0x10;
                SVNHistoryPage.this.groupByDateAction.setChecked((SVNHistoryPage.this.options & 0x10) != 0);
                SVNHistoryPage.saveInt("groupingType", (SVNHistoryPage.this.options & 0x10) == 0 ? 0 : 1);
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.showBothActionDropDown = new HistoryActionManager.HistoryAction("HistoryView.ShowBoth", "icons/views/history/both_history_mode.gif", 8){

            public void run() {
                SVNHistoryPage.this.options = SVNHistoryPage.this.options & 0xFFFFFF3F | 0x20;
                SVNHistoryPage.this.showBothAction.setChecked(true);
                SVNHistoryPage.this.showLocalAction.setChecked(false);
                SVNHistoryPage.this.showRemoteAction.setChecked(false);
                SVNHistoryPage.this.saveShowMode();
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.showLocalActionDropDown = new HistoryActionManager.HistoryAction("HistoryView.ShowLocal", "icons/views/history/local_history_mode.gif", 8){

            public void run() {
                SVNHistoryPage.this.options = SVNHistoryPage.this.options & 0xFFFFFF5F | 0x40;
                SVNHistoryPage.this.showBothAction.setChecked(false);
                SVNHistoryPage.this.showLocalAction.setChecked(true);
                SVNHistoryPage.this.showRemoteAction.setChecked(false);
                SVNHistoryPage.this.saveShowMode();
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.showRemoteActionDropDown = new HistoryActionManager.HistoryAction("HistoryView.ShowRemote", "icons/views/history/remote_history_mode.gif", 8){

            public void run() {
                SVNHistoryPage.this.options = SVNHistoryPage.this.options & 0xFFFFFF9F | 0x80;
                SVNHistoryPage.this.showBothAction.setChecked(false);
                SVNHistoryPage.this.showLocalAction.setChecked(false);
                SVNHistoryPage.this.showRemoteAction.setChecked(true);
                SVNHistoryPage.this.saveShowMode();
                SVNHistoryPage.this.history.refresh(2);
            }
        };
        this.revisionsRangeDropDownAction = new HistoryActionManager.HistoryAction("HistoryView.RevisionsRange"){

            public void run() {
                SVNHistoryPage.this.defineRevisionsRange();
            }
        };
        this.filterDropDownAction = new HistoryActionManager.HistoryAction("HistoryView.QuickFilter", "icons/views/history/filter.gif"){

            public void run() {
                SVNHistoryPage.this.setFilter();
            }
        };
        this.clearFilterDropDownAction = new HistoryActionManager.HistoryAction("HistoryView.ClearFilter", "icons/views/history/clear_filter.gif"){

            public void run() {
                SVNHistoryPage.this.clearFilter();
            }
        };
        this.compareModeDropDownAction = new HistoryActionManager.HistoryAction("HistoryView.CompareMode", "icons/views/history/compare_mode.gif"){

            public void run() {
                SVNHistoryPage.this.options ^= 2;
                SVNHistoryPage.this.compareModeAction.setChecked((SVNHistoryPage.this.options & 2) != 0);
                SVNHistoryPage.saveBoolean("compareMode", (SVNHistoryPage.this.options & 2) != 0);
            }
        };
        this.flatAction = new HistoryActionManager.HistoryAction("HistoryView.Flat", "icons/views/history/flat_layout.gif", 8){

            public void run() {
                SVNHistoryPage.this.history.setResourceTreeVisible(false);
                SVNHistoryPage.saveBoolean("hierarchicalLayout", false);
            }
        };
        this.hierarchicalAction = new HistoryActionManager.HistoryAction("HistoryView.Hierarchical", "icons/views/history/tree_layout.gif", 8){

            public void run() {
                SVNHistoryPage.this.history.setResourceTreeVisible(true);
                SVNHistoryPage.saveBoolean("hierarchicalLayout", true);
            }
        };
        IMenuManager actionBarsMenu = actionBars.getMenuManager();
        actionBarsMenu.add((IAction)this.showCommentViewerAction);
        actionBarsMenu.add((IAction)this.showAffectedPathsViewerAction);
        MenuManager sub = new MenuManager(SVNTeamUIPlugin.instance().getResource("HistoryView.AffectedPathLayout"), "group.managing");
        sub.add((IAction)this.flatAction);
        sub.add((IAction)this.hierarchicalAction);
        actionBarsMenu.add((IContributionItem)sub);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.groupByDateDropDownAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.showBothActionDropDown);
        actionBarsMenu.add((IAction)this.showLocalActionDropDown);
        actionBarsMenu.add((IAction)this.showRemoteActionDropDown);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.hideUnrelatedDropDownAction);
        actionBarsMenu.add((IAction)this.stopOnCopyDropDownAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.revisionsRangeDropDownAction);
        actionBarsMenu.add((IAction)this.filterDropDownAction);
        actionBarsMenu.add((IAction)this.clearFilterDropDownAction);
        actionBarsMenu.add((IContributionItem)new Separator());
        actionBarsMenu.add((IAction)this.compareModeDropDownAction);
        this.history = new LogMessagesComposite(parent, true, false, this);
        GridData data = new GridData(1808);
        this.history.setLayoutData(data);
        this.history.registerActionManager(this.actionManager, this.getPartSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.historyViewContext");
        this.refreshOptionButtons();
    }

    public static String[] getSelectedAuthors(SVNLogEntry[] logMessages) {
        HashSet<String> authors = new HashSet<String>();
        if (logMessages != null) {
            SVNLogEntry[] sVNLogEntryArray = logMessages;
            int n = logMessages.length;
            int n2 = 0;
            while (n2 < n) {
                SVNLogEntry entry = sVNLogEntryArray[n2];
                if (entry.author != null) {
                    authors.add(entry.author);
                }
                ++n2;
            }
        }
        return authors.toArray(new String[authors.size()]);
    }

    public static SVNLogEntry[] filterMessages(SVNLogEntry[] msgs, ILogEntryFilter filter) {
        if (msgs == null) {
            return null;
        }
        ArrayList<SVNLogEntry> filteredMessages = new ArrayList<SVNLogEntry>();
        int i = 0;
        while (i < msgs.length) {
            if (filter.accept(msgs[i])) {
                filteredMessages.add(msgs[i]);
            }
            ++i;
        }
        if (filteredMessages.size() == 0) {
            return null;
        }
        return filteredMessages.toArray(new SVNLogEntry[filteredMessages.size()]);
    }

    public static boolean isValidData(Object object) {
        return object instanceof IRepositoryResource || object instanceof RepositoryResource || object instanceof RepositoryLocation || object instanceof IResource && FileUtility.isConnected((IResource)((IResource)object));
    }

    protected IWorkbenchPartSite getPartSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        if (part == null) {
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        while (site == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            site = part.getSite();
        }
        return site;
    }

    protected GetLogMessagesOperation createRemoteHistoryFetcher() {
        GetLogMessagesOperation msgOp = new GetLogMessagesOperation(this.repositoryResource, this.stopOnCopyAction.isChecked());
        if (this.endRevision != null) {
            msgOp.setEndRevision(this.endRevision);
        }
        return msgOp;
    }

    protected void fetchRemoteHistory(final GetLogMessagesOperation msgsOp) {
        msgsOp.setIncludeMerged(SVNTeamPreferences.getMergeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "includeMerged"));
        final IStructuredSelection selected = (IStructuredSelection)this.history.getTreeViewer().getSelection();
        AbstractActionOperation showOp = new AbstractActionOperation("Operation.HShowHistory"){
            private long revision;
            {
                super($anonymous0);
                this.revision = SVNHistoryPage.this.currentRevision;
            }

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                IRepositoryResource resource = SVNHistoryPage.this.repositoryResource;
                if (msgsOp.getExecutionState() != 0 || resource == null) {
                    SVNHistoryPage.this.pending = false;
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            (this).SVNHistoryPage.this.history.refresh(3);
                        }
                    });
                    return;
                }
                if (SVNHistoryPage.this.wcResource == null) {
                    this.revision = resource.getRevision();
                }
                if (!resource.equals(msgsOp.getResource())) {
                    return;
                }
                SVNHistoryPage.this.currentRevision = this.revision;
                SVNHistoryPage.this.addPage(msgsOp.getMessages());
                UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        (this).SVNHistoryPage.this.history.refresh(3);
                        SVNHistoryPage.this.setButtonsEnablement();
                        CheckboxTreeViewer treeTable = (this).SVNHistoryPage.this.history.getTreeViewer();
                        if (!treeTable.getTree().isDisposed() && treeTable.getTree().getItems().length > 0) {
                            if (selected.size() != 0) {
                                treeTable.setSelection((ISelection)selected, true);
                            } else {
                                TreeItem firstItem = treeTable.getTree().getItem(0);
                                if (((ILogNode)firstItem.getData()).getType() == 1) {
                                    firstItem = firstItem.getItem(0);
                                }
                                treeTable.getTree().setSelection(firstItem);
                            }
                            (this).SVNHistoryPage.this.history.refresh(1);
                        }
                    }
                });
            }
        };
        CompositeOperation op = new CompositeOperation(showOp.getId(), true);
        op.add((IActionOperation)new CorrectRevisionOperation(msgsOp, this.repositoryResource, this.currentRevision, this.wcResource));
        op.add((IActionOperation)msgsOp);
        op.add((IActionOperation)showOp);
        ProgressMonitorUtility.doTaskScheduled((IActionOperation)op, (boolean)false);
    }

    protected void fetchLocalHistory(ILocalResource local, IProgressMonitor monitor) throws CoreException {
        IFile file = (IFile)this.wcResource;
        ArrayList<SVNLocalFileRevision> history = new ArrayList<SVNLocalFileRevision>();
        IFileState[] states = file.getHistory(monitor);
        if (states.length > 0 || IStateFilter.SF_NOTONREPOSITORY.accept(local)) {
            history.add(new SVNLocalFileRevision(file));
        }
        IFileState[] iFileStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            IFileState state = iFileStateArray[n2];
            history.add(new SVNLocalFileRevision(state));
            ++n2;
        }
        this.localHistory = history.size() == 0 ? null : history.toArray(new SVNLocalFileRevision[history.size()]);
    }

    protected void addPage(SVNLogEntry[] newMessages) {
        if (this.logMessages == null) {
            if (newMessages.length > 0) {
                this.pending = false;
                this.logMessages = newMessages;
                this.pagingEnabled = this.limit > 0L && (long)newMessages.length == this.limit;
            }
        } else if (newMessages.length > 1) {
            LinkedHashSet entries = new LinkedHashSet(Arrays.asList(this.logMessages));
            int oldSize = entries.size();
            entries.addAll(Arrays.asList(newMessages));
            this.logMessages = entries.toArray(new SVNLogEntry[entries.size()]);
            this.pagingEnabled = this.limit > 0L && ((long)newMessages.length == this.limit + 1L || entries.size() - oldSize < newMessages.length - 1);
        }
    }

    protected void refreshOptionButtons() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean showMultiline = SVNTeamPreferences.getHistoryBoolean(store, "multilineComment");
        this.showCommentViewerAction.setChecked(showMultiline);
        this.showCommentViewerAction.run();
        boolean showAffected = SVNTeamPreferences.getHistoryBoolean(store, "affectedPaths");
        this.showAffectedPathsViewerAction.setChecked(showAffected);
        this.showAffectedPathsViewerAction.run();
        boolean hierarchicalAffectedView = SVNTeamPreferences.getHistoryBoolean(store, "hierarchicalLayout");
        int groupingType = SVNTeamPreferences.getHistoryInt(store, "groupingType");
        int revisionMode = SVNTeamPreferences.getHistoryInt(store, "revisionMode");
        revisionMode = revisionMode == 0 ? 32 : (revisionMode == 1 ? 128 : 64);
        boolean compareMode = SVNTeamPreferences.getHistoryBoolean(store, "compareMode");
        if (compareMode) {
            this.options |= 2;
        }
        this.options |= groupingType == 1 ? 16 : 0;
        this.options = this.options & 0xFFFFFF1F | revisionMode;
        this.hideUnrelatedDropDownAction.setChecked((this.options & 4) != 0);
        this.hideUnrelatedAction.setChecked((this.options & 4) != 0);
        this.stopOnCopyDropDownAction.setChecked((this.options & 8) != 0);
        this.stopOnCopyAction.setChecked((this.options & 8) != 0);
        this.groupByDateAction.setChecked((this.options & 0x10) != 0);
        this.showBothAction.setChecked((this.options & 0x20) != 0);
        this.showBothActionDropDown.setChecked((this.options & 0x20) != 0);
        this.showLocalAction.setChecked((this.options & 0x40) != 0);
        this.showLocalActionDropDown.setChecked((this.options & 0x40) != 0);
        this.showRemoteAction.setChecked((this.options & 0x80) != 0);
        this.showRemoteActionDropDown.setChecked((this.options & 0x80) != 0);
        this.groupByDateDropDownAction.setChecked((this.options & 0x10) != 0);
        this.compareModeDropDownAction.setChecked((this.options & 2) != 0);
        this.compareModeAction.setChecked((this.options & 2) != 0);
        this.flatAction.setChecked(!hierarchicalAffectedView);
        this.hierarchicalAction.setChecked(hierarchicalAffectedView);
        this.history.setResourceTreeVisible(hierarchicalAffectedView);
        this.refreshLimitOption();
        this.setButtonsEnablement();
    }

    protected void defineRevisionsRange() {
        HistoryRangePanel panel = new HistoryRangePanel(this.repositoryResource, this.startRevision, this.endRevision);
        DefaultDialog dialog = new DefaultDialog(this.getPartSite().getShell(), panel);
        if (dialog.open() == 0) {
            this.startRevision = panel.getStartRevision();
            this.endRevision = panel.getStopRevision();
            this.refresh(2);
        }
    }

    protected void refreshLimitOption() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        if (SVNTeamPreferences.getHistoryBoolean(store, "pagingEnable")) {
            this.limit = SVNTeamPreferences.getHistoryInt(store, "pageSize");
            this.getNextPageAction.setToolTipText("Show Next " + this.limit);
            this.options |= 1;
        } else {
            this.limit = 0L;
            this.getNextPageAction.setToolTipText("Show Next Page");
            this.options &= 0xFFFFFFFE;
        }
    }

    protected void setButtonsEnablement() {
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.wcResource);
        boolean enableRepo = (IStateFilter.SF_ONREPOSITORY.accept(local) || this.repositoryResource != null) && !this.pending;
        this.revisionsRangeDropDownAction.setEnabled(enableRepo && this.repositoryResource != null);
        this.filterDropDownAction.setEnabled(enableRepo && this.repositoryResource != null && this.logMessages != null);
        this.clearFilterDropDownAction.setEnabled(this.isFilterEnabled());
        this.getNextPageAction.setEnabled(enableRepo && this.pagingEnabled & (this.options & 1) != 0);
        this.getAllPagesAction.setEnabled(enableRepo && this.pagingEnabled & (this.options & 1) != 0);
        this.stopOnCopyAction.setEnabled(enableRepo);
        this.stopOnCopyDropDownAction.setEnabled(enableRepo);
        this.hideUnrelatedAction.setEnabled(enableRepo);
        this.hideUnrelatedDropDownAction.setEnabled(enableRepo);
    }

    protected void saveShowMode() {
        int prefToSet = 1;
        if ((this.options & 0x20) != 0) {
            prefToSet = 0;
        } else if ((this.options & 0x40) != 0) {
            prefToSet = 2;
        }
        SVNHistoryPage.saveInt("revisionMode", prefToSet);
    }

    protected static void saveBoolean(String name, boolean value) {
        SVNTeamPreferences.setHistoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), name, value);
        SVNTeamUIPlugin.instance().savePluginPreferences();
    }

    protected static void saveInt(String name, int value) {
        SVNTeamPreferences.setHistoryInt(SVNTeamUIPlugin.instance().getPreferenceStore(), name, value);
        SVNTeamUIPlugin.instance().savePluginPreferences();
    }

    protected void disconnectView() {
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                SVNHistoryPage.this.clear();
            }
        });
    }

    protected void refreshChanges(final int refreshType) {
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                SVNHistoryPage.this.refresh(refreshType);
            }
        });
    }
}

