/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.crashrecovery;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class DiscardedLocationHelper
implements IResolutionHelper {
    public boolean acquireResolution(ErrorDescription description) {
        if (description.code == ErrorDescription.REPOSITORY_LOCATION_IS_DISCARDED) {
            Object[] context = (Object[])description.context;
            final IRepositoryLocation location = (IRepositoryLocation)context[1];
            if (location == null) {
                return false;
            }
            if (SVNRemoteStorage.instance().getRepositoryLocation(location.getId()) != null) {
                return true;
            }
            final IProject project = (IProject)context[0];
            final boolean[] solved = new boolean[1];
            UIMonitorUtility.parallelSyncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNTeamUIPlugin.instance().getResource("DiscardedLocationHelper.Dialog.Title"), null, SVNTeamUIPlugin.instance().getResource("DiscardedLocationHelper.Dialog.Message", new String[]{project.getName(), location.getLabel()}), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    solved[0] = dlg.open() == 0;
                }
            });
            if (solved[0]) {
                AddRepositoryLocationOperation mainOp = new AddRepositoryLocationOperation(location);
                CompositeOperation op = new CompositeOperation(mainOp.getId());
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new SaveRepositoryLocationsOperation());
                op.add((IActionOperation)new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{location}, true));
                UIMonitorUtility.doTaskBusyDefault((IActionOperation)op);
            }
            return solved[0];
        }
        return false;
    }
}

