/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote.management;

import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRevisionLinkOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.panel.common.InputRevisionPanel;

public class SelectResourceRevisionAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        this.runImpl(resources);
    }

    protected void runImpl(IRepositoryResource[] resources) {
        SVNRevision selectedRevision = null;
        if (resources.length == 1) {
            InputRevisionPanel panel = new InputRevisionPanel(resources[0], SVNTeamUIPlugin.instance().getResource("SelectResourceRevisionAction.InputRevisionPanel.Title"));
            DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
            if (dialog.open() == 0) {
                selectedRevision = panel.getSelectedRevision();
                resources[0] = SVNUtility.copyOf((IRepositoryResource)resources[0]);
                resources[0].setSelectedRevision(selectedRevision);
            } else {
                return;
            }
        }
        LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(resources);
        AddRevisionLinkOperation mainOp = new AddRevisionLinkOperation((IRepositoryResourceProvider)locateOp, selectedRevision);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        op.add((IActionOperation)locateOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{locateOp});
        op.add((IActionOperation)new SaveRepositoryLocationsOperation());
        HashSet<IRepositoryLocation> locations = new HashSet<IRepositoryLocation>();
        IRepositoryResource[] iRepositoryResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource resource = iRepositoryResourceArray[n2];
            locations.add(resource.getRepositoryLocation());
            ++n2;
        }
        op.add((IActionOperation)new RefreshRepositoryLocationsOperation(locations.toArray(new IRepositoryLocation[locations.size()]), true));
        this.runScheduled((IActionOperation)op);
    }

    public boolean isEnabled() {
        return this.getSelectedRepositoryResources().length > 0;
    }
}

