/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractWorkingCopyAction;
import org.eclipse.team.svn.ui.action.local.CompareWithWorkingCopyAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;
import org.eclipse.team.svn.ui.operation.ShowHistoryViewOperation;
import org.eclipse.team.svn.ui.panel.remote.CompareBranchTagPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class CompareWithBranchTagAction
extends AbstractWorkingCopyAction {
    protected int type;

    public CompareWithBranchTagAction(int type) {
        this.type = type;
    }

    public boolean isEnabled() {
        if (this.getSelectedResources().length == 1 && this.checkForResourcesPresence(CompareWithWorkingCopyAction.COMPARE_FILTER)) {
            boolean recommendedLayoutUsed;
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.getSelectedResources()[0]);
            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)this.getSelectedResources()[0]) : SVNRemoteStorage.instance().asRepositoryResource(this.getSelectedResources()[0]);
            boolean isCompareFoldersAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() == 5;
            boolean bl = recommendedLayoutUsed = SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure") && remote.getRepositoryLocation().isStructureEnabled();
            return (isCompareFoldersAllowed || this.getSelectedResources()[0].getType() == 1) && recommendedLayoutUsed;
        }
        return false;
    }

    public void runImpl(IAction action) {
        IResource resource = this.getSelectedResources()[0];
        ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resource);
        IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
        CompareBranchTagPanel panel = new CompareBranchTagPanel(remote, this.type);
        DefaultDialog dlg = new DefaultDialog(this.getShell(), panel);
        if (dlg.open() == 0) {
            remote = panel.getSelectedResoure();
            CompareResourcesOperation mainOp = new CompareResourcesOperation(local, remote);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            if (SVNTeamPreferences.getHistoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "connectToCompareWith")) {
                op.add((IActionOperation)new ShowHistoryViewOperation(resource, remote, 2, 2), new IActionOperation[]{mainOp});
            }
            this.runScheduled((IActionOperation)op);
        }
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

