/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;
import org.eclipse.team.svn.core.operation.local.change.visitors.RemoveNonVersionedVisitor;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class RemoveNonVersionedResourcesOperation
extends AbstractWorkingCopyOperation
implements IActionOperationProcessor {
    protected boolean addedAlso;

    public RemoveNonVersionedResourcesOperation(IResource[] resources, boolean addedAlso) {
        super("Operation.RemoveNonSVN", resources);
        this.addedAlso = addedAlso;
    }

    public RemoveNonVersionedResourcesOperation(IResourceProvider provider, boolean addedAlso) {
        super("Operation.RemoveNonSVN", provider);
        this.addedAlso = addedAlso;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = FileUtility.shrinkChildNodes(this.operableData());
        int i = 0;
        while (i < resources.length) {
            final IResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    ResourceChange change = ResourceChange.wrapLocalResource(null, SVNRemoteStorage.instance().asLocalResourceAccessible(current), false);
                    if (change != null) {
                        change.traverse(new RemoveNonVersionedVisitor(RemoveNonVersionedResourcesOperation.this.addedAlso), 2, RemoveNonVersionedResourcesOperation.this, monitor);
                    }
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    public void doOperation(IActionOperation op, IProgressMonitor monitor) {
        this.reportStatus(op.run(monitor).getStatus());
    }
}

