/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;

public class InitExtractLogOperation
extends AbstractActionOperation {
    public static final String COMPLETE_LOG_NAME = "/changes.log";
    public static final String DELETIONS_LOG_NAME = "/deletions.log";
    public static final String DELETIONS_TMP_LOG_NAME = "/deletions.log.tmp";
    protected String logPath;

    public InitExtractLogOperation(String logPath) {
        super("Operation.InitExtractLog");
        this.logPath = logPath;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        String date = formatter.format(new Date());
        InitExtractLogOperation.logToAll(this.logPath, "");
        InitExtractLogOperation.logToAll(this.logPath, date);
        InitExtractLogOperation.logToAll(this.logPath, "===============================================================================");
    }

    public static void logToAll(String logPath, String line) {
        InitExtractLogOperation.logTo(String.valueOf(logPath) + COMPLETE_LOG_NAME, line);
    }

    public static void logToDeletions(String logPath, String line, boolean temporary) {
        InitExtractLogOperation.logTo(String.valueOf(logPath) + (temporary ? DELETIONS_TMP_LOG_NAME : DELETIONS_LOG_NAME), line);
    }

    private static void logTo(String logPath, String line) {
        block14: {
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(logPath, true);
                    writer.write(line);
                    writer.write(System.getProperty("line.separator"));
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

