/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRemoteContentsOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryResourceProvider provider;
    protected HashMap<String, String> remotePath2localPath;

    public GetRemoteContentsOperation(IResource[] resources, final IRepositoryResource[] remoteResources, HashMap<String, String> remotePath2localPath) {
        this(resources, new IRepositoryResourceProvider(){

            public IRepositoryResource[] getRepositoryResources() {
                return remoteResources;
            }
        }, remotePath2localPath);
    }

    public GetRemoteContentsOperation(IResource[] resources, IRepositoryResourceProvider provider, HashMap<String, String> remotePath2localPath) {
        super("Operation.GetContent", resources);
        this.provider = provider;
        this.remotePath2localPath = remotePath2localPath;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] remoteResources = this.provider.getRepositoryResources();
        int i = 0;
        while (i < remoteResources.length && !monitor.isCanceled()) {
            final IRepositoryResource remote = remoteResources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    GetRemoteContentsOperation.this.doGet(remote, monitor);
                }
            }, monitor, remoteResources.length);
            ++i;
        }
    }

    protected void doGet(IRepositoryResource remote, IProgressMonitor monitor) throws Exception {
        block21: {
            IRepositoryLocation location = remote.getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                String url = SVNUtility.encodeURL(remote.getUrl());
                String wcPath = this.remotePath2localPath.get(url);
                if (remote instanceof IRepositoryFile) {
                    File file;
                    File parent = new File(wcPath.substring(0, wcPath.lastIndexOf("/")));
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    if (!(file = new File(wcPath)).exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream stream = null;
                    try {
                        try {
                            this.writeToConsole(0, "svn cat " + url + "@" + remote.getPegRevision() + " -r " + remote.getSelectedRevision() + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                            stream = new FileOutputStream(wcPath);
                            proxy.streamFileContent(SVNUtility.getEntryRevisionReference(remote), 2048, stream, new SVNProgressMonitor(this, monitor, null));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Exception exception) {}
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block21;
                }
                File directory = new File(wcPath);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                this.writeToConsole(0, "svn export " + url + "@" + remote.getPegRevision() + " -r " + remote.getSelectedRevision() + " \"" + wcPath + "\" --force " + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                proxy.doExport(SVNUtility.getEntryRevisionReference(remote), wcPath, null, 3, 4L, new SVNProgressMonitor(this, monitor, null));
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
        }
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), FileUtility.getNamesListAsString(this.provider.getRepositoryResources()));
    }
}

