/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRemoteStorage;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;

public class AddToSVNIgnoreOperation
extends AbstractWorkingCopyOperation {
    protected int ignoreType;
    protected String pattern;

    public AddToSVNIgnoreOperation(IResource[] resources, int ignoreType, String pattern) {
        super("Operation.AddToSVNIgnore", resources);
        this.ignoreType = ignoreType;
        this.pattern = pattern;
    }

    public AddToSVNIgnoreOperation(IResourceProvider provider, int ignoreType, String pattern) {
        super("Operation.AddToSVNIgnore", provider);
        this.ignoreType = ignoreType;
        this.pattern = pattern;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        final SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource current = resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    AddToSVNIgnoreOperation.this.handleResource(storage, current);
                }
            }, monitor, resources.length);
            ++i;
        }
    }

    protected void handleResource(IRemoteStorage storage, IResource current) throws Exception {
        IContainer parent = current.getParent();
        IRepositoryLocation location = storage.getRepositoryLocation((IResource)parent);
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            AddToSVNIgnoreOperation.changeIgnoreProperty(proxy, this.ignoreType, this.pattern, FileUtility.getWorkingCopyPath((IResource)parent), current.getName());
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }

    public static void changeIgnoreProperty(ISVNConnector proxy, int ignoreType, String pattern, String path, String name) throws Exception {
        SVNProperty data = proxy.getProperty(new SVNEntryRevisionReference(path), "svn:ignore", new SVNNullProgressMonitor());
        String ignoreValue = data == null ? "" : data.value;
        String mask = null;
        switch (ignoreType) {
            case 0: {
                mask = name;
                break;
            }
            case 1: {
                String extension = new Path(String.valueOf(path) + "/" + name).getFileExtension();
                if (extension == null) break;
                mask = "*." + extension;
                break;
            }
            case 2: {
                mask = pattern;
            }
        }
        ignoreValue = AddToSVNIgnoreOperation.addMask(ignoreValue, mask);
        proxy.setProperty(path, "svn:ignore", ignoreValue, 0, 0L, null, new SVNNullProgressMonitor());
    }

    protected static String addMask(String ignore, String mask) {
        if (mask == null || mask.length() == 0) {
            return ignore;
        }
        StringTokenizer tok = new StringTokenizer(ignore, "\n", false);
        boolean found = false;
        while (tok.hasMoreTokens()) {
            if (!tok.nextToken().equals(mask)) continue;
            found = true;
            break;
        }
        return found ? ignore : String.valueOf(ignore) + (ignore.length() > 0 ? "\n" : "") + mask;
    }
}

