/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.copymove;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.composite.RepositoryTreeComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.common.RepositoryTreePanel;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocationFilter;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevisions;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;

public class SelectDestinationPage
extends AbstractVerifiedWizardPage {
    protected IRepositoryResource[] resources;
    protected RepositoryTreeComposite repositoryTree;
    protected Text newResourceName;

    public SelectDestinationPage(IRepositoryResource[] resources) {
        super(SelectDestinationPage.class.getName(), SVNTeamUIPlugin.instance().getResource("RepositoryTreePanel.Description"), SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(AbstractDialogPanel.makeToBeOperatedMessage(resources));
        this.resources = resources;
    }

    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.repositoryTree = new RepositoryTreeComposite(composite, 2048, false, new RepositoryTreePanel.ProjectRoot(this.resources[0]));
        RepositoryTreePanel.ProjectRoot root = (RepositoryTreePanel.ProjectRoot)this.repositoryTree.getRepositoryTreeViewer().getInput();
        this.repositoryTree.getRepositoryTreeViewer().setExpandedElements(new Object[]{root.getChildren(null)[0]});
        String url = this.resources[0].getRepositoryLocation().getRepositoryRootUrl();
        this.repositoryTree.setFilter(new RepositoryLocationFilter(url){

            public boolean accept(Object obj) {
                if (obj instanceof RepositoryFile || obj instanceof RepositoryRevisions || obj instanceof RepositoryFolder && this.acceptYourself(((RepositoryFolder)obj).getRepositoryResource())) {
                    return false;
                }
                return super.accept(obj);
            }

            private boolean acceptYourself(IRepositoryResource resource) {
                int i = 0;
                while (i < SelectDestinationPage.this.resources.length) {
                    if (resource.equals(SelectDestinationPage.this.resources[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        this.repositoryTree.setLayoutData(data);
        this.repositoryTree.getRepositoryTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectDestinationPage.this.validateContent();
            }
        });
        data = new GridData();
        Label name = new Label(composite, 0);
        name.setText(SVNTeamUIPlugin.instance().getResource(this.resources.length == 1 ? "CopyMove.SubFolder.One" : "CopyMove.SubFolder.Multi"));
        name.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.newResourceName = new Text(composite, 2048);
        this.newResourceName.setLayoutData((Object)data);
        CompositeVerifier verifier = new CompositeVerifier();
        if (this.resources.length == 1) {
            verifier.add(new NonEmptyFieldVerifier(name.getText()));
            this.newResourceName.setText(this.resources[0].getName());
        }
        verifier.add(new ResourceNameVerifier(name.getText(), CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() == 5));
        this.attachTo((Control)this.newResourceName, verifier);
        return composite;
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && !this.repositoryTree.getRepositoryTreeViewer().getSelection().isEmpty();
    }

    public IRepositoryResource getDestination() {
        IStructuredSelection sel = (IStructuredSelection)this.repositoryTree.getRepositoryTreeViewer().getSelection();
        return ((RepositoryResource)sel.getFirstElement()).getRepositoryResource();
    }

    public String getNewResourceName() {
        return this.newResourceName.getText();
    }
}

