/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.merge;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AbstractMergeSet;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.operation.local.MergeSet1URL;
import org.eclipse.team.svn.core.operation.local.MergeSet2URL;
import org.eclipse.team.svn.core.operation.local.MergeSetReintegrate;
import org.eclipse.team.svn.core.operation.local.MergeStatusOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.resource.IChangeStateProvider;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.ui.synchronize.RemoteStatusCache;
import org.eclipse.team.svn.ui.synchronize.merge.MergeScope;
import org.eclipse.team.svn.ui.synchronize.merge.MergeSyncInfo;
import org.eclipse.team.svn.ui.synchronize.update.UpdateSyncInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSubscriber
extends AbstractSVNSubscriber {
    private static MergeSubscriber instance = null;
    protected MergeScope scope;
    protected MergeStatusOperation mergeStatusOp;
    protected RemoteStatusCache baseStatusCache = new RemoteStatusCache();

    public static synchronized MergeSubscriber instance() {
        if (instance == null) {
            instance = new MergeSubscriber();
        }
        return instance;
    }

    public MergeScope getMergeScope() {
        return this.scope;
    }

    public void setMergeScope(MergeScope scope) {
        this.scope = scope;
    }

    @Override
    protected SyncInfo getSVNSyncInfo(ILocalResource localStatus, IResourceChange remoteStatus) {
        IResourceChange baseStatus = SVNRemoteStorage.instance().resourceChangeFromBytes(this.baseStatusCache.getBytes(localStatus.getResource()));
        return remoteStatus != null && IStateFilter.SF_NOTMODIFIED.accept((ILocalResource)remoteStatus) ? new UpdateSyncInfo(localStatus, null, this.getResourceComparator()) : new MergeSyncInfo(localStatus, baseStatus, remoteStatus, this.getResourceComparator());
    }

    @Override
    protected IRemoteStatusOperation addStatusOperation(CompositeOperation op, IResource[] resources, int depth) {
        this.mergeStatusOp = this.scope == null ? null : new MergeStatusOperation(this.scope.getMergeSet(), resources);
        MergeStatusOperation mergeOp = this.mergeStatusOp;
        if (mergeOp == null) {
            return null;
        }
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)mergeOp);
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources, depth, RefreshResourcesOperation.REFRESH_CHANGES));
        return mergeOp;
    }

    @Override
    protected HashSet<IResource> clearRemoteStatusesImpl(IResource[] resources) {
        this.clearRemoteStatusesImpl(this.baseStatusCache, resources);
        return super.clearRemoteStatusesImpl(resources);
    }

    @Override
    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) {
        if (this.scope != null) {
            this.baseStatusCache.clearAll();
            this.scope.getMergeSet().setStatuses(new SVNMergeStatus[0]);
        }
        super.refresh(resources, depth, monitor);
    }

    @Override
    protected IResourceChange handleResourceChange(IRemoteStatusOperation rStatusOp, SVNEntryStatus status) {
        final SVNMergeStatus current = (SVNMergeStatus)status;
        IChangeStateProvider endProvider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.date;
            }

            public String getChangeAuthor() {
                return current.author;
            }

            public SVNRevision.Number getChangeRevision() {
                return current.endRevision == -1L ? null : SVNRevision.fromNumber((long)current.endRevision);
            }

            public int getTextChangeType() {
                return current.skipped ? current.textStatus : 1;
            }

            public int getPropertiesChangeType() {
                return current.skipped ? current.propStatus : 0;
            }

            public int getNodeKind() {
                int kind = SVNUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)true);
                return kind == 0 ? SVNUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)false) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return current.comment;
            }

            public boolean isCopied() {
                return false;
            }

            public boolean isSwitched() {
                return false;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf((IResource[])MergeSubscriber.this.scope.getRoots(), (IResource[])set);
            }
        };
        if (endProvider.getNodeKind() == 0) {
            return null;
        }
        IResourceChange endResourceChange = SVNRemoteStorage.instance().asResourceChange(endProvider, false);
        if (endResourceChange == null) {
            return null;
        }
        if (endResourceChange.getRevision() != -1L) {
            IRepositoryResource originator = this.getEndOriginator();
            String decodedUrl = SVNUtility.decodeURL((String)current.endUrl);
            originator = endProvider.getNodeKind() == 2 ? originator.asRepositoryContainer(decodedUrl, false) : originator.asRepositoryFile(decodedUrl, false);
            originator.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)(current.textStatus == 4 ? current.endRevision - 1L : current.endRevision)));
            endResourceChange.setOriginator(originator);
        }
        IChangeStateProvider startProvider = new IChangeStateProvider(){

            public long getChangeDate() {
                return current.date;
            }

            public String getChangeAuthor() {
                return null;
            }

            public SVNRevision.Number getChangeRevision() {
                return current.startRevision == -1L ? null : SVNRevision.fromNumber((long)current.startRevision);
            }

            public int getTextChangeType() {
                return current.startRevision == -1L ? 0 : 1;
            }

            public int getPropertiesChangeType() {
                return 0;
            }

            public int getNodeKind() {
                int kind = SVNUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)true);
                return kind == 0 ? SVNUtility.getNodeKind((String)current.path, (int)current.nodeKind, (boolean)false) : kind;
            }

            public String getLocalPath() {
                return current.path;
            }

            public String getComment() {
                return null;
            }

            public boolean isCopied() {
                return false;
            }

            public boolean isSwitched() {
                return false;
            }

            public IResource getExact(IResource[] set) {
                return FileUtility.selectOneOf((IResource[])MergeSubscriber.this.scope.getRoots(), (IResource[])set);
            }
        };
        IResourceChange startResourceChange = SVNRemoteStorage.instance().asResourceChange(startProvider, false);
        if (startResourceChange.getRevision() != -1L) {
            String decodedUrl = SVNUtility.decodeURL((String)current.startUrl);
            IRepositoryResource originator = this.getStartOriginator();
            originator = startProvider.getNodeKind() == 2 ? originator.asRepositoryContainer(decodedUrl, false) : originator.asRepositoryFile(decodedUrl, false);
            originator.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)current.startRevision));
            startResourceChange.setOriginator(originator);
        }
        this.baseStatusCache.setBytes(startResourceChange.getResource(), SVNRemoteStorage.instance().resourceChangeAsBytes(startResourceChange));
        return endResourceChange;
    }

    protected IRepositoryResource getEndOriginator() {
        AbstractMergeSet mergeSet = this.scope.getMergeSet();
        if (mergeSet instanceof MergeSet1URL) {
            return ((MergeSet1URL)mergeSet).from[0];
        }
        if (mergeSet instanceof MergeSet2URL) {
            return ((MergeSet2URL)mergeSet).fromEnd[0];
        }
        return ((MergeSetReintegrate)mergeSet).from[0];
    }

    protected IRepositoryResource getStartOriginator() {
        AbstractMergeSet mergeSet = this.scope.getMergeSet();
        if (mergeSet instanceof MergeSet1URL) {
            return ((MergeSet1URL)mergeSet).from[0];
        }
        if (mergeSet instanceof MergeSet2URL) {
            return ((MergeSet2URL)mergeSet).fromStart[0];
        }
        return ((MergeSetReintegrate)mergeSet).from[0];
    }

    @Override
    protected boolean isIncoming(SVNEntryStatus status) {
        return true;
    }

    private MergeSubscriber() {
    }
}

