/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AddToSVNIgnoreOperation;
import org.eclipse.team.svn.core.operation.local.CreatePatchOperation;
import org.eclipse.team.svn.core.operation.local.ExportOperation;
import org.eclipse.team.svn.core.operation.local.LockOperation;
import org.eclipse.team.svn.core.operation.local.MarkAsMergedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.UnlockOperation;
import org.eclipse.team.svn.core.operation.local.management.CleanupOperation;
import org.eclipse.team.svn.core.operation.local.property.GetPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.local.AddToSVNIgnoreAction;
import org.eclipse.team.svn.ui.action.local.BranchTagAction;
import org.eclipse.team.svn.ui.action.local.CompareWithWorkingCopyAction;
import org.eclipse.team.svn.ui.action.local.ReplaceWithLatestRevisionAction;
import org.eclipse.team.svn.ui.action.local.ReplaceWithRevisionAction;
import org.eclipse.team.svn.ui.action.local.RevertAction;
import org.eclipse.team.svn.ui.composite.CommentComposite;
import org.eclipse.team.svn.ui.composite.ResourceSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.DiscardConfirmationDialog;
import org.eclipse.team.svn.ui.dialog.UnlockResourcesDialog;
import org.eclipse.team.svn.ui.event.IResourceSelectionChangeListener;
import org.eclipse.team.svn.ui.event.ResourceSelectionChangedEvent;
import org.eclipse.team.svn.ui.extension.factory.ICommentDialogPanel;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;
import org.eclipse.team.svn.ui.operation.ShowConflictEditorOperation;
import org.eclipse.team.svn.ui.panel.common.CommentPanel;
import org.eclipse.team.svn.ui.panel.local.LockPanel;
import org.eclipse.team.svn.ui.panel.remote.ComparePanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.eclipse.team.svn.ui.propfind.BugtraqPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.CompositePropFindVisitor;
import org.eclipse.team.svn.ui.propfind.IPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.LogTemplatesPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.MaxLogWidthPropFindVisitor;
import org.eclipse.team.svn.ui.propfind.MinLockSizePropFindVisitor;
import org.eclipse.team.svn.ui.propfind.MinLogSizePropFindVisitor;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;

public class CommitPanel
extends CommentPanel
implements ICommentDialogPanel {
    public static final int MSG_COMMIT = 0;
    public static final int MSG_OVER_AND_COMMIT = 1;
    public static final int MAXIMUM_CHECKS_SIZE = 100;
    protected ResourceSelectionComposite selectionComposite;
    protected Button keepLocksButton;
    protected Button pasteNamesButton;
    protected SashForm sForm;
    protected IResource[] resources;
    protected boolean keepLocks;
    protected List<IResourceSelectionChangeListener> changeListenerList;
    protected IResource[] userSelectedResources;
    protected int minLogSize;
    protected int maxLogWidth;
    protected final String proposedComment;
    protected IResourceStatesListener resourceStatesListener;
    protected boolean resourcesChanged;

    public CommitPanel(IResource[] resources, int msgType) {
        this(resources, msgType, null);
    }

    public CommitPanel(IResource[] resources, int msgType, String proposedComment) {
        this(resources, null, msgType, proposedComment);
    }

    public CommitPanel(IResource[] resources, IResource[] userSelectedResources, int msgType, String proposedComment) {
        super(SVNTeamUIPlugin.instance().getResource("CommitPanel.Title"));
        this.proposedComment = proposedComment;
        this.resources = resources;
        if (msgType == 1) {
            this.defaultMessage = SVNTeamUIPlugin.instance().getResource("CommitPanel.Message");
            this.dialogDescription = SVNTeamUIPlugin.instance().getResource("CommitPanel.Description");
        }
        this.changeListenerList = new ArrayList<IResourceSelectionChangeListener>();
        this.userSelectedResources = userSelectedResources;
    }

    public void createControlsImpl(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        layout = (GridLayout)parent.getLayout();
        layout.marginHeight = 3;
        this.sForm = new SashForm(parent, 512);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        this.sForm.setLayout((Layout)layout);
        data = new GridData(1808);
        data.heightHint = 400;
        this.sForm.setLayoutData((Object)data);
        Composite composite = new Composite((Composite)this.sForm, 0);
        composite.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNTeamUIPlugin.instance().getResource("CommitPanel.Comment"));
        CollectPropertiesOperation op = new CollectPropertiesOperation(this.resources);
        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
        this.bugtraqModel = op.getBugtraqModel();
        this.minLogSize = op.getMinLogSize();
        this.maxLogWidth = op.getMaxLogWidth();
        this.comment = new CommentComposite((Composite)group, this.proposedComment, this, op.getLogTemplates(), this.bugtraqModel, this.minLogSize, this.maxLogWidth);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
        Composite middleComposite = new Composite(composite, 0);
        data = new GridData(768);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.numColumns = 2;
        middleComposite.setLayoutData((Object)data);
        middleComposite.setLayout((Layout)layout);
        this.keepLocksButton = new Button(middleComposite, 32);
        data = new GridData(769);
        this.keepLocksButton.setLayoutData((Object)data);
        this.keepLocksButton.setText(SVNTeamUIPlugin.instance().getResource("CommitPanel.KeepLocks"));
        this.keepLocksButton.setSelection(false);
        this.keepLocksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitPanel.this.keepLocks = CommitPanel.this.keepLocksButton.getSelection();
            }
        });
        this.pasteNamesButton = new Button(middleComposite, 0x1000008);
        data = new GridData();
        this.pasteNamesButton.setLayoutData((Object)data);
        this.pasteNamesButton.setText(SVNTeamUIPlugin.instance().getResource("CommitPanel.PasteNames.Button"));
        this.pasteNamesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitPanel.this.pasteNames();
            }
        });
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.selectionComposite = new ResourceSelectionComposite((Composite)this.sForm, 0, this.resources, true, this.userSelectedResources);
        data = new GridData(1808);
        data.heightHint = 175;
        this.selectionComposite.setLayoutData(data);
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        int first = SVNTeamPreferences.getDialogInt(store, "CommitPanel.weight");
        this.sForm.setWeights(new int[]{first, 100 - first});
        this.selectionComposite.addResourcesSelectionChangedListener(new IResourceSelectionChangeListener(){

            public void resourcesSelectionChanged(ResourceSelectionChangedEvent event) {
                CommitPanel.this.fireResourcesSelectionChanged(event);
            }
        });
        this.attachTo((Control)this.selectionComposite, new AbstractVerifier(){

            protected String getErrorMessage(Control input) {
                IResource[] selection = CommitPanel.this.getSelectedResources();
                if (selection == null || selection.length == 0) {
                    return SVNTeamUIPlugin.instance().getResource("ResourceSelectionComposite.Verifier.Error");
                }
                if (FileUtility.checkForResourcesPresenceRecursive((IResource[])selection, (IStateFilter)IStateFilter.SF_CONFLICTING)) {
                    return SVNTeamUIPlugin.instance().getResource("CommitPanel.Conflicting.Error");
                }
                return null;
            }

            protected String getWarningMessage(Control input) {
                return null;
            }
        });
        this.addContextMenu();
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.commitDialogContext";
    }

    public void postInit() {
        super.postInit();
        this.resourceStatesListener = new IResourceStatesListener(){

            public void resourcesStateChanged(ResourceStatesChangedEvent event) {
                CommitPanel.this.updateResources(event);
            }
        };
        SVNRemoteStorage.instance().addResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    protected void saveChangesImpl() {
        super.saveChangesImpl();
        this.retainWeights();
    }

    protected void cancelChangesImpl() {
        super.cancelChangesImpl();
        this.retainWeights();
    }

    public boolean canClose() {
        final boolean[] commit = new boolean[]{true};
        if (this.bugtraqModel != null && this.bugtraqModel.getMessage() != null && this.bugtraqModel.isWarnIfNoIssue() && this.comment.getBugID() != null && this.comment.getBugID().trim().length() == 0) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), SVNTeamUIPlugin.instance().getResource("CommitPanel.NoBugId.Title"), null, SVNTeamUIPlugin.instance().getResource("CommitPanel.NoBugId.Message"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    commit[0] = dlg.open() == 0;
                }
            });
        }
        return commit[0];
    }

    protected void pasteNames() {
        List selectedResources = this.selectionComposite.getCurrentSelection();
        String namesString = "";
        for (IResource resource : selectedResources) {
            namesString = String.valueOf(namesString) + resource.getName() + "\n";
        }
        this.comment.insertText(namesString);
    }

    protected void addContextMenu() {
        final TableViewer tableViewer = this.selectionComposite.getTableViewer();
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager subMenu;
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection tSelection = (IStructuredSelection)tableViewer.getSelection();
                final IResource[] selectedResources = tSelection.toList().toArray(new IResource[tSelection.size()]);
                Action tAction = null;
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CommitPanel.PasteNames.Action")){

                    public void run() {
                        CommitPanel.this.pasteNames();
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0);
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CreatePatchCommand.label")){

                    public void run() {
                        FileDialog dlg = new FileDialog(UIMonitorUtility.getShell(), 40960);
                        dlg.setText(SVNTeamUIPlugin.instance().getResource("SelectPatchFilePage.SavePatchAs"));
                        dlg.setFileName(String.valueOf(selectedResources[0].getName()) + ".patch");
                        dlg.setFilterExtensions(new String[]{"patch", "*.*"});
                        String file = dlg.open();
                        if (file != null) {
                            CreatePatchOperation mainOp = new CreatePatchOperation(new IResource[]{selectedResources[0]}, file, true, true, true, true);
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)mainOp, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED, (int)0));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("BranchAction.label")){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)2);
                        IActionOperation op = BranchTagAction.getBranchTagOperation(UIMonitorUtility.getShell(), 0, resources);
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0));
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/branch.gif"));
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CommitPanel.Revert.Action")){

                    public void run() {
                        IResource[] changedResources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)RevertAction.SF_REVERTABLE_OR_NEW);
                        CompositeOperation revertOp = RevertAction.getRevertOperation(UIMonitorUtility.getShell(), changedResources, selectedResources);
                        if (revertOp != null) {
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)revertOp, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/revert.gif"));
                tAction.setEnabled(tSelection.size() > 0);
                if (tSelection.size() > 0 && selectedResources.length == FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)AddToSVNIgnoreAction.SF_NEW_AND_PARENT_VERSIONED).length) {
                    subMenu = new MenuManager(SVNTeamUIPlugin.instance().getResource("CommitPanel.Ignore.Group"));
                    if (tSelection.size() > 1) {
                        tAction = new Action(SVNTeamUIPlugin.instance().getResource("CommitPanel.IgnoreByName.Multiple.Action")){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("AddToIgnore");
                                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 0, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        subMenu.add((IAction)tAction);
                        tAction.setEnabled(true);
                        tAction = new Action(SVNTeamUIPlugin.instance().getResource("CommitPanel.IgnoreByExtension.Multiple.Action")){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("AddToIgnore");
                                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 1, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        subMenu.add((IAction)tAction);
                        tAction.setEnabled(true);
                    } else {
                        tAction = new Action(selectedResources[0].getName()){

                            public void run() {
                                CompositeOperation op = new CompositeOperation("AddToIgnore");
                                op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 0, null));
                                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                            }
                        };
                        subMenu.add((IAction)tAction);
                        tAction.setEnabled(true);
                        String name = selectedResources[0].getName();
                        String[] parts = name.split("\\.");
                        if (parts.length != 0) {
                            tAction = new Action("*." + parts[parts.length - 1]){

                                public void run() {
                                    CompositeOperation op = new CompositeOperation("AddToIgnore");
                                    op.add((IActionOperation)new AddToSVNIgnoreOperation(selectedResources, 1, null));
                                    op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((this).CommitPanel.this.resources), 2, RefreshResourcesOperation.REFRESH_ALL));
                                    UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                                }
                            };
                            subMenu.add((IAction)tAction);
                            tAction.setEnabled(true);
                        }
                    }
                    manager.add((IContributionItem)subMenu);
                }
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("EditConflictsAction.label")){

                    public void run() {
                        UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new ShowConflictEditorOperation(FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_CONFLICTING), true));
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_CONFLICTING));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CommitPanel.MarkAsMerged.Action")){

                    public void run() {
                        MarkAsMergedOperation mainOp = new MarkAsMergedOperation(selectedResources, false, null);
                        CompositeOperation op = new CompositeOperation(mainOp.getId());
                        op.add((IActionOperation)mainOp);
                        op.add((IActionOperation)new RefreshResourcesOperation(FileUtility.getParents((IResource[])selectedResources, (boolean)false)));
                        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_CONFLICTING) && selectedResources.length == 1);
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("LockAction.label")){

                    public void run() {
                        boolean containsFolder = false;
                        int i = 0;
                        while (i < selectedResources.length) {
                            if (selectedResources[i] instanceof IContainer) {
                                containsFolder = true;
                                break;
                            }
                            ++i;
                        }
                        CollectPropertiesOperation cop = new CollectPropertiesOperation(selectedResources);
                        ProgressMonitorUtility.doTaskExternal((IActionOperation)cop, null);
                        LockPanel commentPanel = new LockPanel(!containsFolder, cop.getMinLockSize());
                        DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), commentPanel);
                        if (dialog.open() == 0) {
                            IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_READY_TO_LOCK, (int)(commentPanel.isRecursive() ? 2 : 1));
                            LockOperation mainOp = new LockOperation(resources, commentPanel.getMessage(), commentPanel.getForce());
                            CompositeOperation op = new CompositeOperation(mainOp.getId());
                            op.add((IActionOperation)mainOp);
                            op.add((IActionOperation)new RefreshResourcesOperation(resources));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/lock.gif"));
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_READY_TO_LOCK));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("UnlockAction.label")){

                    public void run() {
                        boolean recursive = false;
                        int i = 0;
                        while (i < selectedResources.length) {
                            if (selectedResources[i].getType() != 1) {
                                recursive = true;
                                break;
                            }
                            ++i;
                        }
                        UnlockResourcesDialog dialog = new UnlockResourcesDialog(UIMonitorUtility.getShell(), recursive);
                        if (dialog.open() == 0) {
                            IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_LOCKED, (int)(dialog.isRecursive() ? 2 : 1));
                            UnlockOperation mainOp = new UnlockOperation(resources);
                            CompositeOperation op = new CompositeOperation(mainOp.getId());
                            op.add((IActionOperation)mainOp);
                            op.add((IActionOperation)new RefreshResourcesOperation(resources));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/unlock.gif"));
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_LOCKED));
                manager.add((IContributionItem)new Separator());
                subMenu = new MenuManager(SVNTeamUIPlugin.instance().getResource("CommitPanel.CompareWith.Group"));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CompareWithWorkingCopyAction.label")){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                            remote.setSelectedRevision(SVNRevision.BASE);
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER, (int)0));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CompareWithLatestRevisionAction.label")){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                            remote.setSelectedRevision(SVNRevision.HEAD);
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() == 5 || selectedResources[0].getType() == 1) && FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CompareWithRevisionAction.label")){

                    public void run() {
                        IResource resource = selectedResources[0];
                        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                        if (!IStateFilter.SF_INTERNAL_INVALID.accept(local)) {
                            IRepositoryResource remote = local.isCopied() ? SVNUtility.getCopiedFrom((IResource)resource) : SVNRemoteStorage.instance().asRepositoryResource(resource);
                            ComparePanel panel = new ComparePanel(remote, local.getRevision());
                            DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                            if (dlg.open() == 0) {
                                remote = panel.getSelectedResource();
                                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new CompareResourcesOperation(local, remote, false, true));
                            }
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && (CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() == 5 || selectedResources[0].getType() == 1) && FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)CompareWithWorkingCopyAction.COMPARE_FILTER));
                manager.add((IContributionItem)subMenu);
                subMenu = new MenuManager(SVNTeamUIPlugin.instance().getResource("CommitPanel.ReplaceWith.Group"));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("ReplaceWithLatestRevisionAction.label")){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0);
                        IActionOperation op = ReplaceWithLatestRevisionAction.getReplaceOperation(resources, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(FileUtility.checkForResourcesPresenceRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("ReplaceWithRevisionAction.label")){

                    public void run() {
                        IActionOperation op = ReplaceWithRevisionAction.getReplaceOperation(selectedResources, UIMonitorUtility.getShell());
                        if (op != null) {
                            UIMonitorUtility.doTaskNowDefault(op, true);
                        }
                    }
                };
                subMenu.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() == 1 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0));
                manager.add((IContributionItem)subMenu);
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("ExportCommand.label")){

                    public void run() {
                        DirectoryDialog fileDialog = new DirectoryDialog(UIMonitorUtility.getShell());
                        fileDialog.setText(SVNTeamUIPlugin.instance().getResource("ExportAction.Select.Title"));
                        fileDialog.setMessage(SVNTeamUIPlugin.instance().getResource("ExportAction.Select.Description"));
                        String path = fileDialog.open();
                        if (path != null) {
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new ExportOperation(FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0), path, SVNRevision.WORKING));
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/export.gif"));
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_EXCLUDE_DELETED, (int)0));
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CleanupCommand.label")){

                    public void run() {
                        IResource[] resources = FileUtility.getResourcesRecursive((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED_FOLDERS, (int)0);
                        CleanupOperation mainOp = new CleanupOperation(resources);
                        CompositeOperation op = new CompositeOperation(mainOp.getId());
                        op.add((IActionOperation)mainOp);
                        op.add((IActionOperation)new RefreshResourcesOperation(resources));
                        UIMonitorUtility.doTaskNowDefault((IActionOperation)op, false);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(tSelection.size() > 0 && FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_VERSIONED_FOLDERS, (int)0));
                manager.add((IContributionItem)new Separator());
                tAction = new Action(SVNTeamUIPlugin.instance().getResource("CommitPanel.Delete.Action")){

                    public void run() {
                        DiscardConfirmationDialog dialog = new DiscardConfirmationDialog(UIMonitorUtility.getShell(), selectedResources.length == 1, 2);
                        if (dialog.open() == 0) {
                            DeleteResourceOperation deleteOperation = new DeleteResourceOperation(selectedResources);
                            CompositeOperation op = new CompositeOperation(deleteOperation.getId());
                            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(selectedResources);
                            RestoreProjectMetaOperation restoreOp = new RestoreProjectMetaOperation(saveOp);
                            op.add((IActionOperation)saveOp);
                            op.add((IActionOperation)deleteOperation);
                            op.add((IActionOperation)restoreOp);
                            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(selectedResources), 2, RefreshResourcesOperation.REFRESH_CHANGES));
                            UIMonitorUtility.doTaskNowDefault((IActionOperation)op, true);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete.gif"));
                tAction.setEnabled(tSelection.size() > 0 && !FileUtility.checkForResourcesPresence((IResource[])selectedResources, (IStateFilter)IStateFilter.SF_DELETED, (int)0));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tableViewer.getTable().setMenu(menu);
    }

    protected void updateResources(ResourceStatesChangedEvent event) {
        HashSet allResources = new HashSet(Arrays.asList(this.resources));
        HashSet toDeleteSet = new HashSet();
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTMODIFIED, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_NOTEXISTS, (int)0)));
        toDeleteSet.addAll(Arrays.asList(FileUtility.getResourcesRecursive((IResource[])event.resources, (IStateFilter)IStateFilter.SF_IGNORED, (int)0)));
        allResources.removeAll(toDeleteSet);
        final IResource[] newResources = allResources.toArray(new IResource[allResources.size()]);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (!CommitPanel.this.selectionComposite.isDisposed()) {
                    CommitPanel.this.selectionComposite.setResources(newResources);
                    CommitPanel.this.selectionComposite.fireSelectionChanged();
                }
            }
        });
        this.resources = newResources;
        this.resourcesChanged = true;
    }

    public boolean getResourcesChanged() {
        return this.resourcesChanged;
    }

    public IResource[] getSelectedResources() {
        return this.selectionComposite.getSelectedResources();
    }

    public IResource[] getNotSelectedResources() {
        return this.selectionComposite.getNotSelectedResources();
    }

    public void addResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.add(listener);
    }

    public void removeResourcesSelectionChangedListener(IResourceSelectionChangeListener listener) {
        this.changeListenerList.remove(listener);
    }

    public void fireResourcesSelectionChanged(ResourceSelectionChangedEvent event) {
        this.validateContent();
        IResourceSelectionChangeListener[] listeners = this.changeListenerList.toArray(new IResourceSelectionChangeListener[this.changeListenerList.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesSelectionChanged(event);
            ++i;
        }
    }

    public boolean getKeepLocks() {
        return this.keepLocks;
    }

    protected Point getPrefferedSizeImpl() {
        return new Point(600, -1);
    }

    protected void retainWeights() {
        int[] weights = this.sForm.getWeights();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        SVNTeamPreferences.setDialogInt(store, "CommitPanel.weight", weights[0] / 10);
    }

    public void dispose() {
        super.dispose();
        SVNRemoteStorage.instance().removeResourceStatesListener(ResourceStatesChangedEvent.class, this.resourceStatesListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectPropertiesOperation
    extends AbstractActionOperation {
        protected IResource[] resources;
        protected MinLogSizePropFindVisitor minLogVisitor;
        protected LogTemplatesPropFindVisitor logTemplateVisitor;
        protected BugtraqPropFindVisitor bugtraqVisitor;
        protected MaxLogWidthPropFindVisitor maxWidthVisitor;
        protected MinLockSizePropFindVisitor minLockVisitor;
        protected CompositePropFindVisitor compositeVisitor;

        public CollectPropertiesOperation(IResource[] resources) {
            super("Operation.CollectProperties");
            this.resources = resources;
            this.logTemplateVisitor = new LogTemplatesPropFindVisitor();
            this.bugtraqVisitor = new BugtraqPropFindVisitor();
            this.minLogVisitor = new MinLogSizePropFindVisitor();
            this.maxWidthVisitor = new MaxLogWidthPropFindVisitor();
            this.minLockVisitor = new MinLockSizePropFindVisitor();
            this.compositeVisitor = SVNTeamPreferences.getCommentTemplatesBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "comment.logTemplates.enabled") ? new CompositePropFindVisitor(new IPropFindVisitor[]{this.logTemplateVisitor, this.bugtraqVisitor, this.minLogVisitor, this.maxWidthVisitor, this.minLockVisitor}) : new CompositePropFindVisitor(new IPropFindVisitor[]{this.bugtraqVisitor, this.minLogVisitor, this.maxWidthVisitor, this.minLockVisitor});
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            ArrayList<IResource> parentProperties = new ArrayList<IResource>();
            int length = this.resources.length < 100 ? this.resources.length : 100;
            int i = 0;
            while (i < length && !monitor.isCanceled()) {
                ProgressMonitorUtility.setTaskInfo((IProgressMonitor)monitor, (IActionOperation)this, (String)this.resources[i].getFullPath().toString());
                ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(this.resources[i]);
                IResource resourceToProcess = this.resources[i];
                while (IStateFilter.SF_UNVERSIONED.accept(local)) {
                    resourceToProcess = resourceToProcess.getParent();
                    local = SVNRemoteStorage.instance().asLocalResourceAccessible(resourceToProcess);
                }
                if (!this.processProperty(resourceToProcess, parentProperties, monitor)) break;
                ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)length);
                ++i;
            }
        }

        protected boolean processProperty(IResource resource, ArrayList<IResource> parentProperties, IProgressMonitor monitor) {
            SVNProperty[] properties;
            if (parentProperties.contains(resource) || monitor.isCanceled()) {
                return true;
            }
            GetPropertiesOperation op = new GetPropertiesOperation(resource);
            ProgressMonitorUtility.doTaskExternalDefault((IActionOperation)op, (IProgressMonitor)monitor);
            if (op.getExecutionState() == 0 && (properties = op.getProperties()) != null) {
                int i = 0;
                while (i < properties.length) {
                    if (!this.compositeVisitor.visit(properties[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            parentProperties.add(resource);
            IContainer parent = resource.getParent();
            if (parent != null && !(parent instanceof IWorkspaceRoot) && !monitor.isCanceled()) {
                return this.processProperty((IResource)parent, parentProperties, monitor);
            }
            return true;
        }

        public HashSet getLogTemplates() {
            return this.logTemplateVisitor.getLogTemplates();
        }

        public BugtraqModel getBugtraqModel() {
            return this.bugtraqVisitor.getBugtraqModel();
        }

        public int getMinLogSize() {
            return this.minLogVisitor.getMinLogSize();
        }

        public int getMinLockSize() {
            return this.minLockVisitor.getMinLockSize();
        }

        public int getMaxLogWidth() {
            return this.maxWidthVisitor.getMaxLogWidth();
        }
    }
}

