/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;

public class MoveProjectsToWorkingSetOperation
extends AbstractWorkingCopyOperation {
    protected String workingSetName;

    public MoveProjectsToWorkingSetOperation(IResource[] projects, String workingSetName) {
        super("Operation.MoveToWorkingSet", projects);
        this.workingSetName = workingSetName;
    }

    public MoveProjectsToWorkingSetOperation(IResourceProvider provider, String workingSetName) {
        super("Operation.MoveToWorkingSet", provider);
        this.workingSetName = workingSetName;
    }

    public int getOperationWeight() {
        return 0;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] projects = this.operableData();
        IWorkingSet wSet = null;
        IWorkingSetManager workingSetManager = SVNTeamUIPlugin.instance().getWorkbench().getWorkingSetManager();
        IWorkingSet[] workingSets = workingSetManager.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            if (workingSets[i].getName().equals(this.workingSetName)) {
                wSet = workingSets[i];
                ArrayList existing = new ArrayList();
                existing.addAll(Arrays.asList(wSet.getElements()));
                existing.addAll(Arrays.asList(projects));
                wSet.setElements(existing.toArray(new IAdaptable[existing.size()]));
                break;
            }
            ++i;
        }
        if (wSet == null) {
            wSet = workingSetManager.createWorkingSet(this.workingSetName, (IAdaptable[])projects);
            wSet.setId("org.eclipse.ui.resourceWorkingSetPage");
            workingSetManager.addWorkingSet(wSet);
        }
    }
}

