/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.decorator;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.events.IResourceStatesListener;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.decorator.AbstractResourceDecorator;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class FolderDecorator
extends AbstractResourceDecorator {
    protected boolean computeDeep;

    public FolderDecorator(IResourceStatesListener targetListener) {
        super(targetListener);
    }

    protected String getStatus(ILocalResource local) {
        if (this.computeDeep && local.getStatus() == "Normal" && FileUtility.checkForResourcesPresenceRecursive((IResource[])new IResource[]{local.getResource()}, (IStateFilter)IStateFilter.SF_MODIFIED_NOT_IGNORED)) {
            return "Modified";
        }
        return local.getStatus();
    }

    protected void loadConfiguration() {
        super.loadConfiguration();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        String formatLine = SVNTeamPreferences.getDecorationString(store, "format.folder");
        this.format = this.decorator.parseFormatLine(formatLine);
        this.computeDeep = SVNTeamPreferences.getDecorationBoolean(store, "compute.deep");
    }
}

