/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.CheckoutOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.action.AbstractRepositoryModifyWorkspaceAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.operation.ObtainProjectNameOperation;
import org.eclipse.team.svn.ui.panel.ListSelectionPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CheckoutAction
extends AbstractRepositoryModifyWorkspaceAction {
    public void runImpl(IAction action) {
        final IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (SVNTeamPreferences.getCheckoutBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "respectProjectStructure")) {
            this.runScheduled((IActionOperation)new AbstractActionOperation("Operation.CheckLayout"){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    final HashSet<Object> toCheckout = new HashSet<Object>();
                    int i = 0;
                    while (i < resources.length && !monitor.isCanceled()) {
                        int kind = ((IRepositoryRoot)resources[i].getRoot()).getKind();
                        if (!resources[i].getRepositoryLocation().isStructureEnabled() || kind != 0 && kind != 4) {
                            toCheckout.add(resources[i]);
                        } else {
                            IRepositoryContainer trunk = resources[i].asRepositoryContainer(resources[i].getRepositoryLocation().getTrunkLocation(), false);
                            if (!trunk.exists()) {
                                toCheckout.add(resources[i]);
                            } else {
                                IRepositoryFile projectFile = trunk.asRepositoryFile(".project", false);
                                if (projectFile.exists()) {
                                    toCheckout.add(trunk);
                                } else {
                                    IRepositoryResource[] children;
                                    IRepositoryResource[] iRepositoryResourceArray = children = trunk.getChildren();
                                    int n = children.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IRepositoryResource child = iRepositoryResourceArray[n2];
                                        if (child instanceof IRepositoryContainer) {
                                            toCheckout.add(child);
                                        }
                                        ++n2;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    if (!monitor.isCanceled()) {
                        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                IActionOperation op = ExtensionsManager.getInstance().getCurrentCheckoutFactory().getCheckoutOperation(UIMonitorUtility.getShell(), toCheckout.toArray(new IRepositoryResource[toCheckout.size()]), null, false, null, 3, false);
                                if (op != null) {
                                    UIMonitorUtility.doTaskScheduledWorkspaceModify(op);
                                }
                            }
                        });
                    }
                }

                public int getOperationWeight() {
                    return 2;
                }
            });
        } else {
            IActionOperation op = ExtensionsManager.getInstance().getCurrentCheckoutFactory().getCheckoutOperation(this.getShell(), resources, null, false, null, 3, false);
            if (op != null) {
                this.runScheduled(op);
            }
        }
    }

    public static NameSet getExistingProjectNames() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        NameSet set = new NameSet();
        int i = 0;
        while (i < projects.length) {
            set.existing.put(set.caseInsensitiveOS ? projects[i].getName().toLowerCase() : projects[i].getName(), FileUtility.getWorkingCopyPath((IResource)projects[i]));
            ++i;
        }
        return set;
    }

    public static ArrayList getOperateResources(HashMap names2resources, HashMap resources2names, Shell shell, final String location, boolean checkProjectExistance) {
        NameSet set = CheckoutAction.getExistingProjectNames();
        final HashMap existingResources = new HashMap();
        final HashMap existingFolders = new HashMap();
        ArrayList operateResources = new ArrayList();
        for (String key : names2resources.keySet()) {
            String resourceName = FileUtility.formatResourceName((String)key);
            Object currentResource = names2resources.get(key);
            File folder = new File(String.valueOf(location) + "/" + resourceName);
            if (set.existing.keySet().contains(set.caseInsensitiveOS ? resourceName.toLowerCase() : resourceName) && checkProjectExistance) {
                existingResources.put(resourceName, currentResource);
                if (FileUtility.formatPath((String)folder.getAbsolutePath()).equals(set.existing.get(set.caseInsensitiveOS ? resourceName.toLowerCase() : resourceName)) || !folder.exists() || (folder.listFiles() == null || folder.listFiles().length <= 0) && !folder.isFile()) continue;
                existingFolders.put(resourceName, currentResource);
                continue;
            }
            if (folder.exists() && (folder.listFiles() != null && folder.listFiles().length > 0 || folder.isFile())) {
                existingFolders.put(resourceName, currentResource);
                continue;
            }
            operateResources.add(currentResource);
        }
        if (existingResources.size() > 0 || existingFolders.size() > 0) {
            IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    HashSet existingSet = new HashSet();
                    existingSet.addAll(existingResources.keySet());
                    existingSet.addAll(existingFolders.keySet());
                    Object[] retVal = existingSet.toArray(new String[existingSet.size()]);
                    Arrays.sort(retVal);
                    return retVal;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
            ITableLabelProvider labelProvider = new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    if (columnIndex == 0) {
                        return (String)element;
                    }
                    if (columnIndex == 1) {
                        boolean project = existingResources.keySet().contains(element);
                        boolean folder = existingFolders.keySet().contains(element);
                        if (project && folder) {
                            return SVNTeamUIPlugin.instance().getResource("CheckoutAction.Type2");
                        }
                        if (project) {
                            return SVNTeamUIPlugin.instance().getResource("CheckoutAction.Type1");
                        }
                        if (folder) {
                            return SVNTeamUIPlugin.instance().getResource(new File(String.valueOf(location) + "/" + element).isDirectory() ? "CheckoutAction.Type3" : "CheckoutAction.Type4");
                        }
                        return "";
                    }
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
            String message = SVNTeamUIPlugin.instance().getResource(existingResources.size() > 1 ? "CheckoutAction.Selection.Description.Multi" : "CheckoutAction.Selection.Description.Single");
            ListSelectionPanel panel = new ListSelectionPanel(existingResources, contentProvider, (IBaseLabelProvider)labelProvider, message, SVNTeamUIPlugin.instance().getResource(existingResources.size() > 1 ? "CheckoutAction.Selection.Message.Multi" : "CheckoutAction.Selection.Message.Single"), SVNTeamUIPlugin.instance().getResource(existingResources.size() > 1 ? "CheckoutAction.Selection.Title.Multi" : "CheckoutAction.Selection.Title.Single"), true);
            if (new DefaultDialog(shell, panel).open() == 0) {
                Object[] selection = panel.getResultSelections();
                int i = 0;
                while (i < selection.length) {
                    Object selected = existingResources.get(selection[i]);
                    selected = selected == null ? existingFolders.get(selection[i]) : selected;
                    operateResources.add(selected);
                    ++i;
                }
            } else {
                operateResources.clear();
            }
        }
        return operateResources;
    }

    public static IActionOperation getCheckoutOperation(Shell shell, IRepositoryResource[] resources, HashMap checkoutMap, boolean respectHierarchy, String location, int recureDepth, boolean ignoreExternals) {
        HashMap resources2names;
        ArrayList operateResources;
        ArrayList resourceList = new ArrayList(Arrays.asList(resources));
        if (checkoutMap != null && checkoutMap.keySet().size() != resources.length) {
            Iterator iter = checkoutMap.entrySet().iterator();
            while (iter.hasNext()) {
                IRepositoryResource currentProject = (IRepositoryResource)iter.next().getValue();
                if (resourceList.contains(currentProject)) continue;
                iter.remove();
            }
        }
        if (checkoutMap == null) {
            ObtainProjectNameOperation obtainOperation = new ObtainProjectNameOperation(resources);
            UIMonitorUtility.doTaskNowDefault((IActionOperation)obtainOperation, true);
            if (obtainOperation.getExecutionState() != 0) {
                return null;
            }
            checkoutMap = obtainOperation.getNames2Resources();
        }
        if ((operateResources = CheckoutAction.getOperateResources(checkoutMap, resources2names = CheckoutAction.getResources2Names(checkoutMap), shell, ResourcesPlugin.getWorkspace().getRoot().getLocation().toString(), true)).size() > 0) {
            IRepositoryResource[] checkoutSet = operateResources.toArray(new IRepositoryResource[operateResources.size()]);
            HashMap operateMap = new HashMap();
            int i = 0;
            while (i < checkoutSet.length) {
                operateMap.put(resources2names.get(checkoutSet[i]), checkoutSet[i]);
                ++i;
            }
            return new CheckoutOperation(operateMap, respectHierarchy, location, recureDepth, ignoreExternals);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public static HashMap getResources2Names(HashMap names2resources) {
        HashMap resources2Names = new HashMap();
        for (String name : names2resources.keySet()) {
            resources2Names.put(names2resources.get(name), name);
        }
        return resources2Names;
    }

    public static class NameSet {
        public final boolean caseInsensitiveOS;
        public final HashMap<String, String> existing = new HashMap();

        public NameSet() {
            this.caseInsensitiveOS = FileUtility.isCaseInsensitiveOS();
        }
    }
}

