/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.javahl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.CommitItem;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.ISVNRepos;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.SVNRepos;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.ChangelistCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Status;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNCallListener;
import org.eclipse.team.svn.core.connector.ISVNChangeListCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.ISVNDiffStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNMergeStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNPatchCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConnectorAuthenticationException;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.utility.Notify2Composite;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.connector.javahl.ConversionUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHLConnector
implements ISVNConnector {
    protected static ProgressMonitorThread monitorWrapperThread;
    protected ISVNRepos svnAdmin;
    protected ISVNClient client;
    protected ISVNCredentialsPrompt prompt;
    protected Notify2Composite composite;
    protected ISVNNotificationCallback installedNotify2;
    protected boolean commitMissingFiles;
    protected String sslCertificate;
    protected String sslPassphrase;
    protected ArrayList<ISVNCallListener> callListeners = new ArrayList();

    public JavaHLConnector() {
        this.client = new SVNClient();
        this.composite = new Notify2Composite();
        this.client.notification2(ConversionUtility.convert((ISVNNotificationCallback)this.composite));
        this.svnAdmin = new SVNRepos();
    }

    public void addCallListener(ISVNCallListener listener) {
        this.callListeners.add(listener);
    }

    public void removeCallListener(ISVNCallListener listener) {
        this.callListeners.remove(listener);
    }

    public String getConfigDirectory() throws SVNConnectorException {
        this.fireAsked("getConfigDirectory", null);
        try {
            String retVal = this.client.getConfigDirectory();
            this.fireSucceeded("getConfigDirectory", null, retVal);
            return retVal;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getConfigDirectory", null);
            return null;
        }
    }

    public void setConfigDirectory(String configDir) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("configDir", configDir);
        this.fireAsked("setConfigDirectory", parameters);
        configDir = (String)parameters.get("configDir");
        try {
            this.client.setConfigDirectory(configDir);
            this.fireSucceeded("getConfigDirectory", parameters, null);
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "setConfigDirectory", parameters);
        }
    }

    public void setUsername(String username) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        this.fireAsked("setUsername", parameters);
        username = (String)parameters.get("username");
        this.client.username(username == null ? "" : username);
        this.fireSucceeded("setUsername", parameters, null);
    }

    public void setPassword(String password) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("password", password);
        this.fireAsked("setUsername", parameters);
        password = (String)parameters.get("password");
        this.client.password(password == null ? "" : password);
        this.fireSucceeded("setUsername", parameters, null);
    }

    public boolean isCredentialsCacheEnabled() {
        this.fireAsked("isCredentialsCacheEnabled", null);
        this.fireSucceeded("isCredentialsCacheEnabled", null, Boolean.TRUE);
        return true;
    }

    public void setCredentialsCacheEnabled(boolean cacheCredentials) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("cacheCredentials", cacheCredentials);
        this.fireAsked("setCredentialsCacheEnabled", parameters);
        cacheCredentials = (Boolean)parameters.get("cacheCredentials");
        this.fireFailed("setCredentialsCacheEnabled", parameters, null);
    }

    public void setPrompt(ISVNCredentialsPrompt prompt) {
        RepositoryInfoPrompt repositoryInfoPrompt;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("prompt", prompt);
        this.fireAsked("setPrompt", parameters);
        prompt = (ISVNCredentialsPrompt)parameters.get("prompt");
        if (prompt == null) {
            repositoryInfoPrompt = null;
        } else {
            this.prompt = prompt;
            RepositoryInfoPrompt repositoryInfoPrompt2 = new RepositoryInfoPrompt(this.prompt);
            repositoryInfoPrompt = repositoryInfoPrompt2;
        }
        this.client.setPrompt(repositoryInfoPrompt);
        this.fireSucceeded("setPrompt", parameters, null);
    }

    public ISVNCredentialsPrompt getPrompt() {
        this.fireAsked("getPrompt", null);
        this.fireSucceeded("getPrompt", null, this.prompt);
        return this.prompt;
    }

    public void setProxy(String host, int port, String username, String password) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("host", host);
        parameters.put("port", port);
        parameters.put("username", username);
        parameters.put("password", password);
        this.fireAsked("setProxy", parameters);
        host = (String)parameters.get("host");
        port = (Integer)parameters.get("port");
        username = (String)parameters.get("username");
        password = (String)parameters.get("password");
        this.fireFailed("setProxy", parameters, null);
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("certPath", certPath);
        parameters.put("passphrase", passphrase);
        this.fireAsked("setClientSSLCertificate", parameters);
        certPath = (String)parameters.get("certPath");
        passphrase = (String)parameters.get("passphrase");
        this.sslCertificate = certPath == null || certPath.trim().length() == 0 ? null : certPath;
        this.sslPassphrase = passphrase;
        this.fireSucceeded("setClientSSLCertificate", parameters, null);
    }

    public boolean isSSLCertificateCacheEnabled() {
        this.fireAsked("isSSLCertificateCacheEnabled", null);
        this.fireSucceeded("isSSLCertificateCacheEnabled", null, Boolean.TRUE);
        return true;
    }

    public void setSSLCertificateCacheEnabled(boolean enabled) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("enabled", enabled);
        this.fireAsked("setSSLCertificateCacheEnabled", parameters);
        enabled = (Boolean)parameters.get("enabled");
        this.fireFailed("setSSLCertificateCacheEnabled", parameters, null);
    }

    public void setSSHCredentials(String username, String privateKeyPath, String passphrase, int port) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("privateKeyPath", privateKeyPath);
        parameters.put("passphrase", passphrase);
        parameters.put("port", port);
        this.fireAsked("setSSHCredentials", parameters);
        username = (String)parameters.get("username");
        privateKeyPath = (String)parameters.get("privateKeyPath");
        passphrase = (String)parameters.get("passphrase");
        port = (Integer)parameters.get("port");
        this.fireFailed("setSSHCredentials", parameters, null);
    }

    public void setSSHCredentials(String username, String password, int port) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("password", password);
        parameters.put("port", port);
        this.fireAsked("setSSHCredentialsPassword", parameters);
        username = (String)parameters.get("username");
        password = (String)parameters.get("password");
        port = (Integer)parameters.get("port");
        this.fireFailed("setSSHCredentialsPassword", parameters, null);
    }

    public void setCommitMissingFiles(boolean commitMissingFiles) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("commitMissingFiles", commitMissingFiles);
        this.fireAsked("setCommitMissingFiles", parameters);
        this.commitMissingFiles = commitMissingFiles = ((Boolean)parameters.get("commitMissingFiles")).booleanValue();
        this.fireSucceeded("setCommitMissingFiles", parameters, null);
    }

    public boolean isCommitMissingFiles() {
        this.fireAsked("isCommitMissingFiles", null);
        this.fireSucceeded("isCommitMissingFiles", null, this.commitMissingFiles);
        return this.commitMissingFiles;
    }

    public void setNotificationCallback(ISVNNotificationCallback notify) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("notify", notify);
        this.fireAsked("setNotificationCallback", parameters);
        notify = (ISVNNotificationCallback)parameters.get("notify");
        if (this.installedNotify2 != null) {
            this.composite.remove(this.installedNotify2);
        }
        this.installedNotify2 = notify;
        if (this.installedNotify2 != null) {
            this.composite.add(this.installedNotify2);
        }
        this.fireSucceeded("setNotificationCallback", parameters, null);
    }

    public ISVNNotificationCallback getNotificationCallback() {
        this.fireAsked("getNotificationCallback", null);
        this.fireSucceeded("getNotificationCallback", null, this.installedNotify2);
        return this.installedNotify2;
    }

    public long checkout(SVNEntryRevisionReference fromReference, String destPath, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("fromReference", fromReference);
        parameters.put("destPath", destPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("checkout", parameters);
        fromReference = (SVNEntryRevisionReference)parameters.get("fromReference");
        destPath = (String)parameters.get("destPath");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.checkout(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), ConversionUtility.convertDepth(depth), (options & 1L) != 0L, (options & 2L) != 0L);
            this.fireSucceeded("checkout", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "checkout", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void lock(String[] path, String comment, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("comment", comment);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("lock", parameters);
        path = (String[])parameters.get("path");
        comment = (String)parameters.get("comment");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.lock(new HashSet<String>(Arrays.asList(path)), comment, (options & 4L) != 0L);
                this.fireSucceeded("lock", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "lock", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void unlock(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("unlock", parameters);
        path = (String[])parameters.get("path");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.unlock(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L);
                this.fireSucceeded("unlock", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "unlock", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void add(String path, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("add", parameters);
        path = (String)parameters.get("path");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.add(path, ConversionUtility.convertDepth(depth), (options & 4L) != 0L, (options & 0x100L) != 0L, (options & 8L) != 0L);
                this.fireSucceeded("add", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "add", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long[] commit(String[] path, String message, String[] changelistNames, int depth, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("changelistNames", changelistNames);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("commit", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        changelistNames = (String[])parameters.get("changelistNames");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        boolean noUnlock = (options & 0x10L) != 0L;
        boolean keepChangelist = (options & 0x20L) != 0L;
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            if (this.commitMissingFiles) {
                int i = 0;
                while (i < path.length && !monitor.isActivityCancelled()) {
                    if (!new File(path[i]).exists()) {
                        this.client.remove(new HashSet<String>(Arrays.asList(path[i])), true, false, null, null, null);
                    }
                    ++i;
                }
            }
            if (depth != 3) {
                HashSet<String> fullSet = new HashSet<String>(Arrays.asList(path));
                HashSet<String> deleted = new HashSet<String>();
                Arrays.sort(path);
                int i = 0;
                while (i < path.length && !monitor.isActivityCancelled()) {
                    File toCheck = new File(path[i]);
                    if (toCheck.isDirectory()) {
                        final Status[] st = new Status[1];
                        this.client.status(path[i], ConversionUtility.convertDepth(0), false, false, false, false, null, new StatusCallback(){

                            public void doStatus(String path, Status status) {
                                st[0] = status;
                            }
                        });
                        if (st[0] != null && st[0].getTextStatus() == Status.Kind.deleted) {
                            deleted.add(path[i]);
                            String root = path[i];
                            while (i < path.length && !monitor.isActivityCancelled()) {
                                if (path[i].startsWith(root) && (path[i].length() == root.length() || path[i].charAt(root.length()) == '\\' || path[i].charAt(root.length()) == '/')) {
                                    fullSet.remove(path[i]);
                                    ++i;
                                    continue;
                                }
                                --i;
                                break;
                            }
                        }
                    }
                    ++i;
                }
                if (deleted.size() > 0) {
                    if (fullSet.size() == 0) {
                        path = deleted.toArray(new String[deleted.size()]);
                        depth = 3;
                    } else {
                        path = fullSet.toArray(new String[fullSet.size()]);
                        String[] deletedPath = deleted.toArray(new String[deleted.size()]);
                        this.composite.add((ISVNNotificationCallback)wrapper);
                        wrapper.start();
                        CommitInfo info1 = new CommitInfo();
                        CommitInfo info2 = new CommitInfo();
                        this.client.commit(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convertDepth(depth), noUnlock, keepChangelist, changelistNames == null ? null : Arrays.asList(changelistNames), ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), info1);
                        this.client.commit(new HashSet<String>(Arrays.asList(deletedPath)), ConversionUtility.convertDepth(3), noUnlock, keepChangelist, changelistNames == null ? null : Arrays.asList(changelistNames), ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), info2);
                        long[] lArray = new long[]{info1.info != null ? info1.info.getRevision() : 0L, info2.info != null ? info1.info.getRevision() : 0L};
                        return lArray;
                    }
                }
            }
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            CommitInfo info1 = new CommitInfo();
            this.client.commit(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convertDepth(depth), noUnlock, keepChangelist, changelistNames == null ? null : Arrays.asList(changelistNames), ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), info1);
            long[] retVal = new long[]{info1.info != null ? info1.info.getRevision() : 0L};
            this.fireSucceeded("commit", parameters, retVal);
            long[] lArray = retVal;
            return lArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "commit", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public long[] update(String[] path, SVNRevision revision, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("revision", revision);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("update", parameters);
        path = (String[])parameters.get("path");
        revision = (SVNRevision)parameters.get("revision");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long[] retVal = this.client.update(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convert(revision), ConversionUtility.convertDepth(depth), (options & 0x4000L) != 0L, (options & 8L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L);
            this.fireSucceeded("update", parameters, retVal);
            long[] lArray = retVal;
            return lArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "update", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public long doSwitch(String path, SVNEntryRevisionReference toReference, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("toReference", toReference);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("doSwitch", parameters);
        path = (String)parameters.get("path");
        toReference = (SVNEntryRevisionReference)parameters.get("toReference");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.doSwitch(path, toReference.path, ConversionUtility.convert(toReference.revision), ConversionUtility.convert(toReference.pegRevision), ConversionUtility.convertDepth(depth), (options & 0x4000L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L, (options & 0x200L) != 0L);
            this.fireSucceeded("doSwitch", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "doSwitch", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void revert(String path, int depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("changelistNames", changelistNames);
        parameters.put("monitor", monitor);
        this.fireAsked("revert", parameters);
        path = (String)parameters.get("path");
        depth = (Integer)parameters.get("depth");
        changelistNames = (String[])parameters.get("changelistNames");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.revert(path, ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames));
                this.fireSucceeded("revert", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "revert", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void status(String path, int depth, long options, String[] changelistNames, ISVNEntryStatusCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changelistNames", changelistNames);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("status", parameters);
        path = (String)parameters.get("path");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        changelistNames = (String[])parameters.get("changelistNames");
        callback = (ISVNEntryStatusCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.status(path, ConversionUtility.convertDepth(depth), (options & 0x40L) != 0L, (options & 0x80L) != 0L, (options & 0x100L) != 0L, (options & 1L) != 0L, changelistNames == null ? null : Arrays.asList(changelistNames), ConversionUtility.convert(callback));
                this.fireSucceeded("status", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "status", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void relocate(String from, String to, String path, int depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("from", from);
        parameters.put("to", to);
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("monitor", monitor);
        this.fireAsked("relocate", parameters);
        from = (String)parameters.get("from");
        to = (String)parameters.get("to");
        path = (String)parameters.get("path");
        depth = (Integer)parameters.get("depth");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.relocate(from, to, path, depth == 3);
                this.fireSucceeded("relocate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "relocate", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void cleanup(String path, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("monitor", monitor);
        this.fireAsked("cleanup", parameters);
        path = (String)parameters.get("path");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.cleanup(path);
                this.fireSucceeded("cleanup", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "cleanup", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String localPath, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("localPath", localPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("merge2URL", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        localPath = (String)parameters.get("localPath");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.merge(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), localPath, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                this.fireSucceeded("merge2URL", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "merge2URL", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String localPath, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisions", revisions);
        parameters.put("localPath", localPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("merge", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisions = (SVNRevisionRange[])parameters.get("revisions");
        localPath = (String)parameters.get("localPath");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.merge(reference.path, ConversionUtility.convert(reference.pegRevision), Arrays.asList(ConversionUtility.convert(revisions)), localPath, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                this.fireSucceeded("merge", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "merge", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mergeReintegrate(SVNEntryReference reference, String localPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("localPath", localPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("mergeReintegrate", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        localPath = (String)parameters.get("localPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mergeReintegrate(reference.path, ConversionUtility.convert(reference.pegRevision), localPath, (options & 0x400L) != 0L);
                this.fireSucceeded("mergeReintegrate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mergeReintegrate", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNMergeInfo getMergeInfo(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("getMergeInfo", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNMergeInfo retVal = ConversionUtility.convert(this.client.getMergeinfo(reference.path, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("getMergeInfo", parameters, retVal);
            SVNMergeInfo sVNMergeInfo = retVal;
            return sVNMergeInfo;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getMergeInfo", parameters);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex, "getMergeInfo", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void getMergeInfoLog(int logKind, SVNEntryReference reference, SVNEntryReference mergeSourceReference, String[] revProps, int depth, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("logKind", logKind);
        parameters.put("reference", reference);
        parameters.put("mergeSourceReference", mergeSourceReference);
        parameters.put("revProps", revProps);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("getMergeInfoLog", parameters);
        logKind = (Integer)parameters.get("logKind");
        reference = (SVNEntryReference)parameters.get("reference");
        mergeSourceReference = (SVNEntryReference)parameters.get("mergeSourceReference");
        revProps = (String[])parameters.get("revProps");
        options = (Long)parameters.get("options");
        cb = (ISVNLogEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getMergeinfoLog(ConversionUtility.convertLogKind(logKind), reference.path, ConversionUtility.convert(reference.pegRevision), mergeSourceReference.path, ConversionUtility.convert(mergeSourceReference.pegRevision), (options & 0x40000L) != 0L, ConversionUtility.convertDepth(depth), new HashSet<String>(Arrays.asList(revProps)), ConversionUtility.convert(cb));
                this.fireSucceeded("getMergeInfoLog", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "getMergeInfoLog", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public String[] suggestMergeSources(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("suggestMergeSources", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            Set<String> tmp = this.client.suggestMergeSources(reference.path, ConversionUtility.convert(reference.pegRevision));
            String[] retVal = tmp == null ? null : tmp.toArray(new String[tmp.size()]);
            this.fireSucceeded("suggestMergeSources", parameters, retVal);
            String[] stringArray = retVal;
            return stringArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "suggestMergeSources", parameters);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex, "suggestMergeSources", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void resolve(String path, int conflictResult, int depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("conflictResult", conflictResult);
        parameters.put("depth", depth);
        parameters.put("monitor", monitor);
        this.fireAsked("resolve", parameters);
        path = (String)parameters.get("path");
        conflictResult = (Integer)parameters.get("conflictResult");
        depth = (Integer)parameters.get("depth");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.resolve(path, ConversionUtility.convertDepth(depth), ConversionUtility.convertConflictChoice(conflictResult));
                this.fireSucceeded("resolve", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "resolve", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
            catch (SubversionException ex) {
                this.handleSubversionException(ex, "resolve", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setConflictResolver(ISVNConflictResolutionCallback listener) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("listener", listener);
        this.fireAsked("setConflictResolver", parameters);
        listener = (ISVNConflictResolutionCallback)parameters.get("listener");
        this.client.setConflictResolver(ConversionUtility.convert(listener));
        this.fireSucceeded("setConflictResolver", parameters, null);
    }

    public void addToChangeList(String[] paths, String changelist, int depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("paths", paths);
        parameters.put("changelist", changelist);
        parameters.put("depth", depth);
        parameters.put("changelistNames", changelistNames);
        parameters.put("monitor", monitor);
        this.fireAsked("addToChangeList", parameters);
        paths = (String[])parameters.get("paths");
        changelist = (String)parameters.get("changelist");
        depth = (Integer)parameters.get("depth");
        changelistNames = (String[])parameters.get("changelistNames");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.addToChangelist(new HashSet<String>(Arrays.asList(paths)), changelist, ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames));
                this.fireSucceeded("addToChangeList", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "addToChangeList", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeFromChangeLists(String[] paths, int depth, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("paths", paths);
        parameters.put("depth", depth);
        parameters.put("changelistNames", changelistNames);
        parameters.put("monitor", monitor);
        this.fireAsked("removeFromChangeLists", parameters);
        paths = (String[])parameters.get("paths");
        depth = (Integer)parameters.get("depth");
        changelistNames = (String[])parameters.get("changelistNames");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.removeFromChangelists(new HashSet<String>(Arrays.asList(paths)), ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames));
                this.fireSucceeded("removeFromChangeLists", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeFromChangeLists", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void dumpChangeLists(String[] changeLists, String rootPath, int depth, ISVNChangeListCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("changeLists", changeLists);
        parameters.put("rootPath", rootPath);
        parameters.put("depth", depth);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("dumpChangeLists", parameters);
        changeLists = (String[])parameters.get("changeLists");
        rootPath = (String)parameters.get("rootPath");
        depth = (Integer)parameters.get("depth");
        final ISVNChangeListCallback cb1 = (ISVNChangeListCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getChangelists(rootPath, Arrays.asList(changeLists), ConversionUtility.convertDepth(depth), new ChangelistCallback(){

                    public void doChangelist(String path, String changelist) {
                        cb1.next(path, changelist);
                    }
                });
                this.fireSucceeded("dumpChangeLists", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "dumpChangeLists", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge(reference, null, revisions, mergePath, mergeStatus, options, monitor);
    }

    public void merge(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge((SVNEntryReference)reference1, reference2, null, mergePath, mergeStatus, options, monitor);
    }

    public void mergeStatus(SVNEntryReference reference, SVNRevisionRange[] revisions, String path, int depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, revisions, path, depth, options, cb, monitor);
    }

    public void mergeStatus(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String path, int depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus((SVNEntryReference)reference1, reference2, null, path, depth, options, cb, monitor);
    }

    public void merge(SVNEntryReference reference, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge(reference, null, null, mergePath, mergeStatus, options, monitor);
    }

    public void mergeStatus(SVNEntryReference reference, String mergePath, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, null, mergePath, 3, options, cb, monitor);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void merge(SVNEntryReference reference1, SVNEntryRevisionReference reference2, SVNRevisionRange[] revisions, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                i = 0;
                if (true) ** GOTO lbl54
                do {
                    localFile = new File(mergeStatus[i].path);
                    if (mergeStatus[i].textStatus == 4) {
                        this.client.remove(new HashSet<String>(Arrays.asList(new String[]{mergeStatus[i].path})), (options & 4L) != 0L, false, null, null, null);
                    } else if (mergeStatus[i].textStatus == 3 || mergeStatus[i].textStatus == 2 && ((options & 4L) != 0L || !localFile.exists()) || mergeStatus[i].textStatus == 9 && (options & 4L) != 0L) {
                        if (localFile.exists()) {
                            localFile.delete();
                        }
                        parent = localFile.getParentFile();
                        while (!parent.exists() && parent.getParentFile() != null) {
                            tmp = parent.getParentFile();
                            if (tmp.exists()) {
                                localFile.getParentFile().mkdirs();
                                this.client.add(parent.getAbsolutePath(), ConversionUtility.convertDepth(3), true, false, false);
                                break;
                            }
                            parent = tmp;
                        }
                        src = new CopySource(mergeStatus[i].endUrl, ConversionUtility.convert(reference2 == null ? (revisions != null ? revisions[revisions.length - 1].to : reference1.pegRevision) : reference2.revision), ConversionUtility.convert(reference2 == null ? reference1.pegRevision : reference2.pegRevision));
                        tmp = File.createTempFile("mergeCopyTarget", ".tmp", localFile.getParentFile());
                        tmp.delete();
                        this.client.copy(Arrays.asList(new CopySource[]{src}), tmp.getAbsolutePath(), true, false, false, null, null, null);
                        data = new Map[1];
                        this.client.properties(tmp.getAbsolutePath(), null, null, ConversionUtility.convertDepth(0), null, new ProplistCallback(){

                            @Override
                            public void singlePath(String path, Map<String, byte[]> properties) {
                                data[0] = properties;
                            }
                        });
                        this.client.revert(tmp.getAbsolutePath(), ConversionUtility.convertDepth(3), null);
                        tmp.renameTo(new File(mergeStatus[i].path));
                        try {
                            this.client.add(mergeStatus[i].path, ConversionUtility.convertDepth(3), true, false, false);
                        }
                        catch (ClientException v0) {}
                        if (data[0] != null) {
                            for (Map.Entry<K, V> entry : data[0].entrySet()) {
                                this.client.propertySetLocal(new HashSet<String>(Arrays.asList(new String[]{mergeStatus[i].path})), (String)entry.getKey(), (byte[])entry.getValue(), ConversionUtility.convertDepth(0), null, false);
                            }
                        }
                    } else if (reference2 != null) {
                        this.client.merge(mergeStatus[i].startUrl, ConversionUtility.convert(((SVNEntryRevisionReference)reference1).revision), mergeStatus[i].endUrl, ConversionUtility.convert(reference2.revision), mergeStatus[i].path, (options & 4L) != 0L, ConversionUtility.convertDepth(1), (options & 512L) != 0L, false, (options & 2048L) != 0L);
                    } else if (revisions != null) {
                        this.client.merge(mergeStatus[i].endUrl, ConversionUtility.convert(reference1.pegRevision), Arrays.asList(ConversionUtility.convert(revisions)), mergeStatus[i].path, (options & 4L) != 0L, ConversionUtility.convertDepth(1), (options & 512L) != 0L, false, (options & 2048L) != 0L);
                    } else {
                        this.client.mergeReintegrate(mergeStatus[i].endUrl, ConversionUtility.convert(reference1.pegRevision), mergeStatus[i].path, false);
                    }
                    ++i;
lbl54:
                    // 2 sources

                    if (i >= mergeStatus.length) return;
                } while (!monitor.isActivityCancelled());
                return;
            }
            catch (ClientException ex) {
                this.handleClientException(ex, null, null);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
                return;
            }
            catch (IOException e) {
                throw new SVNConnectorException((Throwable)e);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeStatus(SVNEntryReference reference1, SVNEntryRevisionReference reference2, SVNRevisionRange[] revisions, String path, int depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList tmp = new ArrayList();
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor){

            public void notify(SVNNotification arg0) {
                super.notify(arg0);
                tmp.add(arg0);
            }
        };
        try {
            try {
                String endUrlPref;
                SVNLogEntry[] entries;
                SVNRevision to;
                SVNRevision from;
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                if (reference2 != null) {
                    this.client.merge(reference1.path, ConversionUtility.convert(((SVNEntryRevisionReference)reference1).revision), reference2.path, ConversionUtility.convert(reference2.revision), path, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                } else if (revisions != null) {
                    this.client.merge(reference1.path, ConversionUtility.convert(reference1.pegRevision), Arrays.asList(ConversionUtility.convert(revisions)), path, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                } else {
                    this.client.mergeReintegrate(reference1.path, ConversionUtility.convert(reference1.pegRevision), path, (options & 0x400L) != 0L);
                }
                Object object = reference2 == null ? (revisions != null ? revisions[0].from : SVNRevision.fromNumber((long)1L)) : (from = ((SVNEntryRevisionReference)reference1).revision);
                SVNRevision sVNRevision = reference2 == null ? (revisions != null ? revisions[revisions.length - 1].to : reference1.pegRevision) : (to = reference2.revision);
                if (from.getKind() != 1) {
                    entries = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)reference1, (SVNRevision)from, (SVNRevision)SVNRevision.fromNumber((long)1L), (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
                    from = SVNRevision.fromNumber((long)entries[0].revision);
                }
                if (to.getKind() != 1) {
                    entries = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : reference2), (SVNRevision)to, (SVNRevision)SVNRevision.fromNumber((long)1L), (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
                    to = SVNRevision.fromNumber((long)entries[0].revision);
                }
                if (reference2 != null && from.equals((Object)to)) {
                    from = SVNRevision.fromNumber((long)(((SVNRevision.Number)to).getNumber() - 1L));
                }
                boolean reversed = reference2 == null ? SVNUtility.compareRevisions((SVNRevision)from, (SVNRevision)to, (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, from), (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, to), (ISVNConnector)this) == 1 : SVNUtility.compareRevisions((SVNRevision)from, (SVNRevision)to, (SVNEntryRevisionReference)((SVNEntryRevisionReference)reference1), (SVNEntryRevisionReference)reference2, (ISVNConnector)this) == 1;
                int i = 0;
                String startUrlPref = reference1.path;
                String string = endUrlPref = reference2 == null ? reference1.path : reference2.path;
                SVNLogEntry[] allMsgs = reversed ? SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : this.getValidReference((SVNEntryReference)reference2, from, monitor)), (SVNRevision)from, (SVNRevision)to, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor) : SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : reference2), (SVNRevision)to, (SVNRevision)from, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor);
                long minRev = ((SVNRevision.Number)(reversed ? to : from)).getNumber();
                Iterator it = tmp.iterator();
                while (it.hasNext()) {
                    SVNEntryInfo[] infos;
                    if (monitor.isActivityCancelled()) {
                        return;
                    }
                    SVNNotification state = (SVNNotification)it.next();
                    int kind = state.kind;
                    String tPath = state.path.substring(path.length());
                    String startUrl = SVNUtility.normalizeURL((String)(String.valueOf(startUrlPref) + tPath));
                    String endUrl = SVNUtility.normalizeURL((String)(String.valueOf(endUrlPref) + tPath));
                    boolean skipped = state.action == 7;
                    int cState = 0;
                    int pState = 0;
                    boolean hasTreeConflict = state.action == 38;
                    SVNConflictDescriptor treeConflict = null;
                    if (hasTreeConflict && (infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(state.path), (int)0, (ISVNProgressMonitor)monitor)).length > 0 && infos[0].treeConflicts != null && infos[0].treeConflicts.length > 0) {
                        treeConflict = infos[0].treeConflicts[0];
                        kind = infos[0].kind;
                        if (treeConflict.conflictKind == 0) {
                            cState = 9;
                        } else {
                            pState = 9;
                        }
                    }
                    if (state.action == 9) {
                        cState = 3;
                    } else if (state.action == 8) {
                        cState = 4;
                    } else if (state.action == 10) {
                        int n = state.propState == 5 ? 2 : (pState = state.propState == 7 ? 9 : 0);
                        cState = state.contentState == 5 || state.contentState == 6 ? 2 : (state.contentState == 7 ? 9 : 0);
                    } else if (state.action == 7) {
                        if (state.contentState == 3) {
                            try {
                                SVNRevision pegRev = reference1.pegRevision;
                                if (reference2 != null) {
                                    pegRev = reference2.pegRevision;
                                }
                                SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(endUrl, pegRev, to), (int)0, (ISVNProgressMonitor)monitor);
                                pState = 2;
                                cState = 2;
                            }
                            catch (Exception exception) {
                                cState = 4;
                            }
                        } else if (state.contentState == 4) {
                            cState = 3;
                        }
                    }
                    if (cState != 0 || pState != 0 || hasTreeConflict) {
                        int idx;
                        long startRevision = -1L;
                        long endRevision = -1L;
                        long date = 0L;
                        String author = null;
                        String message = null;
                        monitor.progress(i, tmp.size(), JavaHLConnector.makeItemState(state));
                        if (cState == 3 && !reversed || cState == 4 && reversed || hasTreeConflict && (treeConflict.action == 1 && !reversed || treeConflict.action == 2 && reversed)) {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            }
                        } else if (cState == 2 || cState == 9 || pState == 2 || pState == 9 || hasTreeConflict && treeConflict.action == 0) {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            }
                            startRevision = (idx = this.getLogIndex(allMsgs, startUrl, true)) != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
                        } else {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            } else {
                                idx = this.getLogIndex(allMsgs, startUrl, false);
                                if (idx != -1) {
                                    endUrl = startUrl;
                                    endRevision = allMsgs[idx].revision;
                                    date = allMsgs[idx].date;
                                    author = allMsgs[idx].author;
                                    message = allMsgs[idx].message;
                                }
                            }
                            idx = this.getLogIndex(allMsgs, startUrl, true);
                            long l = startRevision = idx != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
                        }
                        if (reversed) {
                            startRevision = endRevision;
                            endRevision = allMsgs[allMsgs.length - 1].revision;
                            date = allMsgs[allMsgs.length - 1].date;
                            author = allMsgs[allMsgs.length - 1].author;
                            message = allMsgs[allMsgs.length - 1].message;
                        }
                        cb.next(new SVNMergeStatus(startUrl, endUrl, state.path, kind, cState, pState, startRevision, endRevision, date, author, message, skipped, hasTreeConflict, treeConflict));
                    }
                    ++i;
                }
                return;
            }
            catch (ClientException ex) {
                this.handleClientException(ex, null, null);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
                return;
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    protected SVNEntryReference getValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) throws SVNConnectorException {
        if (referenceToExisting.pegRevision.getKind() != 7 && referenceToExisting.pegRevision.getKind() != 1) {
            throw new RuntimeException("Unexpected revision kind. Kind: " + referenceToExisting.pegRevision.getKind());
        }
        if (lastRevision.getKind() != 1) {
            throw new RuntimeException("Unexpected last revision kind. Kind: " + lastRevision.getKind());
        }
        if (referenceToExisting.pegRevision.getKind() == 7) {
            return referenceToExisting;
        }
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        while (end > start) {
            referenceToExisting = this.getLastValidReference(referenceToExisting, lastRevision, monitor);
            if (referenceToExisting.pegRevision.equals((Object)lastRevision)) continue;
            start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber() + 1L;
            SVNEntryReference tRef = new SVNEntryReference(referenceToExisting.path, (SVNRevision)SVNRevision.fromNumber((long)start));
            while (!this.exists(tRef, monitor)) {
                tRef = new SVNEntryReference(tRef.path.substring(0, tRef.path.lastIndexOf("/")), tRef.pegRevision);
            }
            SVNLogEntry[] log = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)tRef, (SVNRevision)tRef.pegRevision, (SVNRevision)referenceToExisting.pegRevision, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor);
            SVNLogPath[] paths = log[0].changedPaths;
            boolean renamed = false;
            if (paths != null) {
                String decodedUrl = SVNUtility.decodeURL((String)referenceToExisting.path);
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].copiedFromPath)) != -1 && (decodedUrl.charAt(idx + paths[k].copiedFromPath.length()) == '/' || decodedUrl.endsWith(paths[k].copiedFromPath))) {
                        decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[k].path + decodedUrl.substring(idx + paths[k].copiedFromPath.length());
                        tRef = new SVNEntryReference(SVNUtility.encodeURL((String)decodedUrl), tRef.pegRevision);
                        renamed = true;
                        break;
                    }
                    ++k;
                }
            }
            referenceToExisting = tRef;
            if (renamed) continue;
            return referenceToExisting;
        }
        return referenceToExisting;
    }

    protected SVNEntryReference getLastValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) {
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        do {
            long middle;
            SVNEntryReference tRef;
            if (this.exists(tRef = new SVNEntryReference(referenceToExisting.path, (SVNRevision)SVNRevision.fromNumber((long)(middle = end - (end - start) / 2L))), monitor)) {
                start = middle;
                referenceToExisting = tRef;
                continue;
            }
            if (end - start == 1L) break;
            end = middle;
        } while (end > start);
        return referenceToExisting;
    }

    protected boolean exists(SVNEntryReference reference, ISVNProgressMonitor monitor) {
        try {
            SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)reference, (SVNRevision)reference.pegRevision, (SVNRevision)reference.pegRevision, (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
            return true;
        }
        catch (SVNConnectorException sVNConnectorException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLogIndex(SVNLogEntry[] msgs, String url, boolean last) {
        String decodedUrl = SVNUtility.decodeURL((String)url);
        int retVal = -1;
        int j = 0;
        while (j < msgs.length) {
            SVNLogPath[] paths = msgs[j].changedPaths;
            if (paths != null) {
                int maxPathIdx = -1;
                int maxPathLen = 0;
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k] != null && decodedUrl.endsWith(paths[k].path)) {
                        if (!last) return j;
                        if (paths[k].copiedFromPath != null) {
                            maxPathIdx = k;
                            maxPathLen = paths[k].path.length();
                        }
                        retVal = paths[k].action == 'A' ? j : -1;
                    } else if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].path)) != -1 && (decodedUrl.charAt(idx + paths[k].path.length()) == '/' || decodedUrl.endsWith(paths[k].path)) && paths[k].path.length() > maxPathLen) {
                        maxPathIdx = k;
                        maxPathLen = paths[k].path.length();
                    }
                    ++k;
                }
                if (maxPathIdx != -1) {
                    int idx = decodedUrl.indexOf(paths[maxPathIdx].path);
                    decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[maxPathIdx].copiedFromPath + decodedUrl.substring(idx + paths[maxPathIdx].path.length());
                }
            }
            ++j;
        }
        return retVal;
    }

    public void doImport(String path, String url, String message, int depth, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("url", url);
        parameters.put("message", message);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("doImport", parameters);
        path = (String)parameters.get("path");
        url = (String)parameters.get("url");
        message = (String)parameters.get("message");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.doImport(path, url, ConversionUtility.convertDepth(depth), (options & 0x100L) != 0L, (options & 0x1000L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), null);
                this.fireSucceeded("doImport", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "doImport", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long doExport(SVNEntryRevisionReference fromReference, String destPath, String nativeEOL, int depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("fromReference", fromReference);
        parameters.put("destPath", destPath);
        parameters.put("nativeEOL", nativeEOL);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("doExport", parameters);
        fromReference = (SVNEntryRevisionReference)parameters.get("fromReference");
        destPath = (String)parameters.get("destPath");
        nativeEOL = (String)parameters.get("nativeEOL");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.doExport(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), (options & 4L) != 0L, (options & 1L) != 0L, ConversionUtility.convertDepth(depth), nativeEOL);
            this.fireSucceeded("doExport", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "doExport", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void diff(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, String outFileName, int depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("outFileName", outFileName);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changelistNames", changelistNames);
        parameters.put("monitor", monitor);
        this.fireAsked("diff2URL", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        relativeToDir = (String)parameters.get("relativeToDir");
        outFileName = (String)parameters.get("outFileName");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        changelistNames = (String[])parameters.get("changelistNames");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), relativeToDir, outFileName, ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L);
                this.fireSucceeded("diff2URL", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diff2URL", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diff(SVNEntryReference reference, SVNRevision revision1, SVNRevision revision2, String relativeToDir, String outFileName, int depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revision1", revision1);
        parameters.put("revision2", revision2);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("outFileName", outFileName);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changelistNames", changelistNames);
        parameters.put("monitor", monitor);
        this.fireAsked("diff", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revision1 = (SVNRevision)parameters.get("revision1");
        revision2 = (SVNRevision)parameters.get("revision2");
        relativeToDir = (String)parameters.get("relativeToDir");
        outFileName = (String)parameters.get("outFileName");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        changelistNames = (String[])parameters.get("changelistNames");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), relativeToDir, outFileName, ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L);
                this.fireSucceeded("diff", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diff", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatus(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, int depth, long options, String[] changelistNames, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changelistNames", changelistNames);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("diffStatus2URL", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        changelistNames = (String[])parameters.get("changelistNames");
        cb = (ISVNDiffStatusCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (int)0, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == 1;
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                DiffCallback callback = new DiffCallback(reference1.path, reference2.path, isFile, cb);
                this.client.diffSummarize(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), (options & 0x200L) != 0L, (DiffSummaryCallback)callback);
                callback.doLastDiff();
                this.fireSucceeded("diffStatus2URL", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffStatus2URL", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatus(SVNEntryReference reference, SVNRevision revision1, SVNRevision revision2, int depth, long options, String[] changelistNames, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revision1", revision1);
        parameters.put("revision2", revision2);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changelistNames", changelistNames);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("diffStatus", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revision1 = (SVNRevision)parameters.get("revision1");
        revision2 = (SVNRevision)parameters.get("revision2");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        changelistNames = (String[])parameters.get("changelistNames");
        cb = (ISVNDiffStatusCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference, revision1), (int)0, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == 1;
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                DiffCallback callback = new DiffCallback(reference.path, reference.path, isFile, cb);
                this.client.diffSummarize(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revision1), ConversionUtility.convert(revision2), ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), (options & 0x200L) != 0L, (DiffSummaryCallback)callback);
                callback.doLastDiff();
                this.fireSucceeded("diffStatus", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffStatus", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void info(SVNEntryRevisionReference reference, int depth, String[] changelistNames, ISVNEntryInfoCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("changelistNames", changelistNames);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("info", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (Integer)parameters.get("depth");
        changelistNames = (String[])parameters.get("changelistNames");
        cb = (ISVNEntryInfoCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.info2(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), ConversionUtility.convert(cb));
                this.fireSucceeded("info", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "info", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void streamFileContent(SVNEntryRevisionReference reference, int bufferSize, OutputStream stream, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("bufferSize", bufferSize);
        parameters.put("stream", stream);
        parameters.put("monitor", monitor);
        this.fireAsked("streamFileContent", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        bufferSize = (Integer)parameters.get("bufferSize");
        stream = (OutputStream)parameters.get("stream");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.streamFileContent(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), stream);
                this.fireSucceeded("streamFileContent", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "streamFileContent", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mkdir(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("mkdir", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mkdir(new HashSet<String>(Arrays.asList(path)), (options & 8L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), null);
                this.fireSucceeded("mkdir", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mkdir", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void move(String[] srcPaths, String dstPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("dstPath", dstPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("moveLocal", parameters);
        srcPaths = (String[])parameters.get("srcPaths");
        dstPath = (String)parameters.get("dstPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.move(new HashSet<String>(Arrays.asList(srcPaths)), dstPath, (options & 4L) != 0L, true, false, null, null, null);
                this.fireSucceeded("moveLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "moveLocal", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void move(SVNEntryReference[] srcPaths, String dstPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("dstPath", dstPath);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("move", parameters);
        srcPaths = (SVNEntryReference[])parameters.get("srcPaths");
        dstPath = (String)parameters.get("dstPath");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                HashSet<String> src = new HashSet<String>();
                SVNEntryReference[] sVNEntryReferenceArray = srcPaths;
                int n = srcPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    SVNEntryReference current = sVNEntryReferenceArray[n2];
                    src.add(current.path);
                    ++n2;
                }
                this.client.move(src, dstPath, (options & 4L) != 0L, (options & 0x8000L) != 0L, (options & 8L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), null);
                this.fireSucceeded("move", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "move", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copy(String[] srcPaths, String destPath, SVNRevision revision, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("destPath", destPath);
        parameters.put("revision", revision);
        parameters.put("monitor", monitor);
        this.fireAsked("copyLocal", parameters);
        srcPaths = (String[])parameters.get("srcPaths");
        destPath = (String)parameters.get("destPath");
        revision = (SVNRevision)parameters.get("revision");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                CopySource[] srcs = new CopySource[srcPaths.length];
                int i = 0;
                while (i < srcPaths.length) {
                    srcs[i] = new CopySource(srcPaths[i], revision.getKind() == 6 ? null : ConversionUtility.convert(revision), null);
                    ++i;
                }
                this.client.copy(Arrays.asList(srcs), destPath, true, false, false, null, null, null);
                this.fireSucceeded("copyLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "copyLocal", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copy(SVNEntryRevisionReference[] srcPaths, String destPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("destPath", destPath);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("copy", parameters);
        srcPaths = (SVNEntryRevisionReference[])parameters.get("srcPaths");
        destPath = (String)parameters.get("destPath");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.copy(Arrays.asList(ConversionUtility.convert(srcPaths)), destPath, (options & 0x8000L) != 0L, (options & 8L) != 0L, (options & 1L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), null);
                this.fireSucceeded("copy", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "copy", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void remove(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("remove", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.remove(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L, (options & 0x10000L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), null);
                this.fireSucceeded("remove", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "remove", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void logEntries(SVNEntryReference reference, SVNRevisionRange[] revisionRanges, String[] revProps, long limit, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisionRanges", revisionRanges);
        parameters.put("revProps", revProps);
        parameters.put("limit", limit);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("logEntries", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisionRanges = (SVNRevisionRange[])parameters.get("revisionRanges");
        revProps = (String[])parameters.get("revProps");
        limit = (Long)parameters.get("limit");
        options = (Long)parameters.get("options");
        cb = (ISVNLogEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                if (revProps == null) {
                    throw new NullPointerException("revProps argument cannot be null");
                }
                this.client.logMessages(reference.path, ConversionUtility.convert(reference.pegRevision), Arrays.asList(ConversionUtility.convert(revisionRanges)), (options & 0x20000L) != 0L, (options & 0x40000L) != 0L, (options & 0x80000L) != 0L, new HashSet<String>(Arrays.asList(revProps)), limit, ConversionUtility.convert(cb));
                this.fireSucceeded("logEntries", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "logEntries", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void annotate(SVNEntryReference reference, SVNRevision revisionStart, SVNRevision revisionEnd, long options, ISVNAnnotationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisionStart", revisionStart);
        parameters.put("revisionEnd", revisionEnd);
        parameters.put("options", options);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("annotate", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisionStart = (SVNRevision)parameters.get("revisionStart");
        revisionEnd = (SVNRevision)parameters.get("revisionEnd");
        options = (Long)parameters.get("options");
        callback = (ISVNAnnotationCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.blame(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), (options & 0x100000L) != 0L, (options & 0x80000L) != 0L, ConversionUtility.convert(callback));
                this.fireSucceeded("annotate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "annotate", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void list(SVNEntryRevisionReference reference, int depth, int direntFields, long options, ISVNEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("direntFields", direntFields);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("list", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (Integer)parameters.get("depth");
        direntFields = (Integer)parameters.get("direntFields");
        options = (Long)parameters.get("options");
        final ISVNEntryCallback cb1 = (ISVNEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.list(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), direntFields, (options & 0x200000L) != 0L, new ListCallback(){

                    public void doEntry(DirEntry dirent, Lock lock) {
                        String path = dirent.getPath();
                        if (path != null && path.length() != 0 || dirent.getNodeKind() == NodeKind.file) {
                            Date date = dirent.getLastChanged();
                            cb1.next(new SVNEntry(path, dirent.getLastChangedRevisionNumber(), date == null ? 0L : date.getTime(), dirent.getLastAuthor(), dirent.getHasProps(), ConversionUtility.convert(dirent.getNodeKind()), dirent.getSize(), ConversionUtility.convert(lock)));
                        }
                    }
                });
                this.fireSucceeded("list", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "list", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void getProperties(SVNEntryRevisionReference reference, int depth, String[] changelistNames, ISVNPropertyCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("changelistNames", changelistNames);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("getProperties", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (Integer)parameters.get("depth");
        changelistNames = (String[])parameters.get("changelistNames");
        callback = (ISVNPropertyCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.properties(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), ConversionUtility.convert(callback));
                this.fireSucceeded("getProperties", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "getProperties", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty getProperty(SVNEntryRevisionReference reference, String name, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("name", name);
        parameters.put("monitor", monitor);
        this.fireAsked("getProperty", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        name = (String)parameters.get("name");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            byte[] data = this.client.propertyGet(reference.path, name, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision));
            SVNProperty retVal = data != null ? new SVNProperty(name, data) : null;
            this.fireSucceeded("getProperty", parameters, retVal);
            SVNProperty sVNProperty = retVal;
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getProperty", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void removeProperty(String[] path, String name, int depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("name", name);
        parameters.put("depth", depth);
        parameters.put("changelistNames", changelistNames);
        parameters.put("monitor", monitor);
        this.fireAsked("removeProperty", parameters);
        path = (String[])parameters.get("path");
        name = (String)parameters.get("name");
        depth = (Integer)parameters.get("depth");
        changelistNames = (String[])parameters.get("changelistNames");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertySetLocal(new HashSet<String>(Arrays.asList(path)), name, null, ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), (options & 4L) != 0L);
                this.fireSucceeded("removeProperty", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeProperty", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setProperty(String[] path, SVNProperty property, int depth, long options, String[] changelistNames, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("property", property);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changelistNames", changelistNames);
        parameters.put("monitor", monitor);
        this.fireAsked("setProperty", parameters);
        path = (String[])parameters.get("path");
        property = (SVNProperty)parameters.get("property");
        depth = (Integer)parameters.get("depth");
        options = (Long)parameters.get("options");
        changelistNames = (String[])parameters.get("changelistNames");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertySetLocal(new HashSet<String>(Arrays.asList(path)), property.name, property.binValue, ConversionUtility.convertDepth(depth), changelistNames == null ? null : Arrays.asList(changelistNames), (options & 4L) != 0L);
                this.fireSucceeded("setProperty", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setProperty", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty[] getRevisionProperties(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("getRevisionProperties", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty[] retVal = ConversionUtility.convertRevProps(this.client.revProperties(reference.path, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("getRevisionProperties", parameters, retVal);
            SVNProperty[] sVNPropertyArray = retVal;
            return sVNPropertyArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getRevisionProperties", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public SVNProperty getRevisionProperty(SVNEntryReference reference, String name, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("name", name);
        parameters.put("monitor", monitor);
        this.fireAsked("getRevisionProperty", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        name = (String)parameters.get("name");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty retVal = new SVNProperty(name, this.client.revProperty(reference.path, name, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("getRevisionProperty", parameters, retVal);
            SVNProperty sVNProperty = retVal;
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getRevisionProperty", parameters);
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void setRevisionProperty(SVNEntryReference reference, SVNProperty property, String originalValue, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("property", property);
        parameters.put("originalValue", originalValue);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("setRevisionProperty", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        property = (SVNProperty)parameters.get("property");
        originalValue = (String)parameters.get("originalValue");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.setRevProperty(reference.path, property.name, ConversionUtility.convert(reference.pegRevision), property.value, originalValue, (options & 4L) != 0L);
                this.fireSucceeded("setRevisionProperty", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setRevisionProperty", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void createRepository(String repositoryPath, String repositoryType, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("repositoryPath", repositoryPath);
        parameters.put("repositoryType", repositoryType);
        parameters.put("monitor", monitor);
        this.fireAsked("createRepository", parameters);
        repositoryPath = (String)parameters.get("repositoryPath");
        repositoryType = (String)parameters.get("repositoryType");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                String fsType = repositoryType == null ? "fsfs" : repositoryType;
                this.svnAdmin.create(new File(repositoryPath), false, false, null, fsType);
                this.fireSucceeded("createRepository", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "createRepository", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void upgrade(String path, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("monitor", monitor);
        this.fireAsked("upgrade", parameters);
        path = (String)parameters.get("path");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.upgrade(path);
                this.fireSucceeded("upgrade", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "upgrade", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void patch(String patchPath, String targetPath, int stripCount, long options, ISVNPatchCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("patchPath", patchPath);
        parameters.put("targetPath", targetPath);
        parameters.put("stripCount", stripCount);
        parameters.put("options", options);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("patch", parameters);
        patchPath = (String)parameters.get("patchPath");
        targetPath = (String)parameters.get("targetPath");
        stripCount = (Integer)parameters.get("stripCount");
        options = (Long)parameters.get("options");
        callback = (ISVNPatchCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.patch(patchPath, targetPath, (options & 0x400L) != 0L, stripCount, (options & 0x800000L) != 0L, (options & 0x1000000L) != 0L, (options & 0x2000000L) != 0L, ConversionUtility.convert(callback));
                this.fireSucceeded("patch", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "patch", parameters);
                wrapper.interrupt();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.interrupt();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void dispose() {
        this.client.dispose();
        this.svnAdmin.dispose();
    }

    protected void handleSubversionException(SubversionException ex, String methodName, Map<String, Object> parameters) throws SVNConnectorException {
        SVNConnectorException exception = new SVNConnectorException(ConversionUtility.convertZeroCodedLine(ex.getMessage()), (Throwable)ex);
        this.fireFailed(methodName, parameters, exception);
        throw exception;
    }

    protected void handleClientException(ClientException ex, String methodName, Map<String, Object> parameters) throws SVNConnectorException {
        String msg = ConversionUtility.convertZeroCodedLine(ex.getMessage());
        Object exception = null;
        if (this.findConflict(ex)) {
            exception = new SVNConnectorUnresolvedConflictException(msg, (Throwable)ex);
        }
        if (this.findCancel(ex)) {
            exception = new SVNConnectorCancelException(msg, (Throwable)ex);
        }
        if (this.findAuthentication(ex)) {
            exception = new SVNConnectorAuthenticationException(msg, (Throwable)ex);
        }
        if (exception == null) {
            exception = new SVNConnectorException(msg, ex.getAprError(), (Throwable)ex);
        }
        if (methodName != null) {
            this.fireFailed(methodName, parameters, (SVNConnectorException)((Object)exception));
        }
        throw exception;
    }

    protected boolean findConflict(ClientException t) {
        return t.getAprError() == 160024 || t.getAprError() == 160028;
    }

    protected boolean findAuthentication(ClientException t) {
        return t.getAprError() == 170001;
    }

    protected boolean findCancel(ClientException t) {
        return t.getAprError() == 200015;
    }

    public static ISVNProgressMonitor.ItemState makeItemState(SVNNotification arg0) {
        return new ISVNProgressMonitor.ItemState(arg0.path, arg0.action, arg0.kind, arg0.mimeType, arg0.contentState, arg0.propState, arg0.revision, arg0.errMsg);
    }

    protected static synchronized ProgressMonitorThread getProgressMonitorThread() {
        if (monitorWrapperThread == null) {
            monitorWrapperThread = new ProgressMonitorThread();
            monitorWrapperThread.start();
        }
        return monitorWrapperThread;
    }

    protected void fireAsked(String methodName, Map<String, Object> parameters) {
        ISVNCallListener[] iSVNCallListenerArray = this.callListeners.toArray(new ISVNCallListener[0]);
        int n = iSVNCallListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNCallListener listener = iSVNCallListenerArray[n2];
            listener.asked(methodName, parameters);
            ++n2;
        }
    }

    protected void fireSucceeded(String methodName, Map<String, Object> parameters, Object returnValue) {
        ISVNCallListener[] iSVNCallListenerArray = this.callListeners.toArray(new ISVNCallListener[0]);
        int n = iSVNCallListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNCallListener listener = iSVNCallListenerArray[n2];
            listener.succeeded(methodName, parameters, returnValue);
            ++n2;
        }
    }

    protected void fireFailed(String methodName, Map<String, Object> parameters, SVNConnectorException exception) {
        ISVNCallListener[] iSVNCallListenerArray = this.callListeners.toArray(new ISVNCallListener[0]);
        int n = iSVNCallListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNCallListener listener = iSVNCallListenerArray[n2];
            listener.failed(methodName, parameters, exception);
            ++n2;
        }
    }

    protected class CommitInfo
    implements CommitCallback {
        public org.apache.subversion.javahl.CommitInfo info;

        protected CommitInfo() {
        }

        public void commitInfo(org.apache.subversion.javahl.CommitInfo info) {
            this.info = info;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CommitMessage
    implements CommitMessageCallback {
        private String message;

        public CommitMessage(String message) {
            this.message = message == null ? "" : message;
        }

        @Override
        public String getLogMessage(Set<CommitItem> elementsToBeCommitted) {
            return this.message;
        }
    }

    private class DiffCallback
    implements DiffSummaryCallback {
        private String prev;
        private String next;
        private boolean isFile;
        private SVNDiffStatus savedDiff;
        private ISVNDiffStatusCallback cb;

        public DiffCallback(String prev, String next, boolean isFile, ISVNDiffStatusCallback cb) {
            this.prev = SVNUtility.decodeURL((String)prev);
            this.next = SVNUtility.decodeURL((String)next);
            this.isFile = isFile;
            this.cb = cb;
        }

        public void onSummary(DiffSummary descriptor) {
            int propChangeType;
            int changeType = 1;
            if (descriptor.getDiffKind() == DiffSummary.DiffKind.added) {
                changeType = 3;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.deleted) {
                changeType = 4;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.modified) {
                changeType = 2;
            }
            int n = propChangeType = descriptor.propsChanged() ? 2 : 1;
            if (changeType != 1 || propChangeType != 1) {
                String tPath1;
                String tPath2 = tPath1 = descriptor.getPath();
                if (tPath1.length() == 0 || this.isFile) {
                    tPath1 = this.prev;
                    tPath2 = this.next;
                } else {
                    tPath1 = String.valueOf(this.prev) + "/" + tPath1;
                    tPath2 = String.valueOf(this.next) + "/" + tPath2;
                }
                SVNDiffStatus status = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), ConversionUtility.convert(descriptor.getNodeKind()), changeType, propChangeType);
                if (this.savedDiff != null) {
                    if (this.savedDiff.pathPrev.equals(status.pathPrev) && this.savedDiff.pathNext.equals(status.pathNext) && this.savedDiff.textStatus == 4 && status.textStatus == 3) {
                        this.savedDiff = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), ConversionUtility.convert(descriptor.getNodeKind()), 7, 1);
                        status = null;
                    }
                    this.cb.next(this.savedDiff);
                }
                this.savedDiff = status;
            }
        }

        public void doLastDiff() {
            if (this.savedDiff != null) {
                this.cb.next(this.savedDiff);
            }
        }
    }

    protected static class ProgressMonitorThread
    extends Thread {
        private final List<ProgressMonitorWrapper> monitors = new ArrayList<ProgressMonitorWrapper>();

        public ProgressMonitorThread() {
            super("JavaHL 1.7 Connector");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ProgressMonitorWrapper monitor) {
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                this.monitors.add(monitor);
                this.monitors.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ProgressMonitorWrapper monitor) {
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                this.monitors.remove(monitor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                this.checkForActivityCancelled();
                try {
                    List<ProgressMonitorWrapper> list = this.monitors;
                    synchronized (list) {
                        if (this.monitors.size() == 0) {
                            this.monitors.wait();
                        } else {
                            this.monitors.wait(100L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForActivityCancelled() {
            ProgressMonitorWrapper[] monitors;
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                monitors = this.monitors.toArray(new ProgressMonitorWrapper[this.monitors.size()]);
            }
            ProgressMonitorWrapper[] progressMonitorWrapperArray = monitors;
            int n = monitors.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressMonitorWrapper monitor = progressMonitorWrapperArray[n2];
                if (monitor.monitor.isActivityCancelled()) {
                    monitor.cancel();
                }
                ++n2;
            }
        }
    }

    protected class ProgressMonitorWrapper
    implements ISVNNotificationCallback {
        protected ISVNProgressMonitor monitor;
        protected int current;

        public ProgressMonitorWrapper(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
            this.current = 0;
        }

        public void cancel() {
            try {
                JavaHLConnector.this.client.cancelOperation();
            }
            catch (Exception exception) {}
        }

        public void notify(SVNNotification arg0) {
            this.monitor.progress(this.current++, -1, JavaHLConnector.makeItemState(arg0));
        }

        public void start() {
            JavaHLConnector.getProgressMonitorThread().add(this);
        }

        public void interrupt() {
            JavaHLConnector.getProgressMonitorThread().remove(this);
        }
    }

    protected class RepositoryInfoPrompt
    implements UserPasswordCallback {
        protected ISVNCredentialsPrompt prompt;

        public RepositoryInfoPrompt(ISVNCredentialsPrompt prompt) {
            this.prompt = prompt;
        }

        public boolean prompt(String realm, String username) {
            return this.prompt.prompt(null, realm);
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return this.prompt.prompt(null, realm);
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return this.prompt.askTrustSSLServer(null, info, allowPermanently);
        }

        public String getUsername() {
            return this.prompt.getUsername();
        }

        public String getPassword() {
            return this.prompt.getPassword();
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            if (question.indexOf("certificate filename") != -1) {
                if (JavaHLConnector.this.sslCertificate != null) {
                    String retVal = JavaHLConnector.this.sslCertificate;
                    return retVal;
                }
                if (!this.prompt.promptSSL(null, realm)) {
                    return null;
                }
                JavaHLConnector.this.sslPassphrase = this.prompt.getSSLClientCertPassword();
                return this.prompt.getSSLClientCertPath();
            }
            if (question.indexOf("certificate passphrase") != -1) {
                if (JavaHLConnector.this.sslPassphrase != null) {
                    String retVal = JavaHLConnector.this.sslPassphrase;
                    return retVal;
                }
                if (!this.prompt.promptSSL(null, realm)) {
                    return null;
                }
                return this.prompt.getSSLClientCertPassword();
            }
            return null;
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return null;
        }

        public boolean userAllowedSave() {
            return this.prompt.isSaveCredentialsEnabled();
        }
    }
}

