/*
 * Decompiled with CFR 0.152.
 */
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SearchThread
extends Thread {
    LineFeed lineFeed;
    String text;
    int maxHit;
    int hitCounter;
    ResultManager resultManager;
    long ms = System.currentTimeMillis();
    int preoffset;
    int postoffset;
    boolean stop = false;
    boolean reverseSearch;

    public SearchThread(Prefs prefs, LineFeed lineFeed, int maxHit, String text, ResultManager resultManager, boolean reverseSearch) {
        this.maxHit = maxHit;
        this.lineFeed = lineFeed;
        this.text = text;
        this.resultManager = resultManager;
        this.reverseSearch = reverseSearch;
        if (prefs.selectedExpressionTypeButtonName.equals("regexp")) {
            this.preoffset = 1;
            this.postoffset = 2;
        }
    }

    public void run() {
        RE regexp = null;
        String line = null;
        try {
            regexp = new RE(this.text, 1);
        }
        catch (RESyntaxException rESyntaxException) {
            // empty catch block
        }
        if (!this.reverseSearch) {
            while ((line = this.lineFeed.getLine()) != null) {
                if (this.stop) {
                    return;
                }
                if (regexp.match(line)) {
                    String line2 = this.lineFeed.getLine();
                    this.resultManager.putResult(new Result(line, line2));
                    this.lineFeed.getLine();
                    ++this.hitCounter;
                    if (this.hitCounter < this.maxHit) continue;
                    break;
                }
                this.lineFeed.getLine();
                this.lineFeed.getLine();
            }
        }
        this.resultManager.elapsedTime = System.currentTimeMillis() - this.ms;
        this.resultManager.putResult(null);
    }

    public void terminate() {
        System.out.println("Terminating searchthead");
        this.stop = true;
    }
}

