%SeDuMi installatino script

% This file is part of SeDuMi 1.1 by Imre Polik and Oleksandr Romanko
% Copyright (C) 2005 McMaster University, Hamilton, CANADA  (since 1.1)
%
% Copyright (C) 2001 Jos F. Sturm (up to 1.05R5)
%   Dept. Econometrics & O.R., Tilburg University, the Netherlands.
%   Supported by the Netherlands Organization for Scientific Research (NWO).
%
% Affiliation SeDuMi 1.03 and 1.04Beta (2000):
%   Dept. Quantitative Economics, Maastricht University, the Netherlands.
%
% Affiliations up to SeDuMi 1.02 (AUG1998):
%   CRL, McMaster University, Canada.
%   Supported by the Netherlands Organization for Scientific Research (NWO).
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc.,  51 Franklin Street, Fifth Floor, Boston, MA
% 02110-1301, USA

targets={...
'ddot.c sdmauxCone.c sdmauxRdot.c sdmauxScalarmul.c',...
'psdscale.c triuaux.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c sdmauxScalarmul.c blkaux.c',...
'qblkmul.c sdmauxScalarmul.c',...
'adendotd.c sdmauxCone.c',...
'adenscale.c',...
'eigK.c sdmauxCone.c sdmauxRdot.c',...
'extractA.c',...
'eyeK.c sdmauxCone.c',...
'psdfactor.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c',...
'factorK.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c',...
'findblks.c sdmauxCone.c sdmauxCmp.c',...
'psdframeit.c reflect.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c sdmauxScalarmul.c',...
'qreshape.c sdmauxCone.c sdmauxCmp.c',...
'psdinvjmul.c reflect.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c sdmauxScalarmul.c blkaux.c',...
'getada1.c sdmauxFill.c',...
'getada2.c sdmauxCone.c sdmauxRdot.c sdmauxFill.c',...
'getada3.c spscale.c sdmauxCone.c sdmauxRdot.c sdmauxScalarmul.c sdmauxCmp.c',...
'givensrot.c auxgivens.c sdmauxCone.c',...
'incorder.c',...
'invcholfac.c triuaux.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c sdmauxScalarmul.c blkaux.c',...
'iswnbr.c',...
'makereal.c sdmauxCone.c sdmauxCmp.c',...
'partitA.c sdmauxCmp.c',...
'psdeig.c sdmauxCone.c',...
'psdinvscale.c triuaux.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c',...
'psdjmul.c sdmauxCone.c sdmauxRdot.c sdmauxTriu.c',...
'qframev.c sdmauxCone.c sdmauxRdot.c sdmauxFill.c sdmauxScalarmul.c blkaux.c',...
'qinvsqrt.c sdmauxCone.c sdmauxScalarmul.c',...
'qrK.c sdmauxCone.c sdmauxRdot.c sdmauxScalarmul.c',...
'qscaleK.c sdmauxCone.c sdmauxRdot.c sdmauxScalarmul.c blkaux.c',...
'quadadd.c',...
'sortnnz.c sdmauxCmp.c',...
'sqrtinv.c sdmauxCone.c',...
'statsK.c sdmauxCone.c',...
'triumtriu.c sdmauxCone.c sdmauxTriu.c sdmauxScalarmul.c',...
'urotorder.c auxgivens.c sdmauxCone.c sdmauxTriu.c sdmauxRdot.c',...
'vecsym.c sdmauxCone.c',...
'vectril.c sdmauxCone.c sdmauxCmp.c',...
'whichcpx.c sdmauxCone.c',...
'dpr1fact.c auxfwdpr1.c sdmauxCone.c  sdmauxCmp.c sdmauxFill.c sdmauxScalarmul.c sdmauxRdot.c blkaux.c',...
'finsymbden.c sdmauxCmp.c',...
'fwdpr1.c auxfwdpr1.c sdmauxCone.c sdmauxScalarmul.c',...
'bwdpr1.c sdmauxCone.c sdmauxRdot.c',...
'ordmmdmex.c ordmmd.c',...
'symfctmex.c symfct.c',...
'choltmpsiz.c',...
'cholsplit.c',...
'symbbwblk.c',...
'symbfwblk.c',...
'blkchol.c blkchol2.c sdmauxFill.c sdmauxScalarmul.c',...
'fwblkslv.c sdmauxScalarmul.c',...
'bwblkslv.c sdmauxFill.c sdmauxRdot.c',...
};
clc
disp('Building SeDuMi binaries')
for i=1:length(targets)
        disp(targets{i});
        eval(['mex ',targets{i}])
end
disp('Done!')
disp('Adding SeDuMi to the Matlab path')
path(path,pwd);
cd conversion
path(path,pwd);
cd ..
cd examples
path(path,pwd);
cd ..
disp('Please save the Matlab path if you want to use SeDuMi from any directory.'); 
disp('Go to File/Set Path and click on Save.');
disp('SeDuMi has been succesfully installed. For more information type help sedumi or see the User guide.')
clear targets i 
