/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.auximport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuxSubGenerator {
    private HashSet<String> mySet = new HashSet(20);
    private Vector<String> notFoundList = new Vector();
    private BibtexDatabase db;
    private BibtexDatabase auxDB;
    private int nestedAuxCounter;
    private int crossreferencedEntriesCount = 0;

    public AuxSubGenerator(BibtexDatabase refDBase) {
        this.db = refDBase;
    }

    public final void setReferenceDatabase(BibtexDatabase newRefDB) {
        this.db = newRefDB;
    }

    public final boolean parseAuxFile(String filename) {
        boolean weiter = false;
        boolean back = true;
        boolean loopFileOpen = false;
        Pattern pattern = Pattern.compile("\\\\citation\\{.+\\}");
        BufferedReader br = null;
        Vector<String> fileList = new Vector<String>(5);
        fileList.add(filename);
        File dummy = new File(filename);
        String path = dummy.getParent();
        path = path != null ? path + File.separator : "";
        this.nestedAuxCounter = -1;
        for (int fileIndex = 0; fileIndex < fileList.size(); ++fileIndex) {
            String fName = (String)fileList.elementAt(fileIndex);
            try {
                br = new BufferedReader(new FileReader(fName));
                weiter = true;
                loopFileOpen = true;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Cannot locate input file! " + fnfe.getMessage());
                back = false;
                weiter = false;
                loopFileOpen = false;
            }
            while (weiter) {
                String line;
                try {
                    if (br == null) {
                        throw new IOException();
                    }
                    line = br.readLine();
                }
                catch (IOException ioe) {
                    line = null;
                    weiter = false;
                }
                if (line != null) {
                    String str;
                    int start;
                    int end;
                    Matcher matcher = pattern.matcher(line);
                    while (matcher.find()) {
                        String str2;
                        String[] keys;
                        int len = matcher.end() - matcher.start();
                        if (len <= 11 || (keys = (str2 = matcher.group().substring(matcher.start() + 10, matcher.end() - 1)).split(",")) == null) continue;
                        int keyCount = keys.length;
                        for (int t = 0; t < keyCount; ++t) {
                            String dummyStr = keys[t];
                            if (dummyStr == null) continue;
                            this.mySet.add(dummyStr.trim());
                        }
                    }
                    int index = line.indexOf("\\@input{");
                    if (index < 0 || (end = line.indexOf("}", start = index + 8)) <= start || fileList.contains(str = path + line.substring(index + 8, end))) continue;
                    fileList.add(str);
                    continue;
                }
                weiter = false;
            }
            if (!loopFileOpen) continue;
            try {
                if (br != null) {
                    br.close();
                }
                ++this.nestedAuxCounter;
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return back;
    }

    public final void resolveTags() {
        this.auxDB = new BibtexDatabase();
        this.notFoundList.clear();
        for (String str : this.mySet) {
            BibtexEntry entry = this.db.getEntryByKey(str);
            if (entry == null) {
                this.notFoundList.add(str);
                continue;
            }
            this.insertEntry(this.auxDB, entry);
            String crossref = entry.getField("crossref");
            if (crossref == null || this.mySet.contains(crossref)) continue;
            BibtexEntry refEntry = this.db.getEntryByKey(crossref);
            if (refEntry == null) {
                this.notFoundList.add(crossref);
                continue;
            }
            this.insertEntry(this.auxDB, refEntry);
            ++this.crossreferencedEntriesCount;
        }
    }

    private void insertEntry(BibtexDatabase auxDB, BibtexEntry entry) {
        try {
            BibtexEntry clonedEntry = (BibtexEntry)entry.clone();
            clonedEntry.setId(Util.createNeutralId());
            auxDB.insertEntry(clonedEntry);
        }
        catch (KeyCollisionException e) {
            e.printStackTrace();
        }
    }

    public final Vector<String> generate(String auxFileName, BibtexDatabase bibDB) {
        this.setReferenceDatabase(bibDB);
        this.parseAuxFile(auxFileName);
        this.resolveTags();
        return this.notFoundList;
    }

    public BibtexDatabase getGeneratedDatabase() {
        if (this.auxDB == null) {
            this.auxDB = new BibtexDatabase();
        }
        return this.auxDB;
    }

    public final int getFoundKeysInAux() {
        return this.mySet.size();
    }

    public final int getResolvedKeysCount() {
        return this.auxDB.getEntryCount() - this.crossreferencedEntriesCount;
    }

    public final int getNotResolvedKeysCount() {
        return this.notFoundList.size();
    }

    public final int getCrossreferencedEntriesCount() {
        return this.crossreferencedEntriesCount;
    }

    public final void clear() {
        this.mySet.clear();
        this.notFoundList.clear();
        this.crossreferencedEntriesCount = 0;
    }

    public Vector<String> getNotFoundList() {
        return this.notFoundList;
    }

    public int getNestedAuxCounter() {
        return this.nestedAuxCounter;
    }
}

