/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Util;
import net.sf.jabref.sql.DBConnectDialog;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLutil;

public class DbImportAction
extends AbstractWorker {
    BibtexDatabase database = null;
    MetaData metaData = null;
    String errorMessage = null;
    boolean connectToDB = false;
    private JabRefFrame frame;
    private DBStrings dbs = null;

    public DbImportAction(JabRefFrame frame) {
        this.frame = frame;
    }

    public AbstractAction getAction() {
        return new DbImpAction();
    }

    public void init() {
        this.dbs = new DBStrings();
        this.dbs.initialize();
        DBConnectDialog dbd = new DBConnectDialog(this.frame, this.dbs);
        this.dbs = dbd.getDBStrings();
        if (!this.dbs.isConfigValid()) {
            if (!this.dbs.isInitialized()) {
                this.dbs.initialize();
            }
            dbd = new DBConnectDialog(this.frame, this.dbs);
            Util.placeDialog(dbd, this.frame);
            dbd.setVisible(true);
            this.connectToDB = dbd.getConnectToDB();
            if (this.connectToDB) {
                this.dbs = dbd.getDBStrings();
                dbd.dispose();
            }
        } else {
            this.connectToDB = true;
        }
    }

    public void run() {
        if (this.connectToDB) {
            try {
                this.frame.output(Globals.lang("Attempting SQL import..."));
                Object[] res = SQLutil.importDatabase(null, this.dbs);
                this.database = (BibtexDatabase)res[0];
                this.metaData = (MetaData)res[1];
                this.dbs.isConfigValid(true);
            }
            catch (Exception ex) {
                this.errorMessage = SQLutil.getExceptionMessage(ex, SQLutil.DBTYPE.MYSQL);
                this.dbs.isConfigValid(false);
            }
        }
    }

    public void update() {
        if (this.database != null) {
            BasePanel pan = this.frame.addTab(this.database, null, this.metaData, Globals.prefs.get("defaultEncoding"), true);
            pan.metaData().setDBStrings(this.dbs);
            return;
        }
    }

    class DbImpAction
    extends MnemonicAwareAction {
        public DbImpAction() {
            super(GUIGlobals.getImage("dbImport"));
            this.putValue("Name", "Import from external SQL database");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Util.runAbstractWorker(DbImportAction.this);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

