/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.labelPattern.ResolveDuplicateLabelDialog;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableKeyChange;

public class SearchFixDuplicateLabels
extends AbstractWorker {
    private BasePanel panel;
    HashMap<String, List<BibtexEntry>> dupes = null;

    public SearchFixDuplicateLabels(BasePanel panel) {
        this.panel = panel;
    }

    public void run() {
        this.dupes = new HashMap();
        HashMap<String, BibtexEntry> foundKeys = new HashMap<String, BibtexEntry>();
        BibtexDatabase db = this.panel.database();
        for (BibtexEntry entry : db.getEntries()) {
            String key = entry.getCiteKey();
            if (key == null || key.length() <= 0) continue;
            if (!foundKeys.containsKey(key)) {
                foundKeys.put(key, entry);
                continue;
            }
            if (this.dupes.containsKey(key)) {
                this.dupes.get(key).add(entry);
                continue;
            }
            ArrayList<Object> al = new ArrayList<Object>();
            al.add(foundKeys.get(key));
            al.add(entry);
            this.dupes.put(key, al);
        }
    }

    public void init() throws Throwable {
        this.panel.output(Globals.lang("Resolving duplicate BibTeX keys..."));
    }

    public void update() {
        ArrayList<BibtexEntry> toGenerateFor = new ArrayList<BibtexEntry>();
        for (String key : this.dupes.keySet()) {
            ResolveDuplicateLabelDialog rdld = new ResolveDuplicateLabelDialog(this.panel, key, this.dupes.get(key));
            rdld.show();
            if (!rdld.isOkPressed()) continue;
            List<JCheckBox> cbs = rdld.getCheckBoxes();
            for (int i = 0; i < cbs.size(); ++i) {
                if (!cbs.get(i).isSelected()) continue;
                toGenerateFor.add(this.dupes.get(key).get(i));
            }
        }
        if (toGenerateFor.size() > 0) {
            NamedCompound ce = new NamedCompound("resolve duplicate keys");
            for (BibtexEntry entry : toGenerateFor) {
                String oldKey = entry.getCiteKey();
                entry = LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), this.panel.database(), entry);
                ce.addEdit(new UndoableKeyChange(this.panel.database(), entry.getId(), oldKey, entry.getField("bibtexkey")));
            }
            ce.end();
            this.panel.undoManager.addEdit(ce);
            this.panel.markBaseChanged();
        }
        this.panel.output(Globals.lang("Finished resolving duplicate BibTeX keys. %0 entries modified.", String.valueOf(toGenerateFor.size())));
    }
}

