/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RisImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "RIS";
    }

    @Override
    public String getCLIId() {
        return "ris";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        Pattern pat1 = Pattern.compile("AU  - .*");
        Pattern pat2 = Pattern.compile("A1  - .*");
        Pattern pat3 = Pattern.compile("A2  - .*");
        while ((str = in.readLine()) != null) {
            if (!pat1.matcher(str).find() && !pat2.matcher(str).find() && !pat3.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream) throws IOException {
        String str;
        ArrayList<BibtexEntry> bibitems = new ArrayList<BibtexEntry>();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        while ((str = in.readLine()) != null) {
            sb.append(str);
            sb.append("\n");
        }
        String[] entries = sb.toString().split("ER  -");
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].trim().length() == 0) continue;
            String type = "";
            String author = "";
            String editor = "";
            String startPage = "";
            String endPage = "";
            String comment = "";
            HashMap<String, String> hm = new HashMap<String, String>();
            String[] fields = entries[i].split("\n");
            for (int j = 0; j < fields.length; ++j) {
                StringBuffer current = new StringBuffer(fields[j]);
                boolean done = false;
                while (!done && j < fields.length - 1) {
                    if (fields[j + 1].length() >= 6 && !fields[j + 1].substring(2, 6).equals("  - ")) {
                        if (current.length() > 0 && !Character.isWhitespace(current.charAt(current.length() - 1)) && !Character.isWhitespace(fields[j + 1].charAt(0))) {
                            current.append(' ');
                        }
                        current.append(fields[j + 1]);
                        ++j;
                        continue;
                    }
                    done = true;
                }
                String entry = current.toString();
                if (entry.length() < 6) continue;
                String lab = entry.substring(0, 2);
                String val = entry.substring(6).trim();
                if (lab.equals("TY")) {
                    if (val.equals("BOOK")) {
                        type = "book";
                        continue;
                    }
                    if (val.equals("JOUR") || val.equals("MGZN")) {
                        type = "article";
                        continue;
                    }
                    if (val.equals("THES")) {
                        type = "phdthesis";
                        continue;
                    }
                    if (val.equals("UNPB")) {
                        type = "unpublished";
                        continue;
                    }
                    if (val.equals("RPRT")) {
                        type = "techreport";
                        continue;
                    }
                    if (val.equals("CONF")) {
                        type = "inproceedings";
                        continue;
                    }
                    if (val.equals("CHAP")) {
                        type = "incollection";
                        continue;
                    }
                    type = "other";
                    continue;
                }
                if (lab.equals("T1") || lab.equals("TI")) {
                    hm.put("title", val);
                    continue;
                }
                if (lab.equals("T2") || lab.equals("T3") || lab.equals("BT")) {
                    hm.put("booktitle", val);
                    continue;
                }
                if (lab.equals("AU") || lab.equals("A1")) {
                    if (author.equals("")) {
                        author = val;
                        continue;
                    }
                    author = author + " and " + val;
                    continue;
                }
                if (lab.equals("A2")) {
                    if (editor.equals("")) {
                        editor = val;
                        continue;
                    }
                    editor = editor + " and " + val;
                    continue;
                }
                if (lab.equals("JA") || lab.equals("JF") || lab.equals("JO")) {
                    if (type.equals("inproceedings")) {
                        hm.put("booktitle", val);
                        continue;
                    }
                    hm.put("journal", val);
                    continue;
                }
                if (lab.equals("SP")) {
                    startPage = val;
                    continue;
                }
                if (lab.equals("PB")) {
                    if (type.equals("phdthesis")) {
                        hm.put("school", val);
                        continue;
                    }
                    hm.put("publisher", val);
                    continue;
                }
                if (lab.equals("AD") || lab.equals("CY")) {
                    hm.put("address", val);
                    continue;
                }
                if (lab.equals("EP")) {
                    endPage = val;
                    continue;
                }
                if (lab.equals("SN")) {
                    hm.put("issn", val);
                    continue;
                }
                if (lab.equals("VL")) {
                    hm.put("volume", val);
                    continue;
                }
                if (lab.equals("IS")) {
                    hm.put("number", val);
                    continue;
                }
                if (lab.equals("N2") || lab.equals("AB")) {
                    String oldAb = hm.get("abstract");
                    if (oldAb == null) {
                        hm.put("abstract", val);
                        continue;
                    }
                    hm.put("abstract", oldAb + "\n" + val);
                    continue;
                }
                if (lab.equals("UR")) {
                    hm.put("url", val);
                    continue;
                }
                if ((lab.equals("Y1") || lab.equals("PY")) && val.length() >= 4) {
                    String[] parts = val.split("/");
                    hm.put("year", parts[0]);
                    if (parts.length <= 1 || parts[1].length() <= 0) continue;
                    try {
                        int month = Integer.parseInt(parts[1]);
                        if (month <= 0 || month > 12) continue;
                        hm.put("month", "#" + Globals.MONTHS[month - 1] + "#");
                    }
                    catch (NumberFormatException ex) {}
                    continue;
                }
                if (lab.equals("KW")) {
                    if (!hm.containsKey("keywords")) {
                        hm.put("keywords", val);
                        continue;
                    }
                    String kw = hm.get("keywords");
                    hm.put("keywords", kw + ", " + val);
                    continue;
                }
                if (lab.equals("U1") || lab.equals("U2") || lab.equals("N1")) {
                    if (comment.length() > 0) {
                        comment = comment + "\n";
                    }
                    comment = comment + val;
                    continue;
                }
                if (!lab.equals("ID")) continue;
                hm.put("refid", val);
            }
            if (author.length() > 0) {
                author = AuthorList.fixAuthor_lastNameFirst(author);
                hm.put("author", author);
            }
            if (editor.length() > 0) {
                editor = AuthorList.fixAuthor_lastNameFirst(editor);
                hm.put("editor", editor);
            }
            if (comment.length() > 0) {
                hm.put("comment", comment);
            }
            hm.put("pages", startPage + "--" + endPage);
            BibtexEntry b = new BibtexEntry("__ID", Globals.getEntryType(type));
            ArrayList toRemove = new ArrayList();
            for (Object key : hm.keySet()) {
                String content = (String)hm.get(key);
                if (content != null && content.trim().length() != 0) continue;
                toRemove.add(key);
            }
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                hm.remove(iterator.next());
            }
            b.setField(hm);
            bibitems.add(b);
        }
        return bibitems;
    }
}

