/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopacImporter
extends ImportFormat {
    static final Pattern copacPattern = Pattern.compile("^\\s*TI- ");

    @Override
    public String getFormatName() {
        return "Copac";
    }

    @Override
    public String getCLIId() {
        return "cpc";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        while ((str = in.readLine()) != null) {
            if (!copacPattern.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream) throws IOException {
        String str;
        if (stream == null) {
            throw new IOException("No stream given.");
        }
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        LinkedList<String> entries = new LinkedList<String>();
        StringBuffer sb = new StringBuffer();
        while ((str = in.readLine()) != null) {
            if (str.length() < 4) continue;
            String code = str.substring(0, 4);
            if (code.equals("    ")) {
                sb.append(" ").append(str.trim());
                continue;
            }
            if (str.substring(0, 4).equals("TI- ")) {
                if (sb.length() > 0) {
                    entries.add(sb.toString());
                }
                sb = new StringBuffer();
            }
            sb.append('\n').append(str);
        }
        if (sb.length() > 0) {
            entries.add(sb.toString());
        }
        LinkedList<BibtexEntry> results = new LinkedList<BibtexEntry>();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            BibtexEntry b = new BibtexEntry("__ID", BibtexEntryType.BOOK);
            String[] lines = ((String)it.next()).toString().split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                if (line.length() < 4) continue;
                String code = line.substring(0, 4);
                if (code.equals("TI- ")) {
                    this.setOrAppend(b, "title", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("AU- ")) {
                    this.setOrAppend(b, "author", line.substring(4).trim(), " and ");
                    continue;
                }
                if (code.equals("PY- ")) {
                    this.setOrAppend(b, "year", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("PU- ")) {
                    this.setOrAppend(b, "publisher", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("SE- ")) {
                    this.setOrAppend(b, "series", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("IS- ")) {
                    this.setOrAppend(b, "isbn", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("KW- ")) {
                    this.setOrAppend(b, "keywords", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("NT- ")) {
                    this.setOrAppend(b, "note", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("PD- ")) {
                    this.setOrAppend(b, "physicaldimensions", line.substring(4).trim(), ", ");
                    continue;
                }
                if (code.equals("DT- ")) {
                    this.setOrAppend(b, "documenttype", line.substring(4).trim(), ", ");
                    continue;
                }
                this.setOrAppend(b, code.substring(0, 2), line.substring(4).trim(), ", ");
            }
            results.add(b);
        }
        return results;
    }

    void setOrAppend(BibtexEntry b, String field, String value, String separator) {
        String o = b.getField(field);
        if (o != null) {
            b.setField(field, o + separator + value);
        } else {
            b.setField(field, value);
        }
    }
}

