/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import net.sf.jabref.BibtexEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CiteSeerEntryFetcherHandler
extends DefaultHandler {
    BibtexEntry entry = null;
    String nextField = null;
    boolean nextAssign = false;
    String newAuthors = null;
    int citeseerCitationCount = 0;

    public CiteSeerEntryFetcherHandler(BibtexEntry be) {
        this.entry = be;
    }

    public void characters(char[] ch, int start, int length) {
        if (this.nextAssign) {
            String target = new String(ch, start, length);
            if (this.nextField.equals("title")) {
                this.entry.setField(this.nextField, target);
            } else if (this.nextField.equals("year")) {
                this.entry.setField(this.nextField, String.valueOf(target.substring(0, 4)));
            } else if (this.nextField.equals("citeseerurl")) {
                this.entry.setField(this.nextField, target);
            }
            this.nextAssign = false;
        }
    }

    public void startElement(String name, String localName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("oai_citeseer:relation")) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (!attrName.equals("type") || !attrValue.equals("Is Referenced By")) continue;
                ++this.citeseerCitationCount;
            }
        } else if (qName.equals("oai_citeseer:author")) {
            this.newAuthors = this.newAuthors == null ? attrs.getValue("name") : this.newAuthors + " and " + attrs.getValue("name");
        } else if (qName.equals("dc:title")) {
            this.nextField = "title";
            this.nextAssign = true;
        } else if (qName.equals("dc:date")) {
            this.nextField = "year";
            this.nextAssign = true;
        } else if (qName.equals("dc:identifier")) {
            this.nextField = "citeseerurl";
            this.nextAssign = true;
        }
    }

    public void endDocument() {
        if (this.newAuthors != null) {
            this.entry.setField("author", this.newAuthors);
        }
        this.entry.setField("citeseercitationcount", String.valueOf(this.citeseerCitationCount));
    }
}

