/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.imports.ParserResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutosaveStartupPrompter
implements Runnable {
    private JabRefFrame frame;
    private List<File> files;

    public AutosaveStartupPrompter(JabRefFrame frame, List<File> files) {
        this.frame = frame;
        this.files = files;
    }

    @Override
    public void run() {
        boolean first = this.frame.baseCount() == 0;
        ArrayList<ParserResult> loaded = new ArrayList<ParserResult>();
        HashMap<ParserResult, Integer> location = new HashMap<ParserResult, Integer>();
        Iterator<File> i$ = this.files.iterator();
        while (i$.hasNext()) {
            int answer;
            File file;
            File fileToLoad = file = i$.next();
            boolean tryingAutosave = false;
            tryingAutosave = Globals.prefs.getBoolean("promptBeforeUsingAutosave") ? (answer = JOptionPane.showConfirmDialog(null, "<html>" + Globals.lang("An autosave file was found for this database. This could indicate that JabRef didn't shut down cleanly last time the file was used.") + "<br>" + Globals.lang("Do you want to recover the database from the autosave file?") + "</html>", Globals.lang("Autosave of file '%0'", file.getName()), 0)) == 0 : true;
            if (tryingAutosave) {
                fileToLoad = AutoSaveManager.getAutoSaveFile(file);
            }
            boolean done = false;
            ParserResult pr = null;
            while (!done) {
                pr = JabRef.openBibFile(fileToLoad.getPath(), true);
                if (pr != null && !pr.isInvalid()) {
                    loaded.add(pr);
                    BasePanel panel = this.frame.addTab(pr.getDatabase(), file, pr.getMetaData(), pr.getEncoding(), first);
                    location.put(pr, this.frame.baseCount() - 1);
                    if (tryingAutosave) {
                        panel.markNonUndoableBaseChanged();
                    }
                    first = false;
                    done = true;
                    continue;
                }
                if (tryingAutosave) {
                    JOptionPane.showMessageDialog(this.frame, Globals.lang("Error opening autosave of '%0'. Trying to load '%0' instead.", file.getName()), Globals.lang("Error opening file"), 0);
                    tryingAutosave = false;
                    fileToLoad = file;
                    continue;
                }
                String message = pr != null ? "<html>" + pr.getErrorMessage() + "<p>" + Globals.lang("Error opening file '%0'.", file.getName()) + "</html>" : Globals.lang("Error opening file '%0'.", file.getName());
                JOptionPane.showMessageDialog(this.frame, message, Globals.lang("Error opening file"), 0);
                done = true;
            }
            if (pr == null || pr.isInvalid() || !Globals.prefs.getBoolean("displayKeyWarningDialogAtStartup") || !pr.hasWarnings()) continue;
            String[] wrns = pr.warnings();
            StringBuffer wrn = new StringBuffer();
            for (int j = 0; j < wrns.length; ++j) {
                wrn.append(j + 1).append(". ").append(wrns[j]).append("\n");
            }
            if (wrn.length() > 0) {
                wrn.deleteCharAt(wrn.length() - 1);
            }
            this.frame.showBaseAt((Integer)location.get(pr));
            JOptionPane.showMessageDialog(this.frame, wrn.toString(), Globals.lang("Warnings"), 2);
        }
    }
}

