/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

class UndoableAddOrRemoveGroup
extends AbstractUndoableEdit {
    private final GroupTreeNode m_groupsRootHandle;
    private final GroupTreeNode m_subtreeBackup;
    private final int m_subtreeRootChildCount;
    private final int[] m_pathToNode;
    private final int m_editType;
    private final GroupSelector m_groupSelector;
    private boolean m_revalidate = true;
    public static final int ADD_NODE = 0;
    public static final int REMOVE_NODE_KEEP_CHILDREN = 1;
    public static final int REMOVE_NODE_AND_CHILDREN = 2;

    public UndoableAddOrRemoveGroup(GroupSelector gs, GroupTreeNode groupsRoot, GroupTreeNode editedNode, int editType) {
        this.m_groupSelector = gs;
        this.m_groupsRootHandle = groupsRoot;
        this.m_editType = editType;
        this.m_subtreeRootChildCount = editedNode.getChildCount();
        this.m_subtreeBackup = editType != 1 ? editedNode.deepCopy() : new GroupTreeNode(editedNode.getGroup().deepCopy());
        this.m_pathToNode = editedNode.getIndexedPath();
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + this.getName();
    }

    public String getName() {
        switch (this.m_editType) {
            case 0: {
                return Globals.lang("add group");
            }
            case 1: {
                return Globals.lang("remove group (keep subgroups)");
            }
            case 2: {
                return Globals.lang("remove group and subgroups");
            }
        }
        return "? (" + Globals.lang("unknown edit") + ")";
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + this.getName();
    }

    public void undo() {
        super.undo();
        this.doOperation(true);
    }

    public void redo() {
        super.redo();
        this.doOperation(false);
    }

    private void doOperation(boolean undo) {
        GroupTreeNode cursor = this.m_groupsRootHandle;
        int childIndex = this.m_pathToNode[this.m_pathToNode.length - 1];
        for (int i = 0; i < this.m_pathToNode.length - 1; ++i) {
            cursor = (GroupTreeNode)cursor.getChildAt(this.m_pathToNode[i]);
        }
        if (undo) {
            switch (this.m_editType) {
                case 0: {
                    cursor.remove(childIndex);
                    break;
                }
                case 1: {
                    GroupTreeNode newNode = this.m_subtreeBackup.deepCopy();
                    for (int i = childIndex; i < childIndex + this.m_subtreeRootChildCount; ++i) {
                        newNode.add((GroupTreeNode)cursor.getChildAt(childIndex));
                    }
                    cursor.insert(newNode, childIndex);
                    break;
                }
                case 2: {
                    cursor.insert(this.m_subtreeBackup.deepCopy(), childIndex);
                }
            }
        } else {
            switch (this.m_editType) {
                case 0: {
                    cursor.insert(this.m_subtreeBackup.deepCopy(), childIndex);
                    break;
                }
                case 1: {
                    GroupTreeNode removedNode = (GroupTreeNode)cursor.getChildAt(childIndex);
                    cursor.remove(childIndex);
                    while (removedNode.getChildCount() > 0) {
                        cursor.insert((GroupTreeNode)removedNode.getFirstChild(), childIndex);
                    }
                    break;
                }
                case 2: {
                    cursor.remove(childIndex);
                }
            }
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void setRevalidate(boolean val) {
        this.m_revalidate = val;
    }
}

