/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.GroupTreeNode;

public class GroupTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final int MAX_DISPLAYED_LETTERS = 35;
    protected Object highlight1Cell = null;
    protected Object[] highlight2Cells = null;
    protected Object[] highlight3Cells = null;
    protected Object highlightBorderCell = null;
    public static ImageIcon groupRefiningIcon = GUIGlobals.getImage("groupRefining");
    public static ImageIcon groupIncludingIcon = GUIGlobals.getImage("groupIncluding");
    public static ImageIcon groupRegularIcon = null;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c;
        block25: {
            JLabel label;
            block24: {
                String name;
                if (value == this.highlight1Cell) {
                    selected = true;
                }
                c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (!(value instanceof GroupTreeNode)) {
                    return c;
                }
                AbstractGroup group = ((GroupTreeNode)value).getGroup();
                if (group == null || !(c instanceof JLabel)) {
                    return c;
                }
                label = (JLabel)c;
                if (this.highlightBorderCell != null && this.highlightBorderCell == value) {
                    label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                } else {
                    label.setBorder(BorderFactory.createEmptyBorder());
                }
                boolean italics = Globals.prefs.getBoolean("groupShowDynamic") && group.isDynamic();
                boolean red = false;
                if (this.highlight2Cells != null) {
                    for (int i = 0; i < this.highlight2Cells.length; ++i) {
                        if (this.highlight2Cells[i] != value) continue;
                        red = true;
                        break;
                    }
                }
                boolean underline = false;
                if (this.highlight3Cells != null) {
                    for (int i = 0; i < this.highlight3Cells.length; ++i) {
                        if (this.highlight3Cells[i] != value) continue;
                        underline = true;
                        break;
                    }
                }
                if ((name = group.getName()).length() > 35) {
                    name = name.substring(0, 33) + "...";
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (red) {
                    sb.append("<font color=\"#FF0000\">");
                }
                if (underline) {
                    sb.append("<u>");
                }
                if (italics) {
                    sb.append("<i>");
                }
                sb.append(Util.quoteForHTML(name));
                if (italics) {
                    sb.append("</i>");
                }
                if (underline) {
                    sb.append("</u>");
                }
                if (red) {
                    sb.append("</font>");
                }
                sb.append("</html>");
                String text = sb.toString();
                if (!label.getText().equals(text)) {
                    label.setText(text);
                }
                label.setToolTipText("<html>" + group.getShortDescription() + "</html>");
                if (!Globals.prefs.getBoolean("groupShowIcons")) break block24;
                switch (group.getHierarchicalContext()) {
                    case 1: {
                        if (label.getIcon() != groupRefiningIcon) {
                            label.setIcon(groupRefiningIcon);
                            break;
                        }
                        break block25;
                    }
                    case 2: {
                        if (label.getIcon() != groupIncludingIcon) {
                            label.setIcon(groupIncludingIcon);
                            break;
                        }
                        break block25;
                    }
                    default: {
                        if (label.getIcon() != groupRegularIcon) {
                            label.setIcon(groupRegularIcon);
                            break;
                        }
                        break block25;
                    }
                }
                break block25;
            }
            label.setIcon(null);
        }
        return c;
    }

    void setHighlight1Cell(Object cell) {
        this.highlight1Cell = cell;
    }

    void setHighlight2Cells(Object[] cells) {
        this.highlight2Cells = cells;
    }

    void setHighlight3Cells(Object[] cells) {
        this.highlight3Cells = cells;
    }

    void setHighlightBorderCell(Object highlightBorderCell) {
        this.highlightBorderCell = highlightBorderCell;
    }
}

