/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.undo.NamedCompound;

class AutoGroupDialog
extends JDialog
implements CaretListener {
    JTextField remove = new JTextField(60);
    JTextField field = new JTextField(60);
    JTextField deliminator = new JTextField(60);
    JLabel nf = new JLabel(Globals.lang("Field to group by") + ":");
    JLabel nr = new JLabel(Globals.lang("Characters to ignore") + ":");
    JRadioButton keywords = new JRadioButton(Globals.lang("Generate groups from keywords in a BibTeX field"));
    JRadioButton authors = new JRadioButton(Globals.lang("Generate groups for author last names"));
    JRadioButton editors = new JRadioButton(Globals.lang("Generate groups for editor last names"));
    JCheckBox nd = new JCheckBox(Globals.lang("Use the following delimiter character(s)") + ":");
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JPanel main = new JPanel();
    JPanel opt = new JPanel();
    private boolean ok_pressed = false;
    private GroupTreeNode m_groupsRoot;
    private JabRefFrame frame;
    private BasePanel panel;
    private GroupSelector gs;
    private String oldRemove;
    private String oldField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public AutoGroupDialog(JabRefFrame jabrefFrame, BasePanel basePanel, GroupSelector groupSelector, GroupTreeNode groupsRoot, String defaultField, String defaultRemove, String defaultDeliminator) {
        super(jabrefFrame, Globals.lang("Automatically create groups"), true);
        this.frame = jabrefFrame;
        this.gs = groupSelector;
        this.panel = basePanel;
        this.m_groupsRoot = groupsRoot;
        this.field.setText(defaultField);
        this.remove.setText(defaultRemove);
        this.deliminator.setText(defaultDeliminator);
        this.nd.setSelected(true);
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrayList<String> fields;
                AutoGroupDialog.this.ok_pressed = true;
                AutoGroupDialog.this.dispose();
                GroupTreeNode autoGroupsRoot = new GroupTreeNode(new ExplicitGroup(Globals.lang("Automatically created groups"), 2));
                Set<String> hs = null;
                String field = AutoGroupDialog.this.field();
                if (AutoGroupDialog.this.keywords.isSelected()) {
                    hs = AutoGroupDialog.this.nd.isSelected() ? Util.findDeliminatedWordsInField(AutoGroupDialog.this.panel.getDatabase(), AutoGroupDialog.this.field().toLowerCase().trim(), AutoGroupDialog.this.deliminator.getText()) : Util.findAllWordsInField(AutoGroupDialog.this.panel.getDatabase(), AutoGroupDialog.this.field().toLowerCase().trim(), AutoGroupDialog.this.remove());
                } else if (AutoGroupDialog.this.authors.isSelected()) {
                    fields = new ArrayList<String>(2);
                    fields.add("author");
                    hs = Util.findAuthorLastNames(AutoGroupDialog.this.panel.getDatabase(), fields);
                    field = "author";
                } else if (AutoGroupDialog.this.editors.isSelected()) {
                    fields = new ArrayList(2);
                    fields.add("editor");
                    hs = Util.findAuthorLastNames(AutoGroupDialog.this.panel.getDatabase(), fields);
                    field = "editor";
                }
                for (String keyword : hs) {
                    KeywordGroup group = new KeywordGroup(keyword, field, keyword, false, false, 0);
                    autoGroupsRoot.add(new GroupTreeNode(group));
                }
                AutoGroupDialog.this.m_groupsRoot.add(autoGroupsRoot);
                NamedCompound ce = new NamedCompound(Globals.lang("Autogenerate groups"));
                UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(AutoGroupDialog.this.gs, AutoGroupDialog.this.m_groupsRoot, autoGroupsRoot, 0);
                undo.setRevalidate(true);
                ce.addEdit(undo);
                AutoGroupDialog.this.panel.markBaseChanged();
                AutoGroupDialog.this.gs.revalidateGroups();
                AutoGroupDialog.this.frame.output(Globals.lang("Created groups."));
                ce.end();
                ((AutoGroupDialog)AutoGroupDialog.this).panel.undoManager.addEdit(ce);
            }
        };
        this.remove.addActionListener(okListener);
        this.field.addActionListener(okListener);
        this.field.addCaretListener(this);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AutoGroupDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        this.ok.addActionListener(okListener);
        ActionMap am = this.main.getActionMap();
        InputMap im = this.main.getInputMap(2);
        im.put(this.frame.prefs().getKey("Close dialog"), "close");
        am.put("close", cancelAction);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.keywords);
        bg.add(this.authors);
        bg.add(this.editors);
        this.keywords.setSelected(true);
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:20dlu, 4dlu, left:pref, 4dlu, fill:60dlu, 4dlu, fill:0dlu", ""), this.main);
        b.append((Component)this.keywords, 5);
        b.nextLine();
        b.append(new JPanel());
        b.append(Globals.lang("Field to group by") + ":");
        b.append(this.field);
        b.nextLine();
        b.append(new JPanel());
        b.append(Globals.lang("Characters to ignore") + ":");
        b.append(this.remove);
        b.nextLine();
        b.append(new JPanel());
        b.append(this.nd);
        b.append(this.deliminator);
        b.nextLine();
        b.append((Component)this.authors, 5);
        b.nextLine();
        b.append((Component)this.editors, 5);
        b.nextLine();
        ButtonBarBuilder bb = new ButtonBarBuilder(this.opt);
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addGlue();
        this.main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.opt.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.opt, "South");
        this.updateComponents();
        this.pack();
        Util.placeDialog(this, this.frame);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldRemove() {
        return this.oldRemove;
    }

    public String field() {
        return this.field.getText();
    }

    public String remove() {
        return this.remove.getText();
    }

    public void caretUpdate(CaretEvent e) {
        this.updateComponents();
    }

    protected void updateComponents() {
        String groupField = this.field.getText().trim();
        this.ok.setEnabled(groupField.matches("\\w+"));
    }
}

