/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToLyx
implements PushToApplication {
    private JTextField lyxPipe = new JTextField(30);
    private JPanel settings = null;
    private boolean couldNotFindPipe = false;
    private boolean couldNotWrite = false;
    private String message = "";

    public void pushEntries(BibtexDatabase database, BibtexEntry[] entries, final String keyString, MetaData metaData) {
        File lp;
        this.couldNotFindPipe = false;
        this.couldNotWrite = false;
        String lyxpipeSetting = Globals.prefs.get("lyxpipe");
        if (!lyxpipeSetting.endsWith(".in")) {
            lyxpipeSetting = lyxpipeSetting + ".in";
        }
        if (!((lp = new File(lyxpipeSetting)).exists() && lp.canWrite() || (lp = new File(lyxpipeSetting + ".in")).exists() && lp.canWrite())) {
            this.couldNotFindPipe = true;
            return;
        }
        final File lyxpipe = lp;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    FileWriter fw = new FileWriter(lyxpipe);
                    BufferedWriter lyx_out = new BufferedWriter(fw);
                    String citeStr = "";
                    citeStr = "LYXCMD:sampleclient:citation-insert:" + keyString;
                    lyx_out.write(citeStr + "\n");
                    lyx_out.close();
                }
                catch (IOException excep) {
                    PushToLyx.this.couldNotWrite = true;
                    return;
                }
            }
        });
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return Globals.lang("Insert selected citations into LyX/Kile");
    }

    public String getApplicationName() {
        return "LyX/Kile";
    }

    public String getTooltip() {
        return Globals.lang("Push selection to LyX/Kile");
    }

    public Icon getIcon() {
        return GUIGlobals.getImage("lyx");
    }

    public String getKeyStrokeName() {
        return "Push to LyX";
    }

    public void operationCompleted(BasePanel panel) {
        if (this.couldNotFindPipe) {
            panel.output(Globals.lang("Error") + ": " + Globals.lang("verify that LyX is running and that the lyxpipe is valid") + ". [" + Globals.prefs.get("lyxpipe") + "]");
        } else if (this.couldNotWrite) {
            panel.output(Globals.lang("Error") + ": " + Globals.lang("unable to write to") + " " + Globals.prefs.get("lyxpipe") + ".in");
        } else {
            panel.output(Globals.lang("Pushed the citations for the following rows to") + " Lyx: " + this.message);
        }
    }

    public boolean requiresBibtexKeys() {
        return true;
    }

    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.lyxPipe.setText(Globals.prefs.get("lyxpipe"));
        return this.settings;
    }

    public void storeSettings() {
        Globals.prefs.put("lyxpipe", this.lyxPipe.getText());
    }

    private void initSettingsPanel() {
        this.settings = new JPanel();
        this.settings.add(new JLabel(Globals.lang("Path to LyX pipe") + ":"));
        this.settings.add(this.lyxPipe);
    }
}

