/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToEmacs
implements PushToApplication {
    private JPanel settings = null;
    private JTextField citeCommand = new JTextField(30);
    private boolean couldNotConnect = false;
    private boolean couldNotRunClient = false;

    public String getName() {
        return Globals.menuTitle("Insert selected citations into Emacs");
    }

    public String getApplicationName() {
        return "Emacs";
    }

    public String getTooltip() {
        return Globals.lang("Push selection to Emacs");
    }

    public Icon getIcon() {
        return GUIGlobals.getImage("emacs");
    }

    public String getKeyStrokeName() {
        return "Push to Emacs";
    }

    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.citeCommand.setText(Globals.prefs.get("citeCommandEmacs"));
        return this.settings;
    }

    public void storeSettings() {
        Globals.prefs.put("citeCommandEmacs", this.citeCommand.getText());
    }

    private void initSettingsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        builder.append(Globals.lang("Cite command") + ":");
        builder.append(this.citeCommand);
        this.settings = builder.getPanel();
    }

    public void pushEntries(BibtexDatabase database, BibtexEntry[] entries, String keys, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotRunClient = false;
        try {
            String[] stringArray;
            if (Globals.ON_WIN) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "gnuclient";
                stringArray2[1] = "-qe";
                stringArray = stringArray2;
                stringArray2[2] = "(insert \\\"\\\\" + Globals.prefs.get("citeCommandEmacs").replaceAll("\\\\", "\\\\\\\\") + "{" + keys + "}\\\")";
            } else {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "gnuclient";
                stringArray3[1] = "-batch";
                stringArray3[2] = "-eval";
                stringArray = stringArray3;
                stringArray3[3] = "(insert \"" + Globals.prefs.get("citeCommandEmacs").replaceAll("\\\\", "\\\\\\\\") + "{" + keys + "}\")";
            }
            String[] com = stringArray;
            final Process p = Runtime.getRuntime().exec(com);
            Runnable errorListener = new Runnable(){

                public void run() {
                    InputStream out = p.getErrorStream();
                    StringBuffer sb = new StringBuffer();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (sb.toString().trim().length() > 0) {
                        System.out.println(sb.toString());
                        PushToEmacs.this.couldNotConnect = true;
                        return;
                    }
                }
            };
            Thread t = new Thread(errorListener);
            t.start();
            t.join();
        }
        catch (IOException excep) {
            this.couldNotRunClient = true;
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(panel.frame(), "<HTML>" + Globals.lang("Could not connect to a running gnuserv process. Make sure that Emacs or XEmacs is running,<BR>and that the server has been started (by running the command 'gnuserv-start').") + "</HTML>", Globals.lang("Error"), 0);
        } else if (this.couldNotRunClient) {
            JOptionPane.showMessageDialog(panel.frame(), Globals.lang("Could not run the 'gnuclient' program. Make sure you have the gnuserv/gnuclient programs installed."), Globals.lang("Error"), 0);
        } else {
            panel.output(Globals.lang("Pushed citations to Emacs"));
        }
    }

    public boolean requiresBibtexKeys() {
        return true;
    }
}

