/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.ExportFormat;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;
import net.sf.jabref.msbib.MSBibDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MSBibExportFormat
extends ExportFormat {
    public MSBibExportFormat() {
        super(Globals.lang("MS Office 2007"), "MSBib", null, null, ".xml");
    }

    @Override
    public void performExport(BibtexDatabase database, MetaData metaData, String file, String encoding, Set<String> keySet) throws IOException {
        SaveSession ss = this.getSaveSession("UTF8", new File(file));
        VerifyingWriter ps = ss.getWriter();
        MSBibDatabase md = new MSBibDatabase(database, keySet);
        try {
            DOMSource source = new DOMSource(md.getDOMrepresentation());
            StreamResult result = new StreamResult(ps);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.transform(source, result);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        try {
            this.finalizeSaveSession(ss);
        }
        catch (SaveException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

