/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.export.CustomExportDialog;

public class ExportCustomizationDialog
extends JDialog {
    JabRefFrame frame;
    JButton addExport = new JButton(Globals.lang("Add new"));
    JButton modify = new JButton(Globals.lang("Modify"));
    JButton remove = new JButton(Globals.lang("Remove"));
    JButton close = new JButton(Globals.lang("Close"));
    JButton help = new JButton(Globals.lang("Help"));
    JPanel buttons = new JPanel();
    JPanel main = new JPanel();
    JTable table;

    public ExportCustomizationDialog(JabRefFrame frame_) throws HeadlessException {
        super(frame_, Globals.lang("Manage custom exports"), false);
        this.frame = frame_;
        this.addExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomExportDialog ecd = new CustomExportDialog(ExportCustomizationDialog.this.frame);
                ecd.setVisible(true);
                if (ecd.okPressed()) {
                    String[] newFormat = new String[]{ecd.name(), ecd.layoutFile(), ecd.extension()};
                    Globals.prefs.customExports.addFormat(newFormat);
                    Globals.prefs.customExports.store();
                }
            }
        });
        this.modify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ExportCustomizationDialog.this.table.getSelectedRow();
                if (row == -1) {
                    return;
                }
                String[] old = (String[])Globals.prefs.customExports.getSortedList().get(row);
                CustomExportDialog ecd = new CustomExportDialog(ExportCustomizationDialog.this.frame, old[0], old[1], old[2]);
                ecd.setVisible(true);
                if (ecd.okPressed()) {
                    old[0] = ecd.name();
                    old[1] = ecd.layoutFile();
                    old[2] = ecd.extension();
                    ExportCustomizationDialog.this.table.revalidate();
                    ExportCustomizationDialog.this.table.repaint();
                    Globals.prefs.customExports.store();
                }
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i;
                int[] rows = ExportCustomizationDialog.this.table.getSelectedRows();
                if (rows.length == 0) {
                    return;
                }
                String[][] entries = new String[rows.length][];
                for (i = 0; i < rows.length; ++i) {
                    entries[i] = (String[])Globals.prefs.customExports.getSortedList().get(rows[i]);
                }
                for (i = 0; i < rows.length; ++i) {
                    Globals.prefs.customExports.remove(entries[i]);
                }
                Globals.prefs.customExports.store();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ExportCustomizationDialog.this.dispose();
            }
        };
        this.close.addActionListener(closeAction);
        this.help.addActionListener(new HelpAction(this.frame.helpDiag, GUIGlobals.exportCustomizationHelp, "Help"));
        EventTableModel<String[]> tableModel = new EventTableModel<String[]>(Globals.prefs.customExports.getSortedList(), new ExportTableFormat());
        this.table = new JTable(tableModel);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(50);
        cm.getColumn(1).setPreferredWidth(200);
        cm.getColumn(2).setPreferredWidth(30);
        JScrollPane sp = new JScrollPane(this.table, 20, 31);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        ActionMap am = this.main.getActionMap();
        InputMap im = this.main.getInputMap(2);
        im.put(this.frame.prefs().getKey("Close dialog"), "close");
        am.put("close", closeAction);
        this.main.setLayout(new BorderLayout());
        this.main.add((Component)sp, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addGridded(this.addExport);
        bb.addGridded(this.modify);
        bb.addGridded(this.remove);
        bb.addGridded(this.close);
        bb.addUnrelatedGap();
        bb.addGridded(this.help);
        bb.addGlue();
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.pack();
        Util.placeDialog(this, this.frame);
        new FocusRequester(this.table);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExportTableFormat
    implements TableFormat<String[]> {
        ExportTableFormat() {
        }

        @Override
        public Object getColumnValue(String[] strings, int i) {
            return strings[i];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Globals.lang("Export name");
                }
                case 1: {
                    return Globals.lang("Main layout file");
                }
            }
            return Globals.lang("File extension");
        }
    }
}

