/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Worker;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.util.ResourceExtractor;
import spin.Spin;

public class ExpandEndnoteFilters
extends MnemonicAwareAction
implements Worker {
    JabRefFrame frame;
    File file = null;
    final String FILENAME = "/EndNote.zip";

    public ExpandEndnoteFilters(JabRefFrame frame) {
        this.frame = frame;
        this.putValue("Name", "Unpack EndNote filter set");
        this.putValue("ShortDescription", Globals.lang("<HTML>Unpack the zip file containing import/export filters for Endnote,<BR>for optimal interoperability with JabRef</HTML>"));
    }

    public void actionPerformed(ActionEvent e) {
        int confirm;
        String filename = FileDialogs.getNewFile(this.frame, new File(System.getProperty("user.home")), ".zip", 1, false);
        if (filename == null) {
            return;
        }
        this.file = new File(filename);
        if (this.file.exists() && (confirm = JOptionPane.showConfirmDialog(this.frame, "'" + this.file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Unpack EndNote filter set"), 2)) != 0) {
            return;
        }
        ((Worker)Spin.off(this)).run();
        this.file = null;
    }

    public void run() {
        ResourceExtractor re = new ResourceExtractor(this.frame, "/EndNote.zip", this.file);
        re.run();
        this.frame.output(Globals.lang("Unpacked file."));
    }
}

