/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;

public class NameFieldAutoCompleter
extends AbstractAutoCompleter {
    private String _fieldName;

    protected NameFieldAutoCompleter(String fieldName) {
        this._fieldName = fieldName;
    }

    public boolean isSingleUnitField() {
        return false;
    }

    public void addBibtexEntry(String fieldValue, BibtexEntry entry) {
        this.addBibtexEntry(entry);
    }

    public void addBibtexEntry(BibtexEntry entry) {
        String fieldValue;
        if (entry != null && (fieldValue = entry.getField(this._fieldName)) != null) {
            AuthorList authorList = AuthorList.getAuthorList(fieldValue);
            for (int i = 0; i < authorList.size(); ++i) {
                AuthorList.Author author = authorList.getAuthor(i);
                this.addWordToIndex(author.getLastFirst(true));
                this.addWordToIndex(author.getLastFirst(false));
                this.addWordToIndex(author.getFirstLast(true));
                this.addWordToIndex(author.getFirstLast(false));
            }
        }
    }

    public String[] complete(String str) {
        return super.complete(str);
    }

    public String getFieldName() {
        return this._fieldName;
    }
}

