/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.about;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.about.AboutTextLine;
import net.sf.jabref.about.AnimationListener;
import net.sf.jabref.about.TextBlock;

public class AboutPanel
extends JComponent {
    private Vector<TextBlock> textBlocks;
    private String versionStr;
    private String buildStr;
    private AnimationThread thread;
    private ImageIcon image;
    public int TOP = 300;
    public int BOTTOM = 0;
    public int HEIGHT = 500;
    public int WIDTH = 500;
    private int[] borders;
    private int paintWidth;
    private Font font1;
    private Font font2;
    private Font font3;
    private AnimationListener aniListener;
    private ImageProducer iProducer;

    AboutPanel() {
        Font font = this.loadFont("ASTROLYT.TTF");
        this.font1 = font.deriveFont(1, 14.0f);
        this.font2 = font.deriveFont(1, 20.0f);
        font = this.loadFont("AUGIE.TTF");
        this.font3 = font.deriveFont(1, 14.0f);
        this.versionStr = "Version " + Globals.VERSION;
        this.buildStr = " build " + Globals.BUILD;
        this.image = new ImageIcon(this.getClass().getResource("/images/autumn.png"));
        this.HEIGHT = this.image.getIconHeight();
        this.WIDTH = this.image.getIconWidth();
        FontMetrics fm = this.getFontMetrics(this.font2);
        this.TOP = 2 * fm.getHeight();
        fm = this.getFontMetrics(this.font1);
        this.BOTTOM = 2 * fm.getHeight();
        this.borders = new int[4];
        this.borders[0] = 0;
        this.borders[1] = this.WIDTH;
        this.borders[2] = this.TOP;
        this.borders[3] = this.HEIGHT - this.TOP - this.BOTTOM;
        this.paintWidth = this.borders[1] - this.borders[0];
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.textBlocks = new Vector(50);
        this.loadAboutText();
        this.setDoubleBuffered(true);
        this.thread = new AnimationThread();
    }

    public void addAnimationListener(AnimationListener listener) {
        this.aniListener = listener;
    }

    private int getMiddleX(String text, Font font) {
        FontMetrics fm = this.getFontMetrics(font);
        return this.paintWidth / 2 - (fm.stringWidth(text) + 10) / 2;
    }

    private Font loadFont(String fontName) {
        Font back = UIManager.getFont("Label.font");
        try {
            InputStream myStream = this.getClass().getResourceAsStream(GUIGlobals.fontPath + fontName);
            back = Font.createFont(0, myStream);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return back;
    }

    private final void loadAboutText() {
        TextBlock block = null;
        AboutTextLine aLine = null;
        int index = -3;
        FontMetrics fm = this.getFontMetrics(this.font3);
        try {
            InputStream stream = this.getClass().getResourceAsStream(GUIGlobals.getLocaleHelpPath() + "credits.txt");
            if (stream == null) {
                stream = this.getClass().getResourceAsStream(GUIGlobals.helpPre + "credits.txt");
            }
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader input = new BufferedReader(reader, 1000);
            while (input.ready()) {
                String line = input.readLine();
                if (line == null || (line = line.trim()).length() <= 0) continue;
                if (line.charAt(0) == '#') {
                    if (block != null) {
                        this.textBlocks.add(block);
                        index += 2;
                    }
                    aLine = new AboutTextLine(line.substring(1).trim());
                    aLine.setTag(2);
                    aLine.setPos(this.getMiddleX(aLine.getText(), this.font2), (double)this.borders[0] - (double)(fm.getHeight() * (index + 3)) * 1.5);
                    aLine.setDirection(0.0, 1.0);
                    aLine.setFont(this.font2);
                    block = new TextBlock();
                    block.setHeading(aLine);
                    block.setVisible(true);
                    continue;
                }
                aLine = new AboutTextLine(line.trim());
                aLine.setPos(this.getMiddleX(line, this.font3), (double)this.borders[3] + (double)(index * fm.getHeight()) * 1.5);
                aLine.setTag(10);
                aLine.setDirection(0.0, -1.0);
                aLine.setFont(this.font3);
                block = new TextBlock();
                block.add(aLine);
                block.setVisible(true);
                ++index;
            }
            input.close();
        }
        catch (Exception e) {
            block = new TextBlock();
            block.setHeading(new AboutTextLine("failure"));
            String line = "no infos available";
            aLine = new AboutTextLine(line);
            block.add(aLine);
        }
        this.textBlocks.add(block);
    }

    public void paintComponent(Graphics g) {
        if (this.thread.mode == 0) {
            this.thread.start();
        } else if (this.thread.mode == 1) {
            this.image.paintIcon(this, g, 0, 0);
            FontMetrics fm = g.getFontMetrics(this.font1);
            int x1 = (this.getWidth() - fm.stringWidth(this.versionStr)) / 2;
            int y1 = this.getHeight() - fm.getHeight() - 4;
            int y2 = this.getHeight() - 5;
            g.setFont(this.font1);
            g.setColor(Color.black);
            g.drawString(this.versionStr, x1, y1);
            g.drawString(this.buildStr, x1, y2);
            g.setFont(this.font2);
            fm = g.getFontMetrics(this.font2);
            g.drawString("JabRef", (this.getWidth() - fm.stringWidth("JabRef")) / 2, fm.getHeight() + 10);
            for (TextBlock block : this.textBlocks) {
                if (!block.isVisible()) continue;
                AboutTextLine head = block.getHeading();
                this.drawLine(head, g);
                for (AboutTextLine line : block) {
                    this.drawLine(line, g);
                }
            }
        } else {
            this.image.paintIcon(this, g, 0, 0);
        }
    }

    private void drawLine(AboutTextLine line, Graphics g) {
        int x = line.getPosX();
        int y = line.getPosY();
        if (x > this.borders[0] - 10 && x < this.borders[1] + 10 && y > this.borders[2] - 10 && y < this.borders[3] + 10 && line.getVisible()) {
            g.setFont(line.getFont());
            g.setColor(line.getColor());
            g.drawString(line.getText(), line.getPosX(), line.getPosY());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.WIDTH, this.HEIGHT);
    }

    public void removeNotify() {
        super.removeNotify();
        this.thread.kill();
    }

    public void skipAnimation() {
        this.thread.kill();
        if (this.aniListener != null) {
            this.aniListener.animationReady();
        }
    }

    class AnimationThread
    extends Thread {
        private boolean running;
        private double help01;
        private int mode;
        public int sleepTime;
        private int zone2Counter;
        private boolean runMode;

        AnimationThread() {
            super("About box animation thread");
            this.running = true;
            this.help01 = 1.0;
            this.mode = 0;
            this.sleepTime = 50;
            this.zone2Counter = 0;
            this.runMode = true;
            this.setPriority(1);
        }

        public void kill() {
            this.running = false;
        }

        public void setEnabled(boolean onOff) {
            this.runMode = onOff;
        }

        public synchronized void setMode(int newMode) {
            this.mode = newMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object mutex = new Object();
            this.mode = 1;
            this.runMode = true;
            while (this.running) {
                Object object = mutex;
                synchronized (object) {
                    try {
                        do {
                            mutex.wait(this.sleepTime);
                        } while (!this.runMode);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.mode == 1) {
                    int counter = 0;
                    Enumeration myE = AboutPanel.this.textBlocks.elements();
                    while (myE.hasMoreElements()) {
                        TextBlock block = (TextBlock)myE.nextElement();
                        AboutTextLine head = block.getHeading();
                        counter = this.performStep(head);
                        for (AboutTextLine line : block) {
                            counter += this.performStep(line);
                        }
                    }
                    if (counter < 1) {
                        this.mode = 2;
                    }
                    AboutPanel.this.repaint(AboutPanel.this.borders[0] - 10, AboutPanel.this.borders[2] - 10, AboutPanel.this.borders[1] + 10, AboutPanel.this.borders[3] + 10);
                    continue;
                }
                if (this.mode != 2) continue;
                this.sleepTime = this.sleepTime < 2 ? 5 : (this.sleepTime -= this.sleepTime / 3);
                AboutPanel.this.image.setImage(AboutPanel.this.createImage(AboutPanel.this.iProducer));
                AboutPanel.this.repaint(0, 0, AboutPanel.this.WIDTH, AboutPanel.this.HEIGHT);
            }
        }

        private int performStep(AboutTextLine line) {
            int back = 0;
            line.performTimeStep(1.0);
            if (line.getTag() == 2) {
                int zone = (int)((double)AboutPanel.this.HEIGHT / 3.5);
                if (line.getPosY() > zone) {
                    line.setSpeed(0.0);
                    line.setTag(4);
                    this.zone2Counter = 0;
                } else if (line.getPosY() > zone - 10) {
                    this.zone2Counter = 1;
                }
                ++back;
            } else if (line.getTag() == 4) {
                if (this.zone2Counter < 1) {
                    Color col = line.getColor();
                    int rgb = col.getRGB() + 1023;
                    line.setColor(new Color(rgb));
                } else {
                    line.setVisible(false);
                    line.setTag(5);
                }
            } else if (line.getTag() == 10) {
                if (line.getPosY() < AboutPanel.this.HEIGHT / 3) {
                    line.setDirection(this.help01, 0.0);
                    line.setAccel(0.5);
                    line.setTag(11);
                    this.help01 *= -1.0;
                }
                back = 1;
            } else if (line.getTag() == 11) {
                if (line.getPosX() < -100 || line.getPosX() > AboutPanel.this.WIDTH + 100) {
                    line.setTag(12);
                    line.setVisible(false);
                }
                back = 1;
            }
            return back;
        }
    }
}

