/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CallBack;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.Worker;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.ExternalFileTypeEntryEditor;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.imports.CiteSeerFetcher;
import net.sf.jabref.imports.FieldContentParser;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static SimpleDateFormat dateFormatter = null;
    public static Color fieldsCol = new Color(180, 180, 200);
    static final int TYPE_MISMATCH = -1;
    static final int NOT_EQUAL = 0;
    static final int EQUAL = 1;
    static final int EMPTY_IN_ONE = 2;
    static final int EMPTY_IN_TWO = 3;
    static final int EMPTY_IN_BOTH = 4;
    static final NumberFormat idFormat;
    public static Pattern remoteLinkPattern;
    public static int MARK_COLOR_LEVELS;
    public static int MAX_MARKING_LEVEL;
    public static int IMPORT_MARK_LEVEL;
    public static Pattern markNumberPattern;
    private static int idCounter;
    static Pattern squareBracketsPattern;
    static Pattern titleCapitalPattern;
    static Pattern bracedTitleCapitalPattern;
    public static int thisYear;

    public static int getMinimumIntegerDigits() {
        return idFormat.getMinimumIntegerDigits();
    }

    public static void bool(boolean b) {
        if (b) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }

    public static void pr(String s) {
        System.out.println(s);
    }

    public static void pr_(String s) {
        System.out.print(s);
    }

    public static String nCase(String s) {
        if (s.length() > 1) {
            return s.substring(0, 1).toUpperCase() + s.substring(1, s.length()).toLowerCase();
        }
        return s.toUpperCase();
    }

    public static String checkName(String s) {
        if (s.length() < 4 || !s.substring(s.length() - 4).equalsIgnoreCase(".bib")) {
            return s + ".bib";
        }
        return s;
    }

    public static synchronized String createNeutralId() {
        return idFormat.format(idCounter++);
    }

    public static void placeDialog(Dialog diag, Container win) {
        diag.setLocationRelativeTo(win);
    }

    public static String parseField(String content) {
        if (content.length() == 0) {
            return content;
        }
        String[] strings = content.split("#");
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            String s = strings[i].trim();
            if (s.length() <= 0) continue;
            char c = s.charAt(0);
            if (c == '{' || c == '\"') {
                result.append(Util.shaveString(strings[i]));
                continue;
            }
            String s2 = Util.shaveString(s);
            try {
                Integer.parseInt(s2);
                result.append(s2);
                continue;
            }
            catch (NumberFormatException ex) {
                result.append("#").append(s2).append("#");
            }
        }
        return result.toString();
    }

    public static String getPublicationDate(BibtexEntry entry) {
        int month;
        String o = entry.getField("year");
        if (o == null) {
            return null;
        }
        String year = Util.toFourDigitYear(o.toString());
        o = entry.getField("month");
        if (o != null && (month = Util.getMonthNumber(o.toString())) != -1) {
            return year + "-" + (month + 1 < 10 ? "0" : "") + (month + 1);
        }
        return year;
    }

    public static String shaveString(String s) {
        char ch;
        if (s == null) {
            return null;
        }
        int beg = 0;
        int end = s.length();
        boolean begok = false;
        boolean endok = false;
        while (!begok) {
            if (beg < s.length()) {
                ch = s.charAt(beg);
                if (Character.isWhitespace(ch)) {
                    ++beg;
                    continue;
                }
                begok = true;
                continue;
            }
            begok = true;
        }
        while (!endok) {
            if (end > beg + 1) {
                ch = s.charAt(end - 1);
                if (Character.isWhitespace(ch)) {
                    --end;
                    continue;
                }
                endok = true;
                continue;
            }
            endok = true;
        }
        if (end > beg + 1) {
            ch = s.charAt(beg);
            char ch2 = s.charAt(end - 1);
            if (ch == '{' && ch2 == '}' || ch == '\"' && ch2 == '\"') {
                ++beg;
                --end;
            }
        }
        s = s.substring(beg, end);
        return s;
    }

    public static String checkLegalKey(String key) {
        if (key == null) {
            return null;
        }
        if (!Globals.prefs.getBoolean("enforceLegalBibtexKey")) {
            StringBuilder newKey = new StringBuilder();
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (Character.isWhitespace(c) || c == '{' || c == '\\' || c == '\"' || c == '}' || c == ',') continue;
                newKey.append(c);
            }
            return newKey.toString();
        }
        StringBuilder newKey = new StringBuilder();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isWhitespace(c) || c == '#' || c == '{' || c == '\\' || c == '\"' || c == '}' || c == '~' || c == ',' || c == '^' || c == '\'') continue;
            newKey.append(c);
        }
        String newKeyS = Util.replaceSpecialCharacters(newKey.toString());
        return newKeyS;
    }

    public static String replaceSpecialCharacters(String s) {
        for (Map.Entry<String, String> chrAndReplace : Globals.UNICODE_CHARS.entrySet()) {
            s = s.replaceAll(chrAndReplace.getKey(), chrAndReplace.getValue());
        }
        return s;
    }

    public static String _wrap2(String in, int wrapAmount) {
        StringBuffer out = new StringBuffer(in.replaceAll("[ \\t\\r]+", " "));
        int p = in.length() - wrapAmount;
        int lastInserted = -1;
        while (p > 0 && (p = out.lastIndexOf(" ", p)) > 0 && p > 20) {
            int lbreak = out.indexOf("\n", p);
            System.out.println(lbreak + " " + lastInserted);
            if (lbreak > p && lastInserted >= 0 && lbreak < lastInserted) {
                p = lbreak - wrapAmount;
                continue;
            }
            out.insert(p, "\n\t");
            lastInserted = p;
            p -= wrapAmount;
        }
        return out.toString();
    }

    public static String wrap2(String in, int wrapAmount) {
        return FieldContentParser.wrap(in, wrapAmount);
    }

    public static String __wrap2(String in, int wrapAmount) {
        int q;
        StringBuffer out = new StringBuffer(in.replaceAll("[ \\t\\r]+", " "));
        int p = 0;
        while (p < out.length() && (q = out.indexOf(" ", p + wrapAmount)) >= 0 && q < out.length()) {
            int lbreak = out.indexOf("\n", p);
            if (lbreak > p && lbreak < q) {
                p = lbreak + 1;
                int piv = lbreak + 1;
                if (out.length() <= piv || out.charAt(piv) == '\t') continue;
                out.insert(piv, "\n\t");
                continue;
            }
            out.deleteCharAt(q);
            out.insert(q, "\n\t");
            p = q + 1;
        }
        return out.toString();
    }

    public static TreeSet<String> findDeliminatedWordsInField(BibtexDatabase db, String field, String deliminator) {
        TreeSet<String> res = new TreeSet<String>();
        for (String s : db.getKeySet()) {
            BibtexEntry be = db.getEntryById(s);
            String o = be.getField(field);
            if (o == null) continue;
            String fieldValue = o.toString().trim();
            StringTokenizer tok = new StringTokenizer(fieldValue, deliminator);
            while (tok.hasMoreTokens()) {
                res.add(Util.nCase(tok.nextToken().trim()));
            }
        }
        return res;
    }

    public static TreeSet<String> findAllWordsInField(BibtexDatabase db, String field, String remove) {
        TreeSet<String> res = new TreeSet<String>();
        for (String s : db.getKeySet()) {
            BibtexEntry be = db.getEntryById(s);
            String o = be.getField(field);
            if (o == null) continue;
            StringTokenizer tok = new StringTokenizer(o.toString(), remove, false);
            while (tok.hasMoreTokens()) {
                res.add(Util.nCase(tok.nextToken().trim()));
            }
        }
        return res;
    }

    public static Set<String> findAuthorLastNames(BibtexDatabase db, List<String> fields) {
        TreeSet<String> res = new TreeSet<String>();
        for (String s : db.getKeySet()) {
            BibtexEntry be = db.getEntryById(s);
            for (String field : fields) {
                String val = be.getField(field);
                if (val == null || val.length() <= 0) continue;
                AuthorList al = AuthorList.getAuthorList(val);
                for (int i = 0; i < al.size(); ++i) {
                    AuthorList.Author a = al.getAuthor(i);
                    String lastName = a.getLast();
                    if (lastName == null || lastName.length() <= 0) continue;
                    res.add(lastName);
                }
            }
        }
        return res;
    }

    public static String stringArrayToDelimited(String[] strs, String delimiter) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        if (strs.length == 1) {
            return strs[0];
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.length - 1; ++i) {
            sb.append(strs[i]);
            sb.append(delimiter);
        }
        sb.append(strs[strs.length - 1]);
        return sb.toString();
    }

    public static String[] delimToStringArray(String names, String delimiter) {
        if (names == null) {
            return null;
        }
        return names.split(delimiter);
    }

    public static void openExternalViewer(MetaData metaData, String link, String fieldName) throws IOException {
        block35: {
            String[] cmdArray;
            String viewer;
            ExternalFileType type;
            String[] cmd;
            if (fieldName.equals("ps") || fieldName.equals("pdf")) {
                String dir = metaData.getFileDirectory(fieldName);
                File file = Util.expandFilename(link, new String[]{dir, "."});
                if (file == null || !file.exists()) {
                    throw new IOException(Globals.lang("File not found") + " (" + fieldName + "): '" + link + "'.");
                }
                link = file.getCanonicalPath();
                String[] split = file.getName().split("\\.");
                if (split.length >= 2) {
                    if (split[split.length - 1].equalsIgnoreCase("pdf")) {
                        fieldName = "pdf";
                    } else if (split[split.length - 1].equalsIgnoreCase("ps") || split.length >= 3 && split[split.length - 2].equalsIgnoreCase("ps")) {
                        fieldName = "ps";
                    }
                }
            } else if (fieldName.equals("doi")) {
                fieldName = "url";
                if (!(link = Util.sanitizeUrl(link)).startsWith("http://")) {
                    if (link.matches("^doi:/*.*")) {
                        link = link.replaceFirst("^doi:/*", "");
                    }
                    link = "http://dx.doi.org/" + link;
                }
            } else if (fieldName.equals("citeseerurl")) {
                fieldName = "url";
                String canonicalLink = CiteSeerFetcher.generateCanonicalURL(link);
                if (canonicalLink != null) {
                    link = canonicalLink;
                }
            }
            if (fieldName.equals("url")) {
                try {
                    link = Util.sanitizeUrl(link);
                    ExternalFileType fileType = Globals.prefs.getExternalFileTypeByExt("html");
                    if (Globals.ON_MAC) {
                        String[] stringArray;
                        if (fileType.getOpenWith() != null && fileType.getOpenWith().length() > 0) {
                            String[] stringArray2 = new String[4];
                            stringArray2[0] = "/usr/bin/open";
                            stringArray2[1] = "-a";
                            stringArray2[2] = fileType.getOpenWith();
                            stringArray = stringArray2;
                            stringArray2[3] = link;
                        } else {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = "/usr/bin/open";
                            stringArray = stringArray3;
                            stringArray3[1] = link;
                        }
                        String[] cmd2 = stringArray;
                        Runtime.getRuntime().exec(cmd2);
                        break block35;
                    }
                    if (Globals.ON_WIN) {
                        if (fileType.getOpenWith() != null && fileType.getOpenWith().length() > 0) {
                            Util.openFileWithApplicationOnWindows(link, fileType.getOpenWith());
                        } else {
                            Util.openFileOnWindows(link, true);
                        }
                        break block35;
                    }
                    String[] openWith = fileType.getOpenWith() != null && fileType.getOpenWith().length() > 0 ? fileType.getOpenWith().split(" ") : new String[]{"xdg-open"};
                    cmd = new String[openWith.length + 1];
                    System.arraycopy(openWith, 0, cmd, 0, openWith.length);
                    cmd[cmd.length - 1] = link;
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    System.err.println(Globals.lang("Error_opening_file_'%0'.", link));
                    e.printStackTrace();
                }
            } else if (fieldName.equals("ps")) {
                try {
                    if (Globals.ON_MAC) {
                        type = Globals.prefs.getExternalFileTypeByExt("ps");
                        viewer = type != null ? type.getOpenWith() : Globals.prefs.get("psviewer");
                        cmd = new String[]{"/usr/bin/open", "-a", viewer, link};
                        Runtime.getRuntime().exec(cmd);
                        break block35;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows(link, true);
                        break block35;
                    }
                    type = Globals.prefs.getExternalFileTypeByExt("ps");
                    viewer = type != null ? type.getOpenWith() : "xdg-open";
                    cmdArray = new String[]{viewer, link};
                    Runtime.getRuntime().exec(cmdArray);
                }
                catch (IOException e) {
                    System.err.println("An error occured on the command: " + Globals.prefs.get("psviewer") + " " + link);
                }
            } else if (fieldName.equals("pdf")) {
                try {
                    if (Globals.ON_MAC) {
                        type = Globals.prefs.getExternalFileTypeByExt("pdf");
                        viewer = type != null ? type.getOpenWith() : Globals.prefs.get("psviewer");
                        cmd = new String[]{"/usr/bin/open", "-a", viewer, link};
                        Runtime.getRuntime().exec(cmd);
                        break block35;
                    }
                    if (Globals.ON_WIN) {
                        Util.openFileOnWindows(link, true);
                        break block35;
                    }
                    type = Globals.prefs.getExternalFileTypeByExt("pdf");
                    viewer = type != null ? type.getOpenWith() : Globals.prefs.get("psviewer");
                    cmdArray = new String[]{viewer, link};
                    Runtime.getRuntime().exec(cmdArray);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.err.println("An error occured on the command: " + Globals.prefs.get("pdfviewer") + " #" + link);
                    System.err.println(e.getMessage());
                }
            } else {
                System.err.println("Message: currently only PDF, PS and HTML files can be opened by double clicking");
            }
        }
    }

    public static void openFileOnWindows(String link, boolean localFile) throws IOException {
        link = link.replaceAll("&", "\"&\"").replaceAll(" ", "\" \"");
        String cmd = Globals.osName.startsWith("Windows 9") ? "command.com /c start " + link : "cmd.exe /c start " + link;
        Runtime.getRuntime().exec(cmd);
    }

    public static void openFileWithApplicationOnWindows(String link, String application) throws IOException {
        link = link.replaceAll("&", "\"&\"").replaceAll(" ", "\" \"");
        Runtime.getRuntime().exec(application + " " + link);
    }

    public static boolean openExternalFileAnyFormat(MetaData metaData, String link, ExternalFileType fileType) throws IOException {
        File tmp;
        String[] dirs;
        File file;
        String name;
        int pos;
        boolean httpLink = false;
        if (remoteLinkPattern.matcher(link.toLowerCase()).matches()) {
            httpLink = true;
        }
        String extension = (pos = (name = (file = new File(link)).getName()).lastIndexOf(46)) >= 0 && pos < name.length() - 1 ? name.substring(pos + 1).trim().toLowerCase() : null;
        String dir = metaData.getFileDirectory(extension);
        String fileDir = metaData.getFileDirectory("file");
        if (metaData.getFile() != null) {
            String databaseDir = metaData.getFile().getParent();
            dirs = new String[]{dir, fileDir, databaseDir};
        } else {
            dirs = new String[]{dir, fileDir};
        }
        if (!httpLink && (tmp = Util.expandFilename(link, dirs)) != null) {
            file = tmp;
        }
        if ((httpLink || file.exists()) && fileType != null) {
            String filePath;
            String string = filePath = httpLink ? link : file.getPath();
            if (Globals.ON_MAC) {
                String[] stringArray;
                if (fileType.getOpenWith() != null && fileType.getOpenWith().length() > 0) {
                    String[] stringArray2 = new String[4];
                    stringArray2[0] = "/usr/bin/open";
                    stringArray2[1] = "-a";
                    stringArray2[2] = fileType.getOpenWith();
                    stringArray = stringArray2;
                    stringArray2[3] = filePath;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "/usr/bin/open";
                    stringArray = stringArray3;
                    stringArray3[1] = filePath;
                }
                String[] cmd = stringArray;
                Runtime.getRuntime().exec(cmd);
            } else if (Globals.ON_WIN) {
                if (fileType.getOpenWith() != null && fileType.getOpenWith().length() > 0) {
                    Util.openFileWithApplicationOnWindows(filePath, fileType.getOpenWith());
                } else {
                    Util.openFileOnWindows(filePath, true);
                }
            } else {
                String[] openWith = fileType.getOpenWith() != null && fileType.getOpenWith().length() > 0 ? fileType.getOpenWith().split(" ") : new String[]{"xdg-open"};
                String[] cmdArray = new String[openWith.length + 1];
                System.arraycopy(openWith, 0, cmdArray, 0, openWith.length);
                cmdArray[cmdArray.length - 1] = filePath;
                Runtime.getRuntime().exec(cmdArray);
            }
            return true;
        }
        return false;
    }

    public static void openRemoteExternalFile(final MetaData metaData, String link, final ExternalFileType fileType) {
        File temp = null;
        try {
            temp = File.createTempFile("jabref-link", "." + fileType.getExtension());
            temp.deleteOnExit();
            System.out.println("Downloading to '" + temp.getPath() + "'");
            URLDownload ud = new URLDownload(null, new URL(link), temp);
            ud.download();
            System.out.println("Done");
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        final String ln = temp.getPath();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Util.openExternalFileAnyFormat(metaData, ln, fileType);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public static boolean openExternalFileUnknown(JabRefFrame frame, BibtexEntry entry, MetaData metaData, String link, UnknownExternalFileType fileType) throws IOException {
        String cancelMessage = Globals.lang("Unable to open file.");
        Object[] options = new String[]{Globals.lang("Define '%0'", fileType.getName()), Globals.lang("Change file type"), Globals.lang("Cancel")};
        String defOption = options[0];
        int answer = JOptionPane.showOptionDialog(frame, Globals.lang("This external link is of the type '%0', which is undefined. What do you want to do?", fileType.getName()), Globals.lang("Undefined file type"), 1, 3, null, options, defOption);
        if (answer == 2) {
            frame.output(cancelMessage);
            return false;
        }
        if (answer == 0) {
            ExternalFileType newType = new ExternalFileType(fileType.getName(), "", "", "", "new");
            ExternalFileTypeEntryEditor editor = new ExternalFileTypeEntryEditor(frame, newType);
            editor.setVisible(true);
            if (editor.okPressed()) {
                ArrayList<ExternalFileType> fileTypes = new ArrayList<ExternalFileType>();
                ExternalFileType[] oldTypes = Globals.prefs.getExternalFileTypeSelection();
                for (int i = 0; i < oldTypes.length; ++i) {
                    fileTypes.add(oldTypes[i]);
                }
                fileTypes.add(newType);
                Collections.sort(fileTypes);
                Globals.prefs.setExternalFileTypes(fileTypes);
                return Util.openExternalFileAnyFormat(metaData, link, newType);
            }
            frame.output(cancelMessage);
            return false;
        }
        FileListTableModel tModel = new FileListTableModel();
        String oldValue = entry.getField("file");
        tModel.setContent(oldValue);
        FileListEntry flEntry = null;
        for (int i = 0; i < tModel.getRowCount(); ++i) {
            FileListEntry iEntry = tModel.getEntry(i);
            if (!iEntry.getLink().equals(link)) continue;
            flEntry = iEntry;
            break;
        }
        if (flEntry == null) {
            throw new RuntimeException("Could not find the file list entry " + link + " in " + entry.toString());
        }
        FileListEntryEditor editor = new FileListEntryEditor(frame, flEntry, false, true, metaData);
        editor.setVisible(true, false);
        if (editor.okPressed()) {
            String newValue = tModel.getStringRepresentation();
            UndoableFieldChange ce = new UndoableFieldChange(entry, "file", oldValue, newValue);
            entry.setField("file", newValue);
            frame.basePanel().undoManager.addEdit(ce);
            frame.basePanel().markBaseChanged();
            return Util.openExternalFileAnyFormat(metaData, flEntry.getLink(), flEntry.getType());
        }
        frame.output(cancelMessage);
        return false;
    }

    public static String sanitizeUrl(String link) {
        if (link.startsWith("\\url{") && link.endsWith("}")) {
            link = link.substring(5, link.length() - 1);
        }
        if (link.matches("^doi:/*.*")) {
            link = link.replaceFirst("^doi:/*", "");
            link = "http://dx.doi.org/" + link;
        }
        if (link.startsWith("10.")) {
            link = "http://dx.doi.org/" + link;
        }
        link = link.replaceAll("\\+", "%2B");
        try {
            link = URLDecoder.decode(link, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            return new URI(null, link, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            return link;
        }
    }

    public static String findPdf(String key, String extension, String directory, OpenFileFilter off) {
        String found;
        if (!directory.endsWith(System.getProperty("file.separator"))) {
            directory = directory + System.getProperty("file.separator");
        }
        if ((found = Util.findInDir(key, directory, off, 0)) != null) {
            return found.substring(directory.length());
        }
        return null;
    }

    public static Map<BibtexEntry, List<File>> findAssociatedFiles(Collection<BibtexEntry> entries, Collection<String> extensions, Collection<File> directories) {
        HashMap<BibtexEntry, List<File>> result = new HashMap<BibtexEntry, List<File>>();
        Set<File> filesWithExtension = Util.findFiles(extensions, directories);
        for (BibtexEntry entry : entries) {
            result.put(entry, new ArrayList());
        }
        boolean exactOnly = Globals.prefs.getBoolean("autolinkExactKeyOnly");
        block1: for (File file : filesWithExtension) {
            String citeKey;
            String name = file.getName();
            int dot = name.lastIndexOf(46);
            for (BibtexEntry entry : entries) {
                citeKey = entry.getCiteKey();
                if (citeKey == null || citeKey.length() <= 0 || dot <= 0 || !name.substring(0, dot).equals(citeKey)) continue;
                result.get(entry).add(file);
                continue block1;
            }
            if (exactOnly) continue;
            for (BibtexEntry entry : entries) {
                citeKey = entry.getCiteKey();
                if (citeKey == null || citeKey.length() <= 0 || !name.startsWith(citeKey)) continue;
                result.get(entry).add(file);
                continue block1;
            }
        }
        return result;
    }

    public static Set<File> findFiles(Collection<String> extensions, Collection<File> directories) {
        HashSet<File> result = new HashSet<File>();
        for (File directory : directories) {
            result.addAll(Util.findFiles(extensions, directory));
        }
        return result;
    }

    private static Collection<? extends File> findFiles(Collection<String> extensions, File directory) {
        HashSet<? extends File> result = new HashSet<File>();
        File[] children = directory.listFiles();
        if (children == null) {
            return result;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                result.addAll(Util.findFiles(extensions, child));
                continue;
            }
            String extension = Util.getFileExtension(child);
            if (extension == null || !extensions.contains(extension)) continue;
            result.add(child);
        }
        return result;
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        String extension = pos >= 0 && pos < name.length() - 1 ? name.substring(pos + 1).trim().toLowerCase() : null;
        return extension;
    }

    public static String findPdf(BibtexEntry entry, String extension, String directory) {
        return Util.findPdf(entry, extension, new String[]{directory});
    }

    public static String findPdf(BibtexEntry entry, String extension, String[] directories) {
        String regularExpression = Globals.prefs.getBoolean("useRegExpSearch") ? Globals.prefs.get("regExpSearchExpression") : Globals.prefs.get("defaultRegExpSearchExpression");
        regularExpression = regularExpression.replaceAll("\\[extension\\]", extension);
        return Util.findFile(entry, null, directories, regularExpression, true);
    }

    public static String findFile(BibtexEntry entry, ExternalFileType fileType, List<String> extraDirs) {
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.addAll(extraDirs);
        if (Globals.prefs.hasKey(fileType.getExtension() + "Directory")) {
            dirs.add(Globals.prefs.get(fileType.getExtension() + "Directory"));
        }
        String[] directories = dirs.toArray(new String[dirs.size()]);
        return Util.findPdf(entry, fileType.getExtension(), directories);
    }

    public static String findFile(BibtexEntry entry, BibtexDatabase database, String[] directory, String file, boolean relative) {
        for (int i = 0; i < directory.length; ++i) {
            String result = Util.findFile(entry, database, directory[i], file, relative);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String stripBrackets(String s) {
        int beginIndex = s.startsWith("[") ? 1 : 0;
        int endIndex = s.endsWith("]") ? s.length() - 1 : s.length();
        return s.substring(beginIndex, endIndex);
    }

    public static ArrayList<String[]> parseMethodsCalls(String calls) throws RuntimeException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        char[] c = calls.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            String method;
            int start = i;
            if (!Character.isJavaIdentifierStart(c[i])) continue;
            ++i;
            while (i < c.length && (Character.isJavaIdentifierPart(c[i]) || c[i] == '.')) {
                ++i;
            }
            if (i < c.length && c[i] == '(') {
                method = calls.substring(start, i);
                if (++i < c.length) {
                    int startParam;
                    if (c[i] == '\"') {
                        startParam = ++i;
                        ++i;
                        boolean escaped = false;
                        while (i + 1 < c.length && (escaped || c[i] != '\"' || c[i + 1] != ')')) {
                            escaped = c[i] == '\\' ? !escaped : false;
                            ++i;
                        }
                        String param = calls.substring(startParam, i);
                        result.add(new String[]{method, param});
                        continue;
                    }
                    startParam = i;
                    while (i < c.length && c[i] != ')') {
                        ++i;
                    }
                    String param = calls.substring(startParam, i);
                    result.add(new String[]{method, param});
                    continue;
                }
                result.add(new String[]{method});
                continue;
            }
            method = calls.substring(start, i);
            result.add(new String[]{method});
        }
        return result;
    }

    public static String getFieldAndFormat(String fieldAndFormat, BibtexEntry entry, BibtexDatabase database) {
        String afterColon;
        String beforeColon;
        int colon = (fieldAndFormat = Util.stripBrackets(fieldAndFormat)).indexOf(58);
        if (colon == -1) {
            beforeColon = fieldAndFormat;
            afterColon = null;
        } else {
            beforeColon = fieldAndFormat.substring(0, colon);
            afterColon = fieldAndFormat.substring(colon + 1);
        }
        beforeColon = beforeColon.trim();
        if (beforeColon.length() == 0) {
            return null;
        }
        String fieldValue = BibtexDatabase.getResolvedField(beforeColon, entry, database);
        if (fieldValue == null) {
            fieldValue = LabelPatternUtil.makeLabel(entry, beforeColon);
        }
        if (fieldValue == null) {
            return null;
        }
        if (afterColon == null || afterColon.length() == 0) {
            return fieldValue;
        }
        String[] parts = afterColon.split(":");
        fieldValue = LabelPatternUtil.applyModifiers(fieldValue, parts, 0);
        return fieldValue;
    }

    public static String findFile(BibtexEntry entry, BibtexDatabase database, String file) {
        return Util.findFile(entry, database, (String)null, file, false);
    }

    public static String findFile(BibtexEntry entry, BibtexDatabase database, String directory, String file, boolean relative) {
        File root = directory == null ? new File(".") : new File(directory);
        if (!root.exists()) {
            return null;
        }
        String found = Util.findFile(entry, database, root, file);
        if (directory == null || !relative) {
            return found;
        }
        if (found != null) {
            try {
                String tmp = found.substring(root.getCanonicalPath().length());
                if (tmp.length() > 1 && tmp.charAt(0) == File.separatorChar) {
                    tmp = tmp.substring(1);
                }
                return tmp;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    protected static String findFile(BibtexEntry entry, BibtexDatabase database, File directory, String file) {
        if (file.startsWith("/")) {
            directory = new File(".");
            file = file.substring(1);
        }
        Matcher m = Pattern.compile("([^\\\\])\\\\([^\\\\])").matcher(file);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(s, m.group(1) + "/" + m.group(2));
        }
        m.appendTail(s);
        file = s.toString();
        String[] fileParts = file.split("/");
        if (fileParts.length == 0) {
            return null;
        }
        if (fileParts.length > 1) {
            for (int i = 0; i < fileParts.length - 1; ++i) {
                String restOfFileString;
                String dirToProcess = fileParts[i];
                if ((dirToProcess = Util.expandBrackets(dirToProcess, entry, database)).matches("^.:$")) {
                    directory = new File(dirToProcess + "/");
                    continue;
                }
                if (dirToProcess.equals(".")) continue;
                if (dirToProcess.equals("..")) {
                    directory = new File(directory.getParent());
                    continue;
                }
                if (dirToProcess.equals("*")) {
                    File[] subDirs = directory.listFiles();
                    if (subDirs == null) {
                        return null;
                    }
                    restOfFileString = Util.join(fileParts, "/", i + 1, fileParts.length);
                    for (int sub = 0; sub < subDirs.length; ++sub) {
                        String result;
                        if (!subDirs[sub].isDirectory() || (result = Util.findFile(entry, database, subDirs[sub], restOfFileString)) == null) continue;
                        return result;
                    }
                    return null;
                }
                if (dirToProcess.equals("**")) {
                    LinkedList<File> toDo = new LinkedList<File>();
                    toDo.add(directory);
                    restOfFileString = Util.join(fileParts, "/", i + 1, fileParts.length);
                    String result = Util.findFile(entry, database, directory, restOfFileString);
                    if (result != null) {
                        return result;
                    }
                    while (!toDo.isEmpty()) {
                        File[] subDirs = ((File)toDo.remove(0)).listFiles();
                        if (subDirs == null) continue;
                        toDo.addAll(Arrays.asList(subDirs));
                        for (int sub = 0; sub < subDirs.length; ++sub) {
                            if (!subDirs[sub].isDirectory() || (result = Util.findFile(entry, database, subDirs[sub], restOfFileString)) == null) continue;
                            return result;
                        }
                    }
                    return null;
                }
                final Pattern toMatch = Pattern.compile(dirToProcess.replaceAll("\\\\\\\\", "\\\\"));
                File[] matches = directory.listFiles(new FilenameFilter(){

                    public boolean accept(File arg0, String arg1) {
                        return toMatch.matcher(arg1).matches();
                    }
                });
                if (matches == null || matches.length == 0) {
                    return null;
                }
                directory = matches[0];
                if (directory.exists()) continue;
                return null;
            }
        }
        String filenameToLookFor = Util.expandBrackets(fileParts[fileParts.length - 1], entry, database);
        final Pattern toMatch = Pattern.compile("^" + filenameToLookFor.replaceAll("\\\\\\\\", "\\\\") + "$");
        File[] matches = directory.listFiles(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return toMatch.matcher(arg1).matches();
            }
        });
        if (matches == null || matches.length == 0) {
            return null;
        }
        try {
            return matches[0].getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String expandBrackets(String bracketString, BibtexEntry entry, BibtexDatabase database) {
        Matcher m = squareBracketsPattern.matcher(bracketString);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            String replacement = Util.getFieldAndFormat(m.group(), entry, database);
            if (replacement == null) {
                replacement = "";
            }
            m.appendReplacement(s, replacement);
        }
        m.appendTail(s);
        return s.toString();
    }

    public static String join(String[] strings, String separator, int from, int to) {
        if (strings.length == 0 || from >= to) {
            return "";
        }
        from = Math.max(from, 0);
        to = Math.min(strings.length, to);
        StringBuffer sb = new StringBuffer();
        for (int i = from; i < to - 1; ++i) {
            sb.append(strings[i]).append(separator);
        }
        return sb.append(strings[to - 1]).toString();
    }

    public static File expandFilename(String name, String[] dir) {
        for (int i = 0; i < dir.length; ++i) {
            File result;
            if (dir[i] == null || (result = Util.expandFilename(name, dir[i])) == null) continue;
            return result;
        }
        return null;
    }

    public static File expandFilename(String name, String dir) {
        File file = null;
        if (name == null || name.length() == 0) {
            return null;
        }
        file = new File(name);
        if (!file.exists() && dir != null) {
            name = dir.endsWith(System.getProperty("file.separator")) ? dir + name : dir + System.getProperty("file.separator") + name;
            file = new File(name);
            if (file.exists()) {
                return file;
            }
            if (Globals.ON_WIN) {
                try {
                    name = name.replaceAll("/", "\\\\");
                }
                catch (StringIndexOutOfBoundsException exc) {
                    System.err.println("An internal Java error was caused by the entry \"" + name + "\"");
                }
            } else {
                name = name.replaceAll("\\\\", "/");
            }
            if (!(file = new File(name)).exists()) {
                file = null;
            }
        }
        return file;
    }

    private static String findInDir(String key, String dir, OpenFileFilter off, int count) {
        if (count > 20) {
            return null;
        }
        File f = new File(dir);
        File[] all = f.listFiles();
        if (all == null) {
            return null;
        }
        for (File curFile : all) {
            String found;
            if (curFile.isFile()) {
                String name = curFile.getName();
                if (!name.startsWith(key + ".") || !off.accept(name)) continue;
                return curFile.getPath();
            }
            if (!curFile.isDirectory() || (found = Util.findInDir(key, curFile.getPath(), off, count + 1)) == null) continue;
            return found;
        }
        return null;
    }

    public static void updateCompletersForEntry(HashMap<String, AbstractAutoCompleter> autoCompleters, BibtexEntry bibtexEntry) {
        for (Map.Entry<String, AbstractAutoCompleter> entry : autoCompleters.entrySet()) {
            AbstractAutoCompleter comp = entry.getValue();
            comp.addBibtexEntry(bibtexEntry);
        }
    }

    public static void setAutomaticFields(Collection<BibtexEntry> bibs, boolean overwriteOwner, boolean overwriteTimestamp, boolean markEntries) {
        String timeStampField = Globals.prefs.get("timeStampField");
        String defaultOwner = Globals.prefs.get("defaultOwner");
        String timestamp = Util.easyDateFormat();
        boolean globalSetOwner = Globals.prefs.getBoolean("useOwner");
        boolean globalSetTimeStamp = Globals.prefs.getBoolean("useTimeStamp");
        if (!(globalSetOwner || globalSetTimeStamp || markEntries)) {
            return;
        }
        for (BibtexEntry curEntry : bibs) {
            boolean setOwner = globalSetOwner && (overwriteOwner || curEntry.getField("owner") == null);
            boolean setTimeStamp = globalSetTimeStamp && (overwriteTimestamp || curEntry.getField(timeStampField) == null);
            Util.setAutomaticFields(curEntry, setOwner, defaultOwner, setTimeStamp, timeStampField, timestamp);
            if (!markEntries) continue;
            Util.markEntry(curEntry, IMPORT_MARK_LEVEL, false, new NamedCompound(""));
        }
    }

    public static void setAutomaticFields(BibtexEntry entry, boolean overwriteOwner, boolean overwriteTimestamp) {
        String defaultOwner = Globals.prefs.get("defaultOwner");
        String timestamp = Util.easyDateFormat();
        String timeStampField = Globals.prefs.get("timeStampField");
        boolean setOwner = Globals.prefs.getBoolean("useOwner") && (overwriteOwner || entry.getField("owner") == null);
        boolean setTimeStamp = Globals.prefs.getBoolean("useTimeStamp") && (overwriteTimestamp || entry.getField(timeStampField) == null);
        Util.setAutomaticFields(entry, setOwner, defaultOwner, setTimeStamp, timeStampField, timestamp);
    }

    private static void setAutomaticFields(BibtexEntry entry, boolean setOwner, String owner, boolean setTimeStamp, String timeStampField, String timeStamp) {
        if (setOwner) {
            entry.setField("owner", owner);
        }
        if (setTimeStamp) {
            entry.setField(timeStampField, timeStamp);
        }
    }

    public static boolean copyFile(File source, File dest, boolean deleteIfExists) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int el;
            if (dest.exists() && !deleteIfExists) {
                boolean bl = false;
                return bl;
            }
            in = new BufferedInputStream(new FileInputStream(source));
            out = new BufferedOutputStream(new FileOutputStream(dest));
            while ((el = in.read()) >= 0) {
                out.write(el);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        return true;
    }

    public static void performCompatibilityUpdate() {
        String genFields = Globals.prefs.get("generalFields");
        if (genFields.indexOf("abstract") >= 0) {
            String newGen = genFields.equals("abstract") ? "" : (genFields.indexOf(";abstract;") >= 0 ? genFields.replaceAll(";abstract;", ";") : (genFields.indexOf("abstract;") == 0 ? genFields.replaceAll("abstract;", "") : (genFields.indexOf(";abstract") == genFields.length() - 9 ? genFields.replaceAll(";abstract", "") : genFields)));
            Globals.prefs.put("generalFields", newGen);
        }
    }

    public static NamedCompound upgradePdfPsToFile(BibtexDatabase database, String[] fields) {
        NamedCompound ce = new NamedCompound(Globals.lang("Move external links to 'file' field"));
        for (BibtexEntry entry : database.getEntryMap().values()) {
            FileListTableModel tableModel = new FileListTableModel();
            String oldFileContent = entry.getField("file");
            if (oldFileContent != null) {
                tableModel.setContent(oldFileContent);
            }
            int oldRowCount = tableModel.getRowCount();
            for (int j = 0; j < fields.length; ++j) {
                String s;
                String o = entry.getField(fields[j]);
                if (o == null || (s = o).trim().length() <= 0) continue;
                File f = new File(s);
                FileListEntry flEntry = new FileListEntry(f.getName(), s, Globals.prefs.getExternalFileTypeByExt(fields[j]));
                tableModel.addEntry(tableModel.getRowCount(), flEntry);
                entry.clearField(fields[j]);
                ce.addEdit(new UndoableFieldChange(entry, fields[j], o, null));
            }
            if (tableModel.getRowCount() == oldRowCount) continue;
            String newValue = tableModel.getStringRepresentation();
            entry.setField("file", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "file", oldFileContent, newValue));
        }
        ce.end();
        return ce;
    }

    public static String getCorrectFileName(String orgName, String defaultExtension) {
        if (orgName == null) {
            return "";
        }
        String back = orgName;
        int t = orgName.indexOf(".", 1);
        if (t < 1) {
            back = back + "." + defaultExtension;
        }
        return back;
    }

    public static String quoteForHTML(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append("&#" + s.charAt(i) + ";");
        }
        return sb.toString();
    }

    public static String quote(String s, String specials, char quoteChar) {
        return Util.quote(s, specials, quoteChar, 0);
    }

    public static String quote(String s, String specials, char quoteChar, int linewrap) {
        StringBuffer sb = new StringBuffer();
        int linelength = 0;
        for (int i = 0; i < s.length(); ++i) {
            boolean isSpecial;
            char c = s.charAt(i);
            boolean bl = isSpecial = specials.indexOf(c) >= 0 || c == quoteChar;
            if (linewrap > 0 && (++linelength >= linewrap || isSpecial && linelength >= linewrap - 1)) {
                sb.append(quoteChar);
                sb.append('\n');
                linelength = 0;
            }
            if (isSpecial) {
                sb.append(quoteChar);
                ++linelength;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unquote(String s, char quoteChar) {
        StringBuffer sb = new StringBuffer();
        boolean quoted = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (quoted) {
                if (c != '\n') {
                    sb.append(c);
                }
                quoted = false;
                continue;
            }
            if (c != quoteChar) {
                sb.append(c);
                continue;
            }
            quoted = true;
        }
        return sb.toString();
    }

    public static String quoteMeta(String s) {
        int i;
        StringBuffer bs = new StringBuffer("");
        for (i = s.length() - 1; i >= 0 && s.charAt(i) == '\\'; --i) {
            bs.append("\\\\");
        }
        s = s.substring(0, i + 1);
        return "\\Q" + s.replaceAll("\\\\E", "\\\\E\\\\\\\\E\\\\Q") + "\\E" + bs.toString();
    }

    public static String sortWordsAndRemoveDuplicates(String text) {
        String result;
        String[] words = text.split(", ");
        TreeSet<String> set = new TreeSet<String>();
        for (int i = 0; i < words.length; ++i) {
            set.add(words[i]);
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return (result = sb.toString()).length() > 2 ? result : "";
    }

    public static boolean warnAssignmentSideEffects(AbstractGroup[] groups, BibtexEntry[] entries, BibtexDatabase db, Component parent) {
        Vector<String> affectedFields = new Vector<String>();
        block0: for (int k = 0; k < groups.length; ++k) {
            KeywordGroup kg;
            String field;
            if (!(groups[k] instanceof KeywordGroup) || (field = (kg = (KeywordGroup)groups[k]).getSearchField().toLowerCase()).equals("keywords")) continue;
            int len = BibtexFields.numberOfPublicFields();
            for (int i = 0; i < len; ++i) {
                if (!field.equals(BibtexFields.getFieldName(i))) continue;
                affectedFields.add(field);
                continue block0;
            }
        }
        if (affectedFields.size() == 0) {
            return true;
        }
        StringBuffer message = new StringBuffer("This action will modify the following field(s)\nin at least one entry each:\n");
        for (int i = 0; i < affectedFields.size(); ++i) {
            message.append((String)affectedFields.elementAt(i)).append("\n");
        }
        message.append("This could cause undesired changes to your entries, so it is\nrecommended that you change the grouping field in your group\ndefinition to \"keywords\" or a non-standard name.\n\nDo you still want to continue?");
        int choice = JOptionPane.showConfirmDialog(parent, message, Globals.lang("Warning"), 0, 2);
        return choice != 1;
    }

    public static String putBracesAroundCapitals(String s) {
        boolean inString = false;
        boolean isBracing = false;
        boolean escaped = false;
        int inBrace = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '{') {
                ++inBrace;
            } else if (c == '}') {
                --inBrace;
            } else if (!escaped && c == '#') {
                boolean bl = inString = !inString;
            }
            if (inBrace == 0 && !isBracing && !inString && Character.isLetter(c) && Character.isUpperCase(c)) {
                buf.append('{');
                isBracing = true;
            }
            if (!(!isBracing || Character.isLetter(c) && Character.isUpperCase(c))) {
                buf.append('}');
                isBracing = false;
            }
            buf.append(c);
            escaped = c == '\\' && !escaped;
        }
        if (isBracing) {
            buf.append('}');
        }
        return buf.toString();
    }

    public static String removeBracesAroundCapitals(String s) {
        String previous = s;
        while ((s = Util.removeSingleBracesAroundCapitals(s)).length() < previous.length()) {
            previous = s;
        }
        return s;
    }

    public static String removeSingleBracesAroundCapitals(String s) {
        Matcher mcr = bracedTitleCapitalPattern.matcher(s);
        StringBuffer buf = new StringBuffer();
        while (mcr.find()) {
            String replaceStr = mcr.group();
            mcr.appendReplacement(buf, replaceStr.substring(1, replaceStr.length() - 1));
        }
        mcr.appendTail(buf);
        return buf.toString();
    }

    public static OpenFileFilter getFileFilterForField(String fieldName) {
        String s = BibtexFields.getFieldExtras(fieldName);
        String ext = "." + fieldName.toLowerCase();
        OpenFileFilter off = s.equals("browseDocZip") ? new OpenFileFilter(new String[]{ext, ext + ".gz", ext + ".bz2"}) : new OpenFileFilter(new String[]{ext});
        return off;
    }

    public static void showQuickErrorDialog(JFrame parent, String title, Exception e) {
        final JPanel pan = new JPanel();
        JPanel details = new JPanel();
        final CardLayout crd = new CardLayout();
        pan.setLayout(crd);
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Sans-Serif", 0, 10));
        textArea.setEditable(false);
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        textArea.setText(writer.toString());
        JLabel lab = new JLabel(e.getMessage());
        JButton flip = new JButton(Globals.lang("Details"));
        FormLayout layout = new FormLayout("left:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(lab);
        builder.nextLine();
        builder.append(Box.createVerticalGlue());
        builder.nextLine();
        builder.append(flip);
        JPanel simple = builder.getPanel();
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(350, 150));
        details.setLayout(new BorderLayout());
        details.add((Component)scrollPane, "Center");
        flip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                crd.show(pan, "details");
            }
        });
        pan.add((Component)simple, "simple");
        pan.add((Component)details, "details");
        JOptionPane.showMessageDialog(parent, pan, title, 0);
    }

    public static String wrapHTML(String s, int lineWidth) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(s);
        int charsLeft = lineWidth;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (charsLeft == lineWidth) {
                sb.append(word);
                if ((charsLeft -= word.length()) > 0) continue;
                sb.append("<br>\n");
                charsLeft = lineWidth;
                continue;
            }
            if (charsLeft < word.length() + 1) {
                sb.append("<br>\n");
                sb.append(word);
                if (word.length() >= lineWidth - 1) {
                    sb.append("<br>\n");
                    charsLeft = lineWidth;
                    continue;
                }
                sb.append(" ");
                charsLeft = lineWidth - word.length() - 1;
                continue;
            }
            sb.append(' ').append(word);
            charsLeft -= word.length() + 1;
        }
        return sb.toString();
    }

    public static String easyDateFormat() {
        return Util.easyDateFormat(new Date());
    }

    public static String easyDateFormat(Date date) {
        if (dateFormatter == null) {
            String format = Globals.prefs.get("timeStampFormat");
            dateFormatter = new SimpleDateFormat(format);
        }
        return dateFormatter.format(date);
    }

    public static void markEntry(BibtexEntry be, int markIncrement, boolean increment, NamedCompound ce) {
        String o = be.getField("__markedentry");
        int prevMarkLevel = 0;
        String newValue = null;
        if (o != null) {
            String s = o.toString();
            int index = s.indexOf(Globals.prefs.WRAPPED_USERNAME);
            if (index >= 0) {
                prevMarkLevel = 1;
                newValue = s.substring(0, index) + s.substring(index + Globals.prefs.WRAPPED_USERNAME.length()) + Globals.prefs.WRAPPED_USERNAME.substring(0, Globals.prefs.WRAPPED_USERNAME.length() - 1) + ":" + (increment ? Math.min(MAX_MARKING_LEVEL, prevMarkLevel + markIncrement) : markIncrement) + "]";
            } else {
                Matcher m = markNumberPattern.matcher(s);
                if (m.find()) {
                    try {
                        prevMarkLevel = Integer.parseInt(m.group(1));
                        newValue = s.substring(0, m.start(1)) + (increment ? Math.min(MAX_MARKING_LEVEL, prevMarkLevel + markIncrement) : markIncrement) + s.substring(m.end(1));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
        }
        if (newValue == null) {
            newValue = Globals.prefs.WRAPPED_USERNAME.substring(0, Globals.prefs.WRAPPED_USERNAME.length() - 1) + ":" + markIncrement + "]";
        }
        ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry"), newValue));
        be.setField("__markedentry", newValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unmarkEntry(BibtexEntry be, boolean onlyMaxLevel, BibtexDatabase database, NamedCompound ce) {
        String o = be.getField("__markedentry");
        if (o == null) return;
        String s = o.toString();
        if (s.equals("0")) {
            if (onlyMaxLevel) return;
            Util.unmarkOldStyle(be, database, ce);
            return;
        }
        String newValue = null;
        int index = s.indexOf(Globals.prefs.WRAPPED_USERNAME);
        if (index >= 0) {
            if (onlyMaxLevel) return;
            newValue = s.substring(0, index) + s.substring(index + Globals.prefs.WRAPPED_USERNAME.length());
        } else {
            Matcher m = markNumberPattern.matcher(s);
            if (m.find()) {
                try {
                    int prevMarkLevel = Integer.parseInt(m.group(1));
                    if (onlyMaxLevel && prevMarkLevel != MARK_COLOR_LEVELS) return;
                    if (prevMarkLevel > 1) {
                        newValue = s.substring(0, m.start(1)) + s.substring(m.end(1));
                    } else {
                        String toRemove = Globals.prefs.WRAPPED_USERNAME.substring(0, Globals.prefs.WRAPPED_USERNAME.length() - 1) + ":1]";
                        index = s.indexOf(toRemove);
                        if (index >= 0) {
                            newValue = s.substring(0, index) + s.substring(index + toRemove.length());
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry"), newValue));
        be.setField("__markedentry", newValue);
    }

    private static void unmarkOldStyle(BibtexEntry be, BibtexDatabase database, NamedCompound ce) {
        TreeSet<String> owners = new TreeSet<String>();
        for (BibtexEntry entry : database.getEntries()) {
            String o = entry.getField("owner");
            if (o == null) continue;
            owners.add(o);
        }
        owners.remove(Globals.prefs.get("defaultOwner"));
        StringBuffer sb = new StringBuffer();
        Iterator i = owners.iterator();
        while (i.hasNext()) {
            sb.append('[');
            sb.append(i.next().toString());
            sb.append(']');
        }
        String newVal = sb.toString();
        if (newVal.length() == 0) {
            newVal = null;
        }
        ce.addEdit(new UndoableFieldChange(be, "__markedentry", be.getField("__markedentry"), newVal));
        be.setField("__markedentry", newVal);
    }

    public static int isMarked(BibtexEntry be) {
        String fieldVal = be.getField("__markedentry");
        if (fieldVal == null) {
            return 0;
        }
        String s = fieldVal;
        if (s.equals("0")) {
            return 1;
        }
        int index = s.indexOf(Globals.prefs.WRAPPED_USERNAME);
        if (index >= 0) {
            return 1;
        }
        Matcher m = markNumberPattern.matcher(s);
        if (m.find()) {
            try {
                int value = Integer.parseInt(m.group(1));
                return value;
            }
            catch (NumberFormatException ex) {
                return 1;
            }
        }
        return 0;
    }

    public static UndoableEdit massSetField(Collection<BibtexEntry> entries, String field, String text, boolean overwriteValues) {
        NamedCompound ce = new NamedCompound(Globals.lang("Set field"));
        for (BibtexEntry entry : entries) {
            String oldVal = entry.getField(field);
            if (!overwriteValues && oldVal != null && oldVal.length() > 0) continue;
            if (text != null) {
                entry.setField(field, text);
            } else {
                entry.clearField(field);
            }
            ce.addEdit(new UndoableFieldChange(entry, field, oldVal, text));
        }
        ce.end();
        return ce;
    }

    public static UndoableEdit massRenameField(Collection<BibtexEntry> entries, String field, String newField, boolean overwriteValues) {
        NamedCompound ce = new NamedCompound(Globals.lang("Rename field"));
        for (BibtexEntry entry : entries) {
            String valToMove = entry.getField(field);
            if (valToMove == null || valToMove.length() == 0) continue;
            String valInNewField = entry.getField(newField);
            if (!overwriteValues && valInNewField != null && valInNewField.length() > 0) continue;
            entry.setField(newField, valToMove);
            ce.addEdit(new UndoableFieldChange(entry, newField, valInNewField, valToMove));
            entry.clearField(field);
            ce.addEdit(new UndoableFieldChange(entry, field, valToMove, null));
        }
        ce.end();
        return ce;
    }

    public static List<String> findEncodingsForString(String characters) {
        ArrayList<String> encodings = new ArrayList<String>();
        for (int i = 0; i < Globals.ENCODINGS.length; ++i) {
            CharsetEncoder encoder = Charset.forName(Globals.ENCODINGS[i]).newEncoder();
            if (!encoder.canEncode(characters)) continue;
            encodings.add(Globals.ENCODINGS[i]);
        }
        return encodings;
    }

    public static String toFourDigitYear(String year) {
        if (thisYear == 0) {
            thisYear = Calendar.getInstance().get(1);
        }
        return Util.toFourDigitYear(year, thisYear);
    }

    public static String toFourDigitYear(String year, int thisYear) {
        if (year.length() != 2) {
            return year;
        }
        try {
            int thisYearTwoDigits = thisYear % 100;
            int thisCentury = thisYear - thisYearTwoDigits;
            int yearNumber = Integer.parseInt(year);
            if (yearNumber == thisYearTwoDigits) {
                return String.valueOf(thisYear);
            }
            if ((yearNumber + 100 - thisYearTwoDigits) % 100 > 30) {
                if (yearNumber < thisYearTwoDigits) {
                    return String.valueOf(thisCentury + yearNumber);
                }
                return String.valueOf(thisCentury - 100 + yearNumber);
            }
            if (yearNumber < thisYearTwoDigits) {
                return String.valueOf(thisCentury + 100 + yearNumber);
            }
            return String.valueOf(thisCentury + yearNumber);
        }
        catch (NumberFormatException e) {
            return year;
        }
    }

    public static int getMonthNumber(String month) {
        month = month.replaceAll("#", "").toLowerCase();
        for (int i = 0; i < Globals.MONTHS.length; ++i) {
            if (!month.startsWith(Globals.MONTHS[i])) continue;
            return i;
        }
        try {
            return Integer.parseInt(month) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String encodeStringArray(String[][] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(Util.encodeStringArray(values[i]));
            if (i >= values.length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    public static String encodeStringArray(String[] entry) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < entry.length; ++i) {
            sb.append(Util.encodeString(entry[i]));
            if (i >= entry.length - 1) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public static String[][] decodeStringDoubleArray(String value) {
        ArrayList newList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> thisEntry = new ArrayList<String>();
        boolean escaped = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && c == ':') {
                thisEntry.add(sb.toString());
                sb = new StringBuilder();
            } else if (!escaped && c == ';') {
                thisEntry.add(sb.toString());
                sb = new StringBuilder();
                newList.add(thisEntry);
                thisEntry = new ArrayList();
            } else {
                sb.append(c);
            }
            escaped = false;
        }
        if (sb.length() > 0) {
            thisEntry.add(sb.toString());
        }
        if (thisEntry.size() > 0) {
            newList.add(thisEntry);
        }
        String[][] res = new String[newList.size()][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new String[((ArrayList)newList.get(i)).size()];
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = (String)((ArrayList)newList.get(i)).get(j);
            }
        }
        return res;
    }

    private static String encodeString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ';' || c == ':' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean equals(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }

    public static String toUpperFirstLetter(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static void runAbstractWorker(AbstractWorker worker) throws Throwable {
        Worker wrk = worker.getWorker();
        CallBack clb = worker.getCallBack();
        worker.init();
        wrk.run();
        clb.update();
    }

    public static boolean waitForFileLock(File file, int maxWaitCount) {
        int lockCheckCount = 0;
        while (Util.hasLockFile(file)) {
            if (lockCheckCount++ == maxWaitCount) {
                return false;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public static boolean hasLockFile(File file) {
        File lock = new File(file.getPath() + ".lock");
        return lock.exists();
    }

    public static long getLockFileTimeStamp(File file) {
        File lock = new File(file.getPath() + ".lock");
        return lock.exists() ? lock.lastModified() : -1L;
    }

    public static boolean deleteLockFile(File file) {
        File lock = new File(file.getPath() + ".lock");
        if (!lock.exists()) {
            return false;
        }
        lock.delete();
        return true;
    }

    public static String[] getRemainder(String[] all, String[] subset) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < all.length; ++i) {
            boolean found = false;
            for (int j = 0; j < subset.length; ++j) {
                if (!subset[j].equals(all[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            al.add(all[i]);
        }
        return al.toArray(new String[al.size()]);
    }

    static {
        remoteLinkPattern = Pattern.compile("[a-z]+://.*");
        MARK_COLOR_LEVELS = 6;
        MAX_MARKING_LEVEL = MARK_COLOR_LEVELS - 1;
        IMPORT_MARK_LEVEL = MARK_COLOR_LEVELS;
        markNumberPattern = Pattern.compile(Globals.prefs.MARKING_WITH_NUMBER_PATTERN);
        idFormat = NumberFormat.getInstance();
        idFormat.setMinimumIntegerDigits(8);
        idFormat.setGroupingUsed(false);
        idCounter = 0;
        squareBracketsPattern = Pattern.compile("\\[.*?\\]");
        titleCapitalPattern = Pattern.compile("[A-Z]+");
        bracedTitleCapitalPattern = Pattern.compile("\\{[A-Z]+\\}");
    }
}

