/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.SidePaneComponent;

public class SidePaneHeader
extends JPanel
implements ActionListener {
    private JButton close = new JButton(GUIGlobals.getImage("close2"));
    private JLabel nameLabel;
    private SidePaneComponent parent;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();

    public SidePaneHeader(String name, URL image, SidePaneComponent parent_) {
        this.addPart(name, image, parent_);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Paint oldPaint = g2.getPaint();
        Insets ins = this.getInsets();
        int width = this.getWidth() - ins.left - ins.right;
        int height = this.getHeight() - ins.top - ins.bottom;
        g2.setPaint(new GradientPaint(ins.left, ins.top, GUIGlobals.gradientGray, width, height, GUIGlobals.gradientBlue, false));
        g2.fillRect(ins.left, ins.top, width - 1, height);
        g2.setPaint(oldPaint);
    }

    private void addPart(String name, URL image, SidePaneComponent parent_) {
        this.parent = parent_;
        this.setLayout(this.gbl);
        this.nameLabel = new JLabel(Globals.lang(name), new ImageIcon(image), 2);
        this.nameLabel.setForeground(new Color(230, 230, 230));
        this.close.setBorder(null);
        this.close.setOpaque(false);
        this.close.setPreferredSize(new Dimension(15, 15));
        this.close.setMaximumSize(new Dimension(15, 15));
        this.close.setMinimumSize(new Dimension(15, 15));
        this.close.addActionListener(this);
        this.con.insets = new Insets(1, 1, 1, 1);
        this.con.gridwidth = 1;
        this.con.anchor = 17;
        this.con.fill = 0;
        this.gbl.setConstraints(this.nameLabel, this.con);
        this.add(this.nameLabel);
        JPanel pan = new JPanel();
        pan.setOpaque(false);
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(pan, this.con);
        this.add(pan);
        this.con.weightx = 0.0;
        this.con.fill = 0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.close, this.con);
        this.add(this.close);
    }

    public void actionPerformed(ActionEvent e) {
        this.parent.hideAway();
    }
}

