/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HelpContent
extends JTextPane {
    static Log log = LogFactory.getLog(HelpContent.class);
    JScrollPane pane = new JScrollPane(this, 20, 31);
    private Stack<URL> history;
    private Stack<URL> forw;
    JabRefPreferences prefs;

    public HelpContent(JabRefPreferences prefs_) {
        this.pane.setDoubleBuffered(true);
        this.prefs = prefs_;
        this.history = new Stack();
        this.forw = new Stack();
        this.setEditorKitForContentType("text/html", new MyEditorKit());
        this.setContentType("text/html");
        this.setText("");
        this.setEditable(false);
        HyperlinkListener hyperLinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getDescription().startsWith("#")) {
                    HelpContent.this.scrollToReference(e.getDescription().substring(1));
                }
            }
        };
        this.addHyperlinkListener(hyperLinkListener);
    }

    public boolean back() {
        if (!this.history.empty()) {
            URL prev = this.history.pop();
            this.forw.push(this.getPage());
            this.setPageOnly(prev);
        }
        return !this.history.empty();
    }

    public boolean forward() {
        if (!this.forw.empty()) {
            URL next = this.forw.pop();
            this.history.push(this.getPage());
            this.setPageOnly(next);
        }
        return !this.forw.empty();
    }

    public void reset() {
        this.forw.removeAllElements();
        this.history.removeAllElements();
    }

    public void setPage(String filename, Class resourceOwner) {
        String reference;
        String file;
        int indexOf = filename.indexOf(35);
        if (indexOf != -1) {
            file = filename.substring(0, indexOf);
            reference = filename.substring(indexOf + 1);
        } else {
            file = filename;
            reference = "";
        }
        String middle = this.prefs.get("language") + "/";
        if (middle.equals("en/")) {
            middle = "";
        }
        URL old = this.getPage();
        try {
            URL resource = resourceOwner.getResource(GUIGlobals.helpPre + middle + file);
            if (resource == null) {
                resource = resourceOwner.getResource(GUIGlobals.helpPre + file);
            }
            if (resource == null) {
                log.error("Could not find html-help for file '" + file + "'.");
                return;
            }
            this.setPageOnly(new URL(resource.toString() + "#" + reference));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.forw.removeAllElements();
        if (old != null) {
            this.history.push(old);
        }
    }

    public void setPage(URL url) {
        File f = new File(url.getPath());
        this.setPage(f.getName(), JabRef.class);
    }

    private void setPageOnly(URL url) {
        try {
            super.setPage(url);
        }
        catch (IOException ex) {
            if (url == null) {
                System.out.println("Error: Help file not set");
            }
            System.out.println("Error: Help file not found '" + url.getFile() + "'");
        }
    }

    public JComponent getPane() {
        return this.pane;
    }

    public class MyEditorKit
    extends HTMLEditorKit {
        private Action[] myActions;

        public Action[] getActions() {
            if (this.myActions == null) {
                Action[] actions = super.getActions();
                Action[] newActions = new Action[2];
                for (int i = 0; i < actions.length; ++i) {
                    Action actn = actions[i];
                    String name = (String)actn.getValue("Name");
                    if (name.equals("caret-up")) {
                        newActions[0] = new MyNextVisualPositionAction(actions[i], 1);
                        continue;
                    }
                    if (!name.equals("caret-down")) continue;
                    newActions[1] = new MyNextVisualPositionAction(actions[i], 5);
                }
                this.myActions = TextAction.augmentList(actions, newActions);
            }
            return this.myActions;
        }
    }

    public class MyNextVisualPositionAction
    extends TextAction {
        private Action textActn;
        private int direction;

        private MyNextVisualPositionAction(Action textActn, int direction) {
            super((String)textActn.getValue("Name"));
            this.textActn = textActn;
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            if (c.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)c.getParent();
                Point p = viewport.getViewPosition();
                if (this.direction == 1) {
                    c.setCaretPosition(c.viewToModel(p));
                } else {
                    p.y += viewport.getExtentSize().height;
                    c.setCaretPosition(c.viewToModel(p));
                }
            }
            this.textActn.actionPerformed(e);
        }
    }
}

