/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

public class GeneralTab
extends JPanel
implements PrefsTab {
    private JCheckBox defSort;
    private JCheckBox ctrlClick;
    private JCheckBox useOwner;
    private JCheckBox overwriteOwner;
    private JCheckBox keyDuplicateWarningDialog;
    private JCheckBox keyEmptyWarningDialog;
    private JCheckBox enforceLegalKeys;
    private JCheckBox confirmDelete;
    private JCheckBox allowEditing;
    private JCheckBox memoryStick;
    private JCheckBox useImportInspector;
    private JCheckBox useImportInspectorForSingle;
    private JCheckBox inspectionWarnDupli;
    private JCheckBox useTimeStamp;
    private JCheckBox overwriteTimeStamp;
    private JCheckBox markImportedEntries;
    private JCheckBox unmarkAllEntriesBeforeImporting;
    private JTextField defOwnerField;
    private JTextField timeStampFormat;
    private JTextField timeStampField;
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    private JComboBox language = new JComboBox<Object>(GUIGlobals.LANGUAGES.keySet().toArray());
    private JComboBox encodings = new JComboBox<String>(Globals.ENCODINGS);
    private HelpAction ownerHelp;
    private HelpAction timeStampHelp;

    public GeneralTab(JabRefFrame frame, JabRefPreferences prefs) {
        this._prefs = prefs;
        this._frame = frame;
        this.setLayout(new BorderLayout());
        this.allowEditing = new JCheckBox(Globals.lang("Allow editing in table cells"));
        this.memoryStick = new JCheckBox(Globals.lang("Load and Save preferences from/to jabref.xml on start-up (memory stick mode)"));
        this.defSort = new JCheckBox(Globals.lang("Sort Automatically"));
        this.ctrlClick = new JCheckBox(Globals.lang("Open right-click menu with Ctrl+left button"));
        this.useOwner = new JCheckBox(Globals.lang("Mark new entries with owner name") + ":");
        this.useTimeStamp = new JCheckBox(Globals.lang("Mark new entries with addition date") + ". " + Globals.lang("Date format") + ":");
        this.overwriteOwner = new JCheckBox(Globals.lang("Overwrite"));
        this.overwriteTimeStamp = new JCheckBox(Globals.lang("Overwrite"));
        this.overwriteOwner.setToolTipText(Globals.lang("If a pasted or imported entry already has the field set, overwrite."));
        this.overwriteTimeStamp.setToolTipText(Globals.lang("If a pasted or imported entry already has the field set, overwrite."));
        this.keyDuplicateWarningDialog = new JCheckBox(Globals.lang("Show warning dialog when a duplicate BibTeX key is entered"));
        this.keyEmptyWarningDialog = new JCheckBox(Globals.lang("Show warning dialog when an empty BibTeX key is entered"));
        this.enforceLegalKeys = new JCheckBox(Globals.lang("Enforce legal characters in BibTeX keys"));
        this.confirmDelete = new JCheckBox(Globals.lang("Show confirmation dialog when deleting entries"));
        this.useImportInspector = new JCheckBox(Globals.lang("Display imported entries in an inspection window before they are added."));
        this.useImportInspectorForSingle = new JCheckBox(Globals.lang("Use inspection window also when a single entry is imported."));
        this.markImportedEntries = new JCheckBox(Globals.lang("Mark entries imported into an existing database"));
        this.unmarkAllEntriesBeforeImporting = new JCheckBox(Globals.lang("Unmark all entries before importing new entries into an existing database"));
        this.defOwnerField = new JTextField();
        this.timeStampFormat = new JTextField();
        this.timeStampField = new JTextField();
        this.ownerHelp = new HelpAction(frame.helpDiag, GUIGlobals.ownerHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.timeStampHelp = new HelpAction(frame.helpDiag, GUIGlobals.timeStampHelp, "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.inspectionWarnDupli = new JCheckBox(Globals.lang("Warn about unresolved duplicates when closing inspection window"));
        Insets marg = new Insets(0, 12, 3, 0);
        this.useImportInspectorForSingle.setMargin(marg);
        this.inspectionWarnDupli.setMargin(marg);
        this.useImportInspector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                GeneralTab.this.useImportInspectorForSingle.setEnabled(GeneralTab.this.useImportInspector.isSelected());
                GeneralTab.this.inspectionWarnDupli.setEnabled(GeneralTab.this.useImportInspector.isSelected());
            }
        });
        FormLayout layout = new FormLayout("8dlu, 1dlu, left:170dlu, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, left:pref, 4dlu, left:pref, 4dlu, left:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Globals.lang("General"));
        builder.nextLine();
        builder.append((Component)this.useImportInspector, 13);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.useImportInspectorForSingle, 11);
        builder.nextLine();
        builder.append(new JPanel());
        builder.append((Component)this.inspectionWarnDupli, 11);
        builder.nextLine();
        builder.append((Component)this.ctrlClick, 13);
        builder.nextLine();
        builder.append((Component)this.confirmDelete, 13);
        builder.nextLine();
        builder.append((Component)this.keyDuplicateWarningDialog, 13);
        builder.nextLine();
        builder.append((Component)this.keyEmptyWarningDialog, 13);
        builder.nextLine();
        builder.append((Component)this.enforceLegalKeys, 13);
        builder.nextLine();
        builder.append((Component)this.memoryStick, 13);
        builder.append((Component)this.useOwner, 3);
        builder.append(this.defOwnerField);
        builder.append(this.overwriteOwner);
        builder.append((Component)new JPanel(), 3);
        JButton hlp = new JButton(this.ownerHelp);
        hlp.setText(null);
        hlp.setPreferredSize(new Dimension(24, 24));
        builder.append(hlp);
        builder.nextLine();
        builder.append((Component)this.useTimeStamp, 3);
        builder.append(this.timeStampFormat);
        builder.append(this.overwriteTimeStamp);
        builder.append(Globals.lang("Field name") + ":");
        builder.append(this.timeStampField);
        hlp = new JButton(this.timeStampHelp);
        hlp.setText(null);
        hlp.setPreferredSize(new Dimension(24, 24));
        builder.append(hlp);
        builder.nextLine();
        builder.append((Component)this.markImportedEntries, 13);
        builder.nextLine();
        builder.append((Component)this.unmarkAllEntriesBeforeImporting, 13);
        builder.nextLine();
        JLabel lab = new JLabel(Globals.lang("Language") + ":");
        builder.append((Component)lab, 3);
        builder.append(this.language);
        builder.nextLine();
        lab = new JLabel(Globals.lang("Default encoding") + ":");
        builder.append((Component)lab, 3);
        builder.append(this.encodings);
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    public void setValues() {
        this.allowEditing.setSelected(this._prefs.getBoolean("allowTableEditing"));
        this.defSort.setSelected(this._prefs.getBoolean("defaultAutoSort"));
        this.ctrlClick.setSelected(this._prefs.getBoolean("ctrlClick"));
        this.useOwner.setSelected(this._prefs.getBoolean("useOwner"));
        this.overwriteOwner.setSelected(this._prefs.getBoolean("overwriteOwner"));
        this.useTimeStamp.setSelected(this._prefs.getBoolean("useTimeStamp"));
        this.overwriteTimeStamp.setSelected(this._prefs.getBoolean("overwriteTimeStamp"));
        this.keyDuplicateWarningDialog.setSelected(this._prefs.getBoolean("dialogWarningForDuplicateKey"));
        this.keyEmptyWarningDialog.setSelected(this._prefs.getBoolean("dialogWarningForEmptyKey"));
        this.enforceLegalKeys.setSelected(this._prefs.getBoolean("enforceLegalBibtexKey"));
        this.memoryStick.setSelected(this._prefs.getBoolean("memoryStickMode"));
        this.confirmDelete.setSelected(this._prefs.getBoolean("confirmDelete"));
        this.defOwnerField.setText(this._prefs.get("defaultOwner"));
        this.timeStampFormat.setText(this._prefs.get("timeStampFormat"));
        this.timeStampField.setText(this._prefs.get("timeStampField"));
        this.useImportInspector.setSelected(this._prefs.getBoolean("useImportInspectionDialog"));
        this.useImportInspectorForSingle.setSelected(this._prefs.getBoolean("useImportInspectionDialogForSingle"));
        this.inspectionWarnDupli.setSelected(this._prefs.getBoolean("warnAboutDuplicatesInInspection"));
        this.useImportInspectorForSingle.setEnabled(this.useImportInspector.isSelected());
        this.inspectionWarnDupli.setEnabled(this.useImportInspector.isSelected());
        this.markImportedEntries.setSelected(this._prefs.getBoolean("markImportedEntries"));
        this.unmarkAllEntriesBeforeImporting.setSelected(this._prefs.getBoolean("unmarkAllEntriesBeforeImporting"));
        String enc = this._prefs.get("defaultEncoding");
        for (int i = 0; i < Globals.ENCODINGS.length; ++i) {
            if (!Globals.ENCODINGS[i].equalsIgnoreCase(enc)) continue;
            this.encodings.setSelectedIndex(i);
            break;
        }
        String oldLan = this._prefs.get("language");
        int ilk = 0;
        for (String lan : GUIGlobals.LANGUAGES.values()) {
            if (lan.equals(oldLan)) {
                this.language.setSelectedIndex(ilk);
            }
            ++ilk;
        }
    }

    public void storeSettings() {
        this._prefs.putBoolean("useOwner", this.useOwner.isSelected());
        this._prefs.putBoolean("overwriteOwner", this.overwriteOwner.isSelected());
        this._prefs.putBoolean("useTimeStamp", this.useTimeStamp.isSelected());
        this._prefs.putBoolean("overwriteTimeStamp", this.overwriteTimeStamp.isSelected());
        this._prefs.putBoolean("dialogWarningForDuplicateKey", this.keyDuplicateWarningDialog.isSelected());
        this._prefs.putBoolean("dialogWarningForEmptyKey", this.keyEmptyWarningDialog.isSelected());
        this._prefs.putBoolean("enforceLegalBibtexKey", this.enforceLegalKeys.isSelected());
        if (this._prefs.getBoolean("memoryStickMode") && !this.memoryStick.isSelected()) {
            JOptionPane.showMessageDialog(null, Globals.lang("To disable the memory stick mode rename or remove the jabref.xml file in the same folder as JabRef."), Globals.lang("Memory Stick Mode"), 1);
        }
        this._prefs.putBoolean("memoryStickMode", this.memoryStick.isSelected());
        this._prefs.putBoolean("confirmDelete", this.confirmDelete.isSelected());
        this._prefs.putBoolean("allowTableEditing", this.allowEditing.isSelected());
        this._prefs.putBoolean("ctrlClick", this.ctrlClick.isSelected());
        this._prefs.putBoolean("useImportInspectionDialog", this.useImportInspector.isSelected());
        this._prefs.putBoolean("useImportInspectionDialogForSingle", this.useImportInspectorForSingle.isSelected());
        this._prefs.putBoolean("warnAboutDuplicatesInInspection", this.inspectionWarnDupli.isSelected());
        String owner = this.defOwnerField.getText().trim();
        this._prefs.put("defaultOwner", owner);
        this._prefs.WRAPPED_USERNAME = "[" + owner + "]";
        this._prefs.put("timeStampFormat", this.timeStampFormat.getText().trim());
        this._prefs.put("timeStampField", this.timeStampField.getText().trim());
        this._prefs.put("defaultEncoding", (String)this.encodings.getSelectedItem());
        this._prefs.putBoolean("markImportedEntries", this.markImportedEntries.isSelected());
        this._prefs.putBoolean("unmarkAllEntriesBeforeImporting", this.unmarkAllEntriesBeforeImporting.isSelected());
        if (!GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).equals(this._prefs.get("language"))) {
            this._prefs.put("language", GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).toString());
            Globals.setLanguage(GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).toString(), "");
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed the language setting. You must restart JabRef for this to come into effect."), Globals.lang("Changed language settings"), 2);
        }
    }

    public boolean readyToClose() {
        try {
            new SimpleDateFormat(this.timeStampFormat.getText());
        }
        catch (IllegalArgumentException ex2) {
            JOptionPane.showMessageDialog(null, Globals.lang("The chosen date format for new entries is not valid"), Globals.lang("Invalid date format"), 0);
            return false;
        }
        return true;
    }

    public String getTabName() {
        return Globals.lang("General");
    }
}

