/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.Globals;

public class FontSelectorDialog
extends JDialog {
    private static final long serialVersionUID = -8670346696048738055L;
    static final String PLAIN = "plain";
    static final String BOLD = "bold";
    static final String BOLD_ITALIC = "bold-italic";
    static final String ITALIC = "italic";
    private boolean isOK;
    private JTextField familyField;
    private JList familyList;
    private JTextField sizeField;
    private JList sizeList;
    private JTextField styleField;
    private JList styleList;
    private JLabel preview;
    private JButton ok;
    private JButton cancel;
    private static final String[] HIDEFONTS = new String[]{".bold", ".italic"};

    public FontSelectorDialog(Component comp, Font font) {
        super(JOptionPane.getFrameForComponent(comp), Globals.lang("FontSelector"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel listPanel = new JPanel(new GridLayout(1, 3, 6, 6));
        this.familyField = new JTextField();
        this.familyList = new JList<String>(this.getFontList());
        JPanel familyPanel = this.createTextFieldAndListPanel(Globals.lang("Font Family"), this.familyField, this.familyList);
        listPanel.add(familyPanel);
        String[] sizes = new String[]{"9", "10", "12", "14", "16", "18", "24"};
        this.sizeField = new JTextField();
        this.sizeList = new JList<String>(sizes);
        JPanel sizePanel = this.createTextFieldAndListPanel(Globals.lang("Font Size"), this.sizeField, this.sizeList);
        listPanel.add(sizePanel);
        String[] styles = new String[]{PLAIN, BOLD, ITALIC, BOLD_ITALIC};
        this.styleField = new JTextField();
        this.styleList = new JList<String>(styles);
        JPanel stylePanel = this.createTextFieldAndListPanel(Globals.lang("Font Style"), this.styleField, this.styleList);
        this.styleField.setEditable(false);
        listPanel.add(stylePanel);
        this.familyList.setSelectedValue(font.getFamily(), true);
        this.familyField.setText(font.getFamily());
        this.sizeList.setSelectedValue(String.valueOf(font.getSize()), true);
        this.sizeField.setText(String.valueOf(font.getSize()));
        this.styleList.setSelectedIndex(font.getStyle());
        this.styleField.setText((String)this.styleList.getSelectedValue());
        ListHandler listHandler = new ListHandler();
        this.familyList.addListSelectionListener(listHandler);
        this.sizeList.addListSelectionListener(listHandler);
        this.styleList.addListSelectionListener(listHandler);
        content.add("North", listPanel);
        this.preview = new JLabel(Globals.lang("Font Preview")){
            private static final long serialVersionUID = -4191591634265068189L;

            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(g2);
            }
        };
        this.preview.setBorder(new TitledBorder(Globals.lang("Font Preview")));
        this.updatePreview();
        Dimension prefSize = this.preview.getPreferredSize();
        prefSize.height = 50;
        this.preview.setPreferredSize(prefSize);
        content.add("Center", this.preview);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttons.add(Box.createGlue());
        this.ok = new JButton(Globals.lang("OK"));
        this.ok.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.ok);
        buttons.add(this.ok);
        buttons.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.cancel.addActionListener(new ActionHandler());
        buttons.add(this.cancel);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.pack();
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(comp));
        this.setVisible(true);
    }

    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public Font getSelectedFont() {
        int size;
        if (!this.isOK) {
            return null;
        }
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception e) {
            size = 14;
        }
        return new Font(this.familyField.getText(), this.styleList.getSelectedIndex(), size);
    }

    private String[] getFontList() {
        try {
            Class<?> GEClass = Class.forName("java.awt.GraphicsEnvironment");
            Object GEInstance = GEClass.getMethod("getLocalGraphicsEnvironment", new Class[0]).invoke(null, new Object[0]);
            String[] nameArray = (String[])GEClass.getMethod("getAvailableFontFamilyNames", new Class[0]).invoke(GEInstance, new Object[0]);
            Vector<String> nameVector = new Vector<String>(nameArray.length);
            for (int i = 0; i < nameArray.length; ++i) {
                int j;
                for (j = 0; j < HIDEFONTS.length && nameArray[i].indexOf(HIDEFONTS[j]) < 0; ++j) {
                }
                if (j != HIDEFONTS.length) continue;
                nameVector.addElement(nameArray[i]);
            }
            Object[] _array = new String[nameVector.size()];
            nameVector.copyInto(_array);
            return _array;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private JPanel createTextFieldAndListPanel(String label, JTextField textField, JList list) {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.fill = 1;
        cons.weightx = 1.0;
        JLabel _label = new JLabel(label);
        layout.setConstraints(_label, cons);
        panel.add(_label);
        cons.gridy = 1;
        Component vs = Box.createVerticalStrut(6);
        layout.setConstraints(vs, cons);
        panel.add(vs);
        cons.gridy = 2;
        layout.setConstraints(textField, cons);
        panel.add(textField);
        cons.gridy = 3;
        vs = Box.createVerticalStrut(6);
        layout.setConstraints(vs, cons);
        panel.add(vs);
        cons.gridy = 4;
        cons.gridheight = 0;
        cons.weighty = 1.0;
        JScrollPane scroller = new JScrollPane(list);
        layout.setConstraints(scroller, cons);
        panel.add(scroller);
        return panel;
    }

    private void updatePreview() {
        int size;
        String family = this.familyField.getText();
        try {
            size = Integer.parseInt(this.sizeField.getText());
        }
        catch (Exception e) {
            size = 14;
        }
        int style = this.styleList.getSelectedIndex();
        this.preview.setFont(new Font(family, style, size));
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            String style;
            Object source = evt.getSource();
            if (source == FontSelectorDialog.this.familyList) {
                String family = (String)FontSelectorDialog.this.familyList.getSelectedValue();
                if (family != null) {
                    FontSelectorDialog.this.familyField.setText(family);
                }
            } else if (source == FontSelectorDialog.this.sizeList) {
                String size = (String)FontSelectorDialog.this.sizeList.getSelectedValue();
                if (size != null) {
                    FontSelectorDialog.this.sizeField.setText(size);
                }
            } else if (source == FontSelectorDialog.this.styleList && (style = (String)FontSelectorDialog.this.styleList.getSelectedValue()) != null) {
                FontSelectorDialog.this.styleField.setText(style);
            }
            FontSelectorDialog.this.updatePreview();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == FontSelectorDialog.this.ok) {
                FontSelectorDialog.this.ok();
            } else if (evt.getSource() == FontSelectorDialog.this.cancel) {
                FontSelectorDialog.this.cancel();
            }
        }
    }
}

