/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditListener;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.gui.AutoCompleteListener;

public class FieldTextField
extends JTextField
implements FieldEditor {
    protected String fieldName;
    protected JLabel label;
    private AutoCompleteListener autoCompleteListener = null;

    public FieldTextField(String fieldName_, String content, boolean changeColorOnFocus) {
        super(content);
        this.updateFont();
        this.addFocusListener(Globals.focusListener);
        if (changeColorOnFocus) {
            this.addFocusListener(new FieldEditorFocusListener());
        }
        this.fieldName = fieldName_;
        this.label = new FieldNameLabel(" " + Util.nCase(this.fieldName) + " ");
        this.setBackground(GUIGlobals.validFieldBackground);
        FieldTextMenu popMenu = new FieldTextMenu(this);
        this.addMouseListener(popMenu);
        this.label.addMouseListener(popMenu);
    }

    public void append(String text) {
        this.setText(this.getText() + text);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabelColor(Color c) {
        this.label.setForeground(c);
        throw new NullPointerException("ok");
    }

    public JComponent getPane() {
        return this;
    }

    public JComponent getTextComponent() {
        return this;
    }

    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
    }

    public void paste(String textToInsert) {
        int sel = this.getSelectionEnd() - this.getSelectionStart();
        if (sel < 1) {
            int cPos = this.getCaretPosition();
            this.select(cPos, cPos);
        }
        this.replaceSelection(textToInsert);
    }

    public boolean hasUndoInformation() {
        return false;
    }

    public void undo() {
    }

    public boolean hasRedoInformation() {
        return false;
    }

    public void redo() {
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.getDocument().addUndoableEditListener(listener);
    }

    public void setAutoCompleteListener(AutoCompleteListener listener) {
        this.autoCompleteListener = listener;
    }

    public void clearAutoCompleteSuggestion() {
        if (this.autoCompleteListener != null) {
            this.autoCompleteListener.clearCurrentSuggestion(this);
        }
    }
}

