/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;

public class BibLatexEntryTypes {
    public static final BibtexEntryType ARTICLE = new BibtexEntryType(){

        public String getName() {
            return "Article";
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "journaltitle", "year", "date"};
        }

        public String[] getOptionalFields() {
            return new String[]{"translator", "annotator", "commentator", "subtitle", "titleaddon", "editor", "editora", "editorb", "editorc", "journalsubtitle", "issuetitle", "issuesubtitle", "language", "origlanguage", "series", "volume", "number", "eid", "issue", "date", "month", "year", "pages", "version", "note", "issn", "addendum", "pubstate", "doi", "eprint", "eprinttype", "url", "urldate"};
        }

        public String[] getPrimaryOptionalFields() {
            return new String[]{"subtitle", "editor", "series", "volume", "number", "eid", "issue", "date", "month", "year", "pages", "note", "issn", "doi", "eprint", "eprinttype", "url", "urldate"};
        }

        public String describeRequiredFields() {
            return "";
        }

        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
    public static final BibtexEntryType BOOK = new BibtexEntryType(){

        public String getName() {
            return "Book";
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "year", "date"};
        }

        public String[] getOptionalFields() {
            return new String[]{"editor", "editora", "editorb", "editorc", "translator", "annotator", "commentator", "introduction", "foreword", "afterword", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "language", "origlanguage", "volume", "part", "edition", "volumes", "series", "number", "note", "publisher", "location", "isbn", "chapter", "pages", "pagetotal", "addendum", "pubstate", "doi", "eprint", "eprinttype", "url", "urldate"};
        }

        public String[] getPrimaryOptionalFields() {
            return new String[]{"editor", "subtitle", "titleaddon", "maintitle", "mainsubtitle", "maintitleaddon", "volume", "edition", "publisher", "isbn", "chapter", "pages", "pagetotal", "doi", "eprint", "eprinttype", "url", "urldate"};
        }

        public String describeRequiredFields() {
            return "";
        }

        public boolean hasAllRequiredFields(BibtexEntry entry, BibtexDatabase database) {
            return entry.allFieldsPresent(this.getRequiredFields(), database);
        }
    };
}

