/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class LongOption
extends Option {
    private long value;

    public LongOption() {
        this(0L);
    }

    public LongOption(LongOption op) {
        super(op);
        op.value = op.getValue();
    }

    public LongOption(long value) {
        this(value, null);
    }

    public LongOption(long value, String longOption) {
        this(value, longOption, '\u0000');
    }

    public LongOption(long value, char shortOption) {
        this(value, null, shortOption);
    }

    public LongOption(long value, String longOption, char shortOption) {
        super(longOption, shortOption);
        this.value = value;
    }

    public Object getObject() {
        return new Long(this.value);
    }

    public void modify(String value) throws OptionModificationException {
        try {
            this.value = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new OptionModificationException("Error. A long must be specified, not '" + value + "'.");
        }
    }

    public void setValue(String value) throws OptionModificationException {
        this.modify(value);
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public String getStringValue() {
        return Long.toString(this.value);
    }

    public String getTypeName() {
        return "LONG";
    }

    public String toString() {
        return this.getStringValue();
    }
}

