/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Tools {
    public static final String USERS_PASSWORDSALT = "spl";
    static final int BUFFER = 1024;

    public String cleanTitle(String title) {
        return title;
    }

    public int isTitleIdentical(String title1, String title2) {
        return 0;
    }

    public String extractTitleFromFile(File myfile) {
        String title = "";
        return title;
    }

    public static String convertToSaltedMD5Digest(String salt, String plainText) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update((String.valueOf(salt) + plainText).getBytes());
        byte[] md5Digest = md5.digest();
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < md5Digest.length) {
            stringBuilder.append(Tools.toHexString(md5Digest[i]));
            ++i;
        }
        return stringBuilder.toString();
    }

    public static void unzip(InputStream zipFile, File destinationFile) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(zipFile));
        if (zipInputStream.getNextEntry() != null) {
            int count;
            byte[] data = new byte[1024];
            while ((count = zipInputStream.read(data, 0, 1024)) != -1) {
                bufferedOutputStream.write(data, 0, count);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        zipInputStream.close();
    }

    public static StringBuilder unzip(InputStream zipFile) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(zipFile));
        StringBuilder stringBuilder = new StringBuilder();
        if (zipInputStream.getNextEntry() != null) {
            byte[] data = new byte[1024];
            while (zipInputStream.read(data, 0, 1024) != -1) {
                stringBuilder.append(new String(data));
            }
        } else {
            return Tools.unzipStringFromBytes(zipFile);
        }
        zipInputStream.close();
        return stringBuilder;
    }

    public static StringBuilder unzipStringFromBytes(InputStream stream) throws IOException {
        int len;
        BufferedInputStream bufis = new BufferedInputStream(new GZIPInputStream(stream));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = bufis.read(buf)) > 0) {
            bos.write(buf, 0, len);
        }
        String retval = bos.toString();
        bufis.close();
        bos.close();
        return new StringBuilder(retval);
    }

    public static int getFileSize(String mindmap) throws IOException {
        byte[] data = mindmap.getBytes();
        return Math.round(data.length / 1024);
    }

    public static String getStackTraceAsString(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(" [ ");
        pw.print(exception.getClass().getName());
        pw.print(" ] ");
        pw.print(exception.getMessage());
        exception.printStackTrace(pw);
        return sw.toString();
    }

    public static String toHexString(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        String ret = value < 16 ? "0" : "";
        ret = String.valueOf(ret) + Integer.toHexString(value).toUpperCase();
        return ret;
    }

    public static int levenshtein(int cut, String s1, String s2) {
        boolean diff = false;
        int len1 = s1.length();
        int len2 = s2.length();
        int[][] matrix = new int[len1 + 1][len2 + 1];
        matrix[0][0] = 0;
        int i = 1;
        while (i < len1 + 1) {
            matrix[i][0] = i;
            ++i;
        }
        int k = 1;
        while (k < len2 + 1) {
            matrix[0][k] = k;
            ++k;
        }
        int row = 1;
        while (row < len2 + 1) {
            int start = 1;
            if (row - cut > start) {
                start = row - cut;
            }
            int col = start;
            while (col < Math.min(row + cut + 1, len1 + 1)) {
                int cost = s1.charAt(col - 1) == s2.charAt(row - 1) ? 0 : 1;
                matrix[col][row] = col == row + cut ? Math.min(matrix[col - 1][row] + 1, matrix[col - 1][row - 1] + cost) : (col == row - cut ? Math.min(matrix[col][row - 1] + 1, matrix[col - 1][row - 1] + cost) : Math.min(matrix[col - 1][row] + 1, Math.min(matrix[col - 1][row - 1] + cost, matrix[col][row - 1] + 1)));
                diff = matrix[col][row] > cut;
                ++col;
            }
            if (diff) {
                matrix[len1][len2] = cut;
                break;
            }
            ++row;
        }
        return matrix[len1][len2];
    }

    public static boolean empty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return o.equals("");
        }
        if (o instanceof Short || o instanceof Integer) {
            return o.equals(new Short(0));
        }
        return false;
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(date.getTime());
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar();
            xmlGregorianCalendar.setYear(calendar.get(1));
            xmlGregorianCalendar.setMonth(calendar.get(2));
            xmlGregorianCalendar.setDay(calendar.get(5));
            xmlGregorianCalendar.setHour(calendar.get(11));
            xmlGregorianCalendar.setMinute(calendar.get(12));
            xmlGregorianCalendar.setSecond(calendar.get(13));
            return xmlGregorianCalendar;
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            datatypeConfigurationException.printStackTrace();
            return null;
        }
    }

    public static boolean isValidUsername(String userName) {
        char[] chars;
        char[] cArray = chars = userName.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char aChar = cArray[n2];
            if (!Character.isLetterOrDigit(aChar) && aChar != '.' && aChar != '-' && aChar != '_') {
                return false;
            }
            ++n2;
        }
        try {
            Double.valueOf(userName);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public static boolean isValidEmailAddress(String aEmailAddress) {
        if (aEmailAddress == null) {
            return false;
        }
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(aEmailAddress);
            if (!Tools.hasNameAndDomain(aEmailAddress)) {
                result = false;
            }
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    private static boolean hasNameAndDomain(String aEmailAddress) {
        String[] tokens = aEmailAddress.split("@");
        return tokens.length == 2 && Tools.textHasContent(tokens[0]) && Tools.textHasContent(tokens[1]);
    }

    private static boolean textHasContent(String aText) {
        return aText != null && aText.trim().length() > 0;
    }
}

