/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.sciplore.resources.Feedback;
import org.sciplore.resources.Mindmap;
import org.sciplore.resources.Resource;

@Entity
@Table(name="mindmap_nodes")
public class MindmapNode
extends Resource {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="mindmaprevision_id")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Mindmap mindmap;
    private String nodeId;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private MindmapNode parent;
    @OneToMany(mappedBy="parent")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Feedback> children = new HashSet<Feedback>();
    private Date created;
    private Date modified;
    private String text;

    public MindmapNode() {
    }

    public MindmapNode(Session s) {
        this.setSession(s);
    }

    public void create(Mindmap mindmap, String nodeID, MindmapNode parent, Date created, Date modified, String text) {
        this.setMindmap(mindmap);
        this.setNodeID(nodeID);
        this.setParent(parent);
        this.setCreated(created);
        this.setModified(modified);
        this.setText(text);
        this.save();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getNodeID() {
        return this.nodeId;
    }

    public void setNodeID(String nodeID) {
        this.nodeId = nodeID;
    }

    public MindmapNode getParent() {
        return this.parent;
    }

    public void setParent(MindmapNode parent) {
        this.parent = parent;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Mindmap getMindmap() {
        return this.mindmap;
    }

    public void setMindmap(Mindmap mindmap) {
        this.mindmap = mindmap;
    }

    public Set<Feedback> getChildren() {
        return this.children;
    }

    public void setChildren(Set<Feedback> children) {
        this.children = children;
    }
}

