/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;
import org.sciplore.resources.User;
import org.sciplore.tools.SciploreResponseCode;

@Entity
public class Feedback
extends Resource {
    @OneToMany(mappedBy="parent")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Feedback> children = new HashSet<Feedback>();
    private Date created;
    @ManyToOne
    @JoinColumn(name="document_id")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Document document;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @ManyToOne
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Feedback parent;
    private Short rating;
    private String text;
    private String title;
    private Short type;
    @ManyToOne
    @JoinColumn(name="user_id")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private User user;
    private Short valid;

    public Feedback getFeedback(Feedback f) {
        if (f.getId() != null) {
            return this.getFeedback(f.getId());
        }
        return null;
    }

    public Feedback getFeedback(Integer id) {
        return (Feedback)this.getSession().get(Feedback.class, (Serializable)id);
    }

    public Feedback() {
    }

    public Feedback(Session s) {
        this.setSession(s);
    }

    public SciploreResponseCode create(String username, String password, Document document, String title, String text, Short type, Short rating) {
        return this.create(username, password, null, document, title, text, type, rating);
    }

    public SciploreResponseCode create(String username, String password, Feedback parent, Document document, String title, String text, Short type, Short rating) {
        User user = new User(this.getSession()).getUserByEmailOrUsername(username);
        if (user == null) {
            return new SciploreResponseCode(420, "Username invalid.");
        }
        if (!user.checkCredentials(password)) {
            return new SciploreResponseCode(401, "Password wrong.");
        }
        if ((title == null || title.isEmpty()) && (text == null || text.isEmpty()) && rating == null) {
            return new SciploreResponseCode(400, "Post at least a title, a text or a rating");
        }
        if (type != null && type != 1 && type != 2 && type != 3) {
            return new SciploreResponseCode(400, "Invalid rating Type. Must be 1-3.");
        }
        this.setCreated(new GregorianCalendar().getTime());
        this.setUser(user);
        this.setDocument(document);
        this.setTitle(title);
        this.setText(text);
        this.setType(type);
        this.setRating(rating);
        this.setValid((short)1);
        this.setParent(parent);
        this.save();
        return new SciploreResponseCode(200, "Feedback created.");
    }

    public Feedback(int id) {
        this.id = id;
    }

    public void addChild(Feedback c) {
        this.children.add(c);
    }

    public Set<Feedback> getChildren() {
        return this.children;
    }

    public Date getCreated() {
        return this.created;
    }

    public Document getDocument() {
        return this.document;
    }

    public Integer getId() {
        return this.id;
    }

    public Feedback getParent() {
        return this.parent;
    }

    public Short getRating() {
        return this.rating;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public Short getType() {
        return this.type;
    }

    public User getUser() {
        return this.user;
    }

    public Short getValid() {
        return this.valid;
    }

    public void setChildren(Set<Feedback> children) {
        this.children = children;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setParent(Feedback parent) {
        this.parent = parent;
    }

    public void setRating(Short rating) {
        this.rating = rating;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }
}

