/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Resource;
import org.sciplore.tools.Tools;

@Entity
@Table(name="applications")
public class Application
extends Resource {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(nullable=false)
    private Integer id;
    private Integer applicationId;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private String key;
    @Column(nullable=false)
    private String version;
    @Column(nullable=false)
    private Date releaseDate;
    @Column(nullable=false)
    private Short valid;
    private Short versionStatus;
    private String releaseNote;
    private Short priority;

    public Application() {
    }

    public Application(Session s) {
        this.setSession(s);
    }

    public Application getApplication(Application a) {
        if (a.getId() != null) {
            return this.getApplication(a.getId());
        }
        return this.getApplication(a.getKey(), a.getVersion());
    }

    public Application getApplication(Integer id) {
        return (Application)this.getSession().get(Application.class, (Serializable)id);
    }

    public Application getApplication(String key, String version) {
        return (Application)this.getSession().createCriteria(Application.class).add((Criterion)Restrictions.eq((String)"key", (Object)key)).add((Criterion)Restrictions.eq((String)"version", (Object)version)).setMaxResults(1).uniqueResult();
    }

    public Application getApplication(String name) {
        return (Application)this.getSession().createCriteria(Application.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).setMaxResults(1).uniqueResult();
    }

    public List<Application> getApplicationByAppId(Integer appID) {
        return this.getSession().createCriteria(Application.class).add((Criterion)Restrictions.eq((String)"applicationId", (Object)appID)).list();
    }

    public Application getApplicationByAppId(Integer appID, String version) {
        return (Application)this.getSession().createCriteria(Application.class).add((Criterion)Restrictions.eq((String)"applicationId", (Object)appID)).add((Criterion)Restrictions.eq((String)"version", (Object)version)).setMaxResults(1).uniqueResult();
    }

    public Application getApplicationByAppVersion(String name, String version) {
        return (Application)this.getSession().createCriteria(Application.class).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add((Criterion)Restrictions.eq((String)"version", (Object)version)).setMaxResults(1).uniqueResult();
    }

    public Application sync(Application app) {
        Application a = this.getApplication(app);
        if (a == null) {
            a = app;
        } else {
            if (Tools.empty(a.getId()) && !Tools.empty(app.getId())) {
                a.setId(app.getId());
            }
            if (Tools.empty(a.getKey()) && !Tools.empty(app.getKey())) {
                a.setKey(app.getKey());
            }
            if (Tools.empty(a.getName()) && !Tools.empty(app.getName())) {
                a.setName(app.getName());
            }
            if (Tools.empty(a.getReleaseDate()) && !Tools.empty(app.getReleaseDate())) {
                a.setReleaseDate(app.getReleaseDate());
            }
            if (Tools.empty(a.getValid()) && !Tools.empty(app.getValid())) {
                a.setValid(app.getValid());
            }
            if (Tools.empty(a.getVersion()) && !Tools.empty(app.getVersion())) {
                a.setVersion(app.getVersion());
            }
        }
        return a;
    }

    public Integer getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public Short getValid() {
        return this.valid;
    }

    public String getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Integer getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(Integer applicationId) {
        this.applicationId = applicationId;
    }

    public Short getVersionStatus() {
        return this.versionStatus;
    }

    public void setVersionStatus(Short versionStatus) {
        this.versionStatus = versionStatus;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public void setReleaseNote(String releaseNote) {
        this.releaseNote = releaseNote;
    }

    public Short getPriority() {
        return this.priority;
    }

    public void setPriority(Short priority) {
        this.priority = priority;
    }
}

