/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class StreamTools {
    public static final int MAX_BUFFER = 100000;

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(IRandomAccess ra) {
        try {
            if (ra != null) {
                ra.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(RandomAccessFile ra) {
        try {
            if (ra != null) {
                ra.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copyEncoded(Reader reader, Writer writer) throws IOException {
        try {
            char[] c = new char[100000];
            int i = reader.read(c);
            while (i != -1) {
                writer.write(c, 0, i);
                i = reader.read(c);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("copying failed (" + e.getMessage() + ")");
        }
    }

    public static void copyEncodedStream(InputStream source, String sourceEncoding, OutputStream destination, String destinationEncoding) throws IOException {
        if (sourceEncoding == null | destinationEncoding == null | sourceEncoding.equals(destinationEncoding)) {
            StreamTools.copyStream(source, false, destination, false);
        }
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            reader = new InputStreamReader(source, sourceEncoding);
            writer = new OutputStreamWriter(destination, destinationEncoding);
            char[] c = new char[100000];
            int i = reader.read(c);
            while (i != -1) {
                writer.write(c, 0, i);
                i = reader.read(c);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("copying failed (" + e.getMessage() + ")");
        }
    }

    public static void copyStream(InputStream source, boolean closeInput, OutputStream destination, boolean closeOutput) throws IOException {
        try {
            try {
                byte[] b = new byte[100000];
                int i = source.read(b);
                while (i != -1) {
                    destination.write(b, 0, i);
                    i = source.read(b);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw ExceptionTools.createIOException("copying failed (" + e.getMessage() + ")", e);
            }
        }
        finally {
            if (closeInput) {
                StreamTools.close(source);
            }
            if (closeOutput) {
                StreamTools.close(destination);
            }
        }
    }

    public static void copyStream(InputStream source, OutputStream destination) throws IOException {
        StreamTools.copyStream(source, true, destination, true);
    }

    public static void copyStream(InputStream source, OutputStream destination, long length) throws IOException {
        try {
            long toRead = length;
            byte[] b = new byte[(int)length];
            while (toRead > 0L) {
                int i = source.read(b, 0, (int)toRead);
                if (i != -1) {
                    destination.write(b, 0, i);
                    toRead -= (long)i;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("copying failed (" + e.getMessage() + ")");
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamTools.copyStream(is, os);
        return os.toByteArray();
    }

    public static String toString(InputStream is, String encoding) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamTools.copyStream(is, os);
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return os.toString(encoding);
    }

    public static String toString(Reader r) throws IOException {
        StringWriter w = new StringWriter();
        StreamTools.copyEncoded(r, w);
        return w.toString();
    }

    private StreamTools() {
    }
}

