/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import java.io.IOException;
import java.io.Reader;

public class FillReader
extends Reader {
    private String pattern;
    private boolean closed = false;
    private int pos = 0;

    public FillReader(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern may not be null");
        }
        this.pattern = pattern;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            int c = this.read();
            if (c == -1) {
                return off - i;
            }
            cbuf[i] = (char)c;
            ++i;
        }
        return len;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.pos >= this.pattern.length()) {
            if (this.pattern.length() == 0) {
                return -1;
            }
            this.pos = 0;
        }
        return this.pattern.charAt(this.pos++);
    }
}

