/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public abstract class AbstractRandomAccess
implements IRandomAccess {
    private Stack positionStack = new Stack();

    public InputStream asInputStream() {
        return new MyInputStream();
    }

    public OutputStream asOutputStream() {
        return new MyOutputStream();
    }

    public void mark() throws IOException {
        this.getPositionStack().push(new Long(this.getOffset()));
    }

    public void reset() throws IOException {
        if (this.getPositionStack().isEmpty()) {
            this.seek(0L);
        } else {
            this.seek((Long)this.getPositionStack().pop());
        }
    }

    protected Stack getPositionStack() {
        return this.positionStack;
    }

    class MyInputStream
    extends InputStream {
        private long offset = 0L;

        public int read() throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int i = AbstractRandomAccess.this.read();
            if (i != -1) {
                ++this.offset;
            }
            return i;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int i = AbstractRandomAccess.this.read(b, off, len);
            if (i != -1) {
                this.offset += (long)i;
            }
            return i;
        }

        public int read(byte[] b) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int i = AbstractRandomAccess.this.read(b);
            if (i != -1) {
                this.offset += (long)i;
            }
            return i;
        }

        public void close() throws IOException {
        }
    }

    class MyOutputStream
    extends OutputStream {
        private long offset = 0L;

        public void write(int b) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(b);
            ++this.offset;
        }

        public void write(byte[] b) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(b);
            this.offset += (long)b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(b, off, len);
            this.offset += (long)len;
        }

        public void close() throws IOException {
        }
    }
}

